/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.business.company.service;

import com.xforceplus.api.model.CompanyModel;
import com.xforceplus.business.company.dto.TenantCompany;
import com.xforceplus.business.company.service.CompanyService;
import com.xforceplus.business.excel.BusinessType;
import com.xforceplus.business.excel.SimpleExcelWriter;
import com.xforceplus.business.excel.company.CompanyExcelDTO;
import com.xforceplus.business.excel.reader.Context;
import com.xforceplus.business.excel.writer.ExcelConfigBusinessType;
import com.xforceplus.business.service.ExcelWriteService;
import com.xforceplus.entity.Company;
import io.geewit.core.utils.reflection.BeanUtils;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;

@Service
public class CompanyExcelExportServiceImpl
implements ExcelWriteService {
    private final CompanyService companyService;

    public CompanyExcelExportServiceImpl(CompanyService companyService) {
        this.companyService = companyService;
    }

    @Override
    public BusinessType getBusinessType() {
        return ExcelConfigBusinessType.COMPANY_EXCEL_FILE;
    }

    @Override
    public void write(Context context) {
        CompanyModel.Request.Query query = context.getParam("P_QUERY", CompanyModel.Request.Query.class);
        Sort sort = context.getParam("P_SORT", Sort.class);
        List<String> sheetNames = Arrays.asList(query.getSheets());
        SimpleExcelWriter simpleExcelWriter = context.getSimpleExcelWriter();
        Integer maxPageSize = context.getMaxPageSize();
        for (String sheetName : sheetNames) {
            if (!"\u516c\u53f8\u4fe1\u606f".equals(sheetName)) continue;
            this.writeCompanySheet(query, sort, simpleExcelWriter, sheetName, maxPageSize);
        }
    }

    private void writeCompanySheet(CompanyModel.Request.Query query, Sort sort, SimpleExcelWriter simpleExcelWriter, String sheetName, Integer maxPageSize) {
        Page<Company> page;
        PageRequest pageable = PageRequest.of((int)0, (int)1000, (Sort)sort.and(Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"createTime"})));
        Map<Long, TenantCompany> tenantCompanyMap = this.companyService.findTenantCompanyAll();
        do {
            page = this.companyService.page(query, (Pageable)pageable);
            try {
                Page companyExcelPage = page.map(companyExcel -> {
                    CompanyExcelDTO dto = new CompanyExcelDTO();
                    BeanUtils.copyProperties((Object)companyExcel, (Object)dto, (String[])new String[]{"taxNum"});
                    dto.setTaxNum(StringUtils.trimToEmpty((String)companyExcel.getTaxNum()));
                    if (tenantCompanyMap.containsKey(companyExcel.getCompanyId())) {
                        TenantCompany tenantCompany = (TenantCompany)tenantCompanyMap.get(companyExcel.getCompanyId());
                        dto.setTenantName(tenantCompany.getTenantName());
                        dto.setTenantCode(tenantCompany.getTenantCode());
                    }
                    return dto;
                });
                simpleExcelWriter.fill(sheetName, companyExcelPage.getContent());
            }
            catch (Exception e) {
                simpleExcelWriter.setException(e);
                break;
            }
        } while (page.hasNext() && (pageable = pageable.next()) != null && page.getNumber() < maxPageSize);
        simpleExcelWriter.param("SUCCESS_SIZE", this.calcSuccessSize(page));
    }
}

