/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.business.company.service;

import com.alibaba.excel.event.AnalysisEventListener;
import com.xforceplus.api.model.CompanyModel;
import com.xforceplus.business.company.service.CompanyService;
import com.xforceplus.business.excel.BusinessType;
import com.xforceplus.business.excel.ExcelSheet;
import com.xforceplus.business.excel.company.CompanyExcelImportDTO;
import com.xforceplus.business.excel.reader.Context;
import com.xforceplus.business.excel.reader.MessageRow;
import com.xforceplus.business.excel.reader.SimpleDataReadListener;
import com.xforceplus.business.excel.writer.ExcelConfigBusinessType;
import com.xforceplus.business.file.controller.FileController;
import com.xforceplus.business.service.ExcelReaderService;
import com.xforceplus.business.tenant.service.OrgService;
import com.xforceplus.dao.TenantDao;
import com.xforceplus.entity.Company;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class CompanyImportService
implements ExcelReaderService {
    public static final String ACTION_ADD = "\u65b0\u5efa";
    public static final String ACTION_UPDATE = "\u4fee\u6539";
    public static final List<String> ACTION_LIST = Arrays.asList("\u65b0\u5efa", "\u4fee\u6539");
    private final Logger log = LoggerFactory.getLogger(FileController.class);
    private final TenantDao tenantDao;
    private final OrgService orgService;
    private final CompanyService companyService;

    public CompanyImportService(TenantDao tenantDao, OrgService orgService, CompanyService companyService) {
        this.tenantDao = tenantDao;
        this.orgService = orgService;
        this.companyService = companyService;
    }

    @Override
    public BusinessType getBusinessType() {
        return ExcelConfigBusinessType.COMPANY_EXCEL_FILE;
    }

    @Override
    public Context importExcel(Context context) {
        List<ExcelSheet> sheets = context.getExcelBook().getExcelSheets();
        for (ExcelSheet sheet : sheets) {
            MessageRow messageRows = new MessageRow(sheet.getSheetName());
            AnalysisEventListener excelDataListener = SimpleDataReadListener.listener(context, rows -> this.saveImport(messageRows, context, (List<CompanyExcelImportDTO>)rows));
            context.getSimpleExcelReader().read(CompanyExcelImportDTO.class, excelDataListener);
        }
        return context;
    }

    public void saveImport(MessageRow messageRow, Context context, List<CompanyExcelImportDTO> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        for (CompanyExcelImportDTO dto : list) {
            Company company;
            if (!dto.getValidatedStatus().booleanValue()) {
                messageRow.fail(dto.getRowIndex(), dto.getValidatedMessage());
                continue;
            }
            if (!ACTION_LIST.contains(dto.getAction())) {
                messageRow.fail(dto.getRowIndex(), "\u64cd\u4f5c\u7c7b\u578b\u4e0d\u6b63\u786e\uff0c\u64cd\u4f5c\u7c7b\u578b\u5e94\u8be5\u4e3a:{\u65b0\u5efa,\u4fee\u6539}");
                continue;
            }
            if (!this.isExistedTenantByTenantCode(dto).booleanValue()) {
                messageRow.fail(dto.getRowIndex(), "\u79df\u6237code(" + dto.getTenantCode() + ")\u627e\u4e0d\u5230\u5bf9\u5e94\u79df\u6237");
                this.log.warn("sheetName:{},rowIndex:{},\u79df\u6237code:{}:\u627e\u4e0d\u5230\u5bf9\u5e94\u79df\u6237", new Object[]{messageRow.getSheetName(), dto.getRowIndex(), dto.getTenantCode()});
                continue;
            }
            if (ACTION_ADD.equals(dto.getAction()) && this.isExistedCompanyByTaxNum(dto).booleanValue()) {
                messageRow.fail(dto.getRowIndex(), "\u5df2\u5b58\u516c\u53f8\u7a0e\u53f7\uff1a(" + dto.getTaxNum() + ")\u7684\u516c\u53f8");
                this.log.warn("sheetName:{},rowIndex:{},\u5df2\u5b58\u5728\u4e2a\u516c\u53f8\u540d\u79f0\u4e3a:({}),\u7a0e\u53f7({})\u7684\u516c\u53f8", new Object[]{messageRow.getSheetName(), dto.getRowIndex(), dto.getCompanyName(), dto.getTaxNum()});
                continue;
            }
            if (ACTION_UPDATE.equals(dto.getAction()) && !this.isExistedCompanyByTaxNum(dto).booleanValue()) {
                messageRow.fail(dto.getRowIndex(), "\u672a\u627e\u5230\u66f4\u65b0\u516c\u53f8\u7a0e\u53f7(" + dto.getTaxNum() + ")\u7684\u516c\u53f8");
                this.log.warn("sheetName:{},rowIndex:{},\u672a\u627e\u5230\u66f4\u65b0\u516c\u53f8\u540d\u79f0\u4e3a\uff1a({}),\u7a0e\u53f7({})\u7684\u516c\u53f8", new Object[]{messageRow.getSheetName(), dto.getRowIndex(), dto.getCompanyName(), dto.getTaxNum()});
                continue;
            }
            CompanyModel.Request.Save model = new CompanyModel.Request.Save();
            BeanUtils.copyProperties((Object)dto, (Object)model);
            try {
                company = this.orgService.saveCompanyAsync(dto.getTenantId(), model);
            }
            catch (RuntimeException e) {
                this.log.warn("sheetName:{},\u4fdd\u5b58\u6570\u636e\u5931\u8d25:tenantCode:{},companyName:{}", new Object[]{messageRow.getSheetName(), dto.getTenantCode(), dto.getCompanyName()});
                this.log.error(e.getMessage(), (Throwable)e);
                messageRow.fail(dto.getRowIndex(), dto.getAction() + "\u6570\u636e\u5f02\u5e38");
                continue;
            }
            if (company == null) {
                messageRow.fail(dto.getRowIndex(), dto.getAction() + "\u6570\u636e\u5931\u8d25");
                this.log.warn("sheetName:{},\u4fdd\u5b58\u6570\u636e\u5931\u8d25:tenantCode:{},companyName:{}", new Object[]{messageRow.getSheetName(), dto.getTenantCode(), dto.getCompanyName()});
                continue;
            }
            messageRow.success(dto.getRowIndex());
        }
        context.messageRow(messageRow.getSheetName(), messageRow);
    }

    protected Boolean isExistedTenantByTenantCode(CompanyExcelImportDTO dto) {
        Long tenantId = this.tenantDao.findTenantIdByTenantCode(dto.getTenantCode());
        if (tenantId == null) {
            return Boolean.FALSE;
        }
        dto.setTenantId(tenantId);
        return Boolean.TRUE;
    }

    protected Boolean isExistedCompanyByTaxNum(CompanyExcelImportDTO dto) {
        List<Company> companies = this.companyService.findListByTaxNum(dto.getTaxNum());
        if (CollectionUtils.isEmpty(companies)) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }
}

