/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.business.company.service;

import com.xforceplus.api.model.CompanyPackageModel;
import com.xforceplus.business.company.service.CompanyServicePackageService;
import com.xforceplus.business.excel.BusinessType;
import com.xforceplus.business.excel.SimpleExcelWriter;
import com.xforceplus.business.excel.company.CompanyPackageDTO;
import com.xforceplus.business.excel.reader.Context;
import com.xforceplus.business.excel.writer.ExcelConfigBusinessType;
import com.xforceplus.business.service.ExcelWriteService;
import com.xforceplus.tenant.core.exception.UnknownException;
import java.util.List;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class CompanyServicePackageExcelExportServiceImpl
implements ExcelWriteService {
    private final CompanyServicePackageService companyServicePackageService;

    public CompanyServicePackageExcelExportServiceImpl(CompanyServicePackageService companyServicePackageService) {
        this.companyServicePackageService = companyServicePackageService;
    }

    @Override
    public BusinessType getBusinessType() {
        return ExcelConfigBusinessType.COMPANY_PACKAGE_IMPORT;
    }

    @Override
    public void write(Context context) {
        String[] sheetNames;
        CompanyPackageModel.Request.CompanyPackageExport export = context.getParam("P_QUERY", CompanyPackageModel.Request.CompanyPackageExport.class);
        SimpleExcelWriter simpleExcelWriter = context.getSimpleExcelWriter();
        List<CompanyPackageDTO> companyPackageDTOList = this.companyServicePackageService.getBatchExportData(export.getCompanyIds(), export.getTenantIds());
        if (CollectionUtils.isEmpty(companyPackageDTOList)) {
            throw new UnknownException("\u5bfc\u51fa\u5931\u8d25\uff0c\u6ca1\u6709\u83b7\u53d6\u5230\u516c\u53f8");
        }
        for (String sheetName : sheetNames = export.getSheets()) {
            if (!"\u516c\u53f8\u670d\u52a1\u5305\u5217\u8868".equals(sheetName)) continue;
            simpleExcelWriter.fill(sheetName, companyPackageDTOList);
        }
    }
}

