/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.business.company.service;

import com.xforceplus.api.model.CompanyModel;
import com.xforceplus.api.model.OrgModel;
import com.xforceplus.business.company.service.CompanyTenantRelOperationService;
import com.xforceplus.business.company.service.CompanyTenantRelService;
import com.xforceplus.business.tenant.service.OrgService;
import com.xforceplus.business.tenant.service.WrapperOrgService;
import com.xforceplus.dao.CompanyTenantRelDao;
import com.xforceplus.dao.CompanyTenantRelOperationDao;
import com.xforceplus.domain.company.CompanyTenantRelOperationDto;
import com.xforceplus.domain.tenant.TenantDto;
import com.xforceplus.entity.CompanyTenantRel;
import com.xforceplus.entity.CompanyTenantRelOperation;
import com.xforceplus.entity.OrgStruct;
import com.xforceplus.entity.Tenant;
import com.xforceplus.tenant.security.core.context.UserInfoHolder;
import com.xforceplus.tenant.security.core.domain.IAuthorizedUser;
import com.xforceplus.tenant.security.core.domain.OrgType;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class CompanyTenantRelOperationProcess {
    private static final Logger log = LoggerFactory.getLogger(CompanyTenantRelOperationProcess.class);
    @Autowired
    private CompanyTenantRelOperationService operationService;
    @Autowired
    private CompanyTenantRelOperationDao operationDao;
    @Autowired
    private CompanyTenantRelService companyTenantRelService;
    @Autowired
    private CompanyTenantRelDao companyTenantRelDao;
    @Autowired
    private OrgService orgService;
    @Autowired
    private WrapperOrgService wrapperOrgService;

    @Transactional(rollbackFor={RuntimeException.class})
    public void accept(long operationId, String remark) {
        CompanyTenantRelOperation operation = this.operationService.findById(operationId, Collections.emptySet());
        if (CompanyTenantRelOperationDto.Status.ACCEPTED.value() == operation.getStatus().intValue()) {
            throw new IllegalArgumentException("\u8be5\u9080\u8bf7\u5df2\u7ecf\u63a5\u53d7\u4e86, \u8bf7\u4e0d\u8981\u91cd\u590d\u64cd\u4f5c");
        }
        if (CompanyTenantRelOperationDto.Status.REFUSED.value() == operation.getStatus().intValue()) {
            throw new IllegalArgumentException("\u8be5\u9080\u8bf7\u5df2\u7ecf\u88ab\u62d2\u7edd\u4e86");
        }
        if (CompanyTenantRelOperationDto.Status.CANCELED.value() == operation.getStatus().intValue()) {
            throw new IllegalArgumentException("\u8be5\u9080\u8bf7\u5df2\u7ecf\u88ab\u53d6\u6d88\u4e86");
        }
        operation.setStatus(Integer.valueOf(CompanyTenantRelOperationDto.Status.ACCEPTED.value()));
        operation.setRelatedCompanyCode(remark);
        operation = (CompanyTenantRelOperation)this.operationDao.save((Object)operation);
        List existRels = this.companyTenantRelDao.findByTenantIdAndCompanyId(operation.getTenantId().longValue(), operation.getCompanyId().longValue());
        if (existRels != null && !existRels.isEmpty()) {
            for (CompanyTenantRel existRel : existRels) {
                if ((existRel.getSwitches() ^ operation.getSwitches()) <= 0) continue;
                this.companyTenantRelService.save(operation.getInvitingCompanyId(), operation.getInvitingCompanyName(), operation.getCompanyId(), operation.getTenantId(), operation.getRelatedCompanyId(), operation.getRelatedTenantId(), operation.getSwitches(), existRel.getSwitches(), operation.getInvoiceStartDate(), operation.getStatementStartDate(), remark);
            }
        } else {
            OrgStruct parentOrg;
            List<OrgStruct> parentOrgs = this.orgService.findByTenantIdAndCompanyId(operation.getRelatedTenantId(), operation.getCompanyId());
            if (parentOrgs.isEmpty()) {
                Page<OrgStruct> rootOrgsPage = this.orgService.findRoots(operation.getRelatedTenantId(), Pageable.unpaged());
                long relatedTenantId = operation.getRelatedTenantId();
                parentOrg = (OrgStruct)rootOrgsPage.stream().findAny().orElseThrow(() -> new IllegalArgumentException("\u88ab\u9080\u8bf7\u7684\u79df\u6237(" + relatedTenantId + ")\u6ca1\u6709\u6839\u7ec4\u7ec7"));
            } else {
                parentOrg = (OrgStruct)parentOrgs.stream().findAny().orElseThrow(() -> new IllegalArgumentException("\u88ab\u9080\u8bf7\u7684\u79df\u6237\u6ca1\u6709\u7236\u7ec4\u7ec7"));
            }
            OrgModel.Request.Save saveOrg = new OrgModel.Request.Save();
            saveOrg.setTenantId(operation.getRelatedTenantId());
            saveOrg.setOrgName(operation.getCompanyName());
            saveOrg.setOrgDesc(operation.getCompanyName() + "(\u5916\u90e8\u5173\u8054\u7684\u516c\u53f8)");
            saveOrg.setOrgType(OrgType.COMPANY);
            saveOrg.setOverwrite(Boolean.TRUE.booleanValue());
            saveOrg.setParentId(parentOrg.getOrgId());
            saveOrg.setStatus(Integer.valueOf(1));
            CompanyModel.Request.Save companySave = new CompanyModel.Request.Save();
            companySave.setCompanyId(operation.getCompanyId());
            companySave.setCompanyName(operation.getCompanyName());
            companySave.setTaxNum(operation.getTaxNum());
            companySave.setCompanyCode(operation.getCompanyCode());
            saveOrg.setCompany(companySave);
            saveOrg.setUniqueCompany(Boolean.TRUE);
            saveOrg.setWithApplication(Boolean.FALSE.booleanValue());
            saveOrg.setIsAutoBindParentOrgUsers(Boolean.TRUE);
            saveOrg.setIsStrict(Boolean.FALSE);
            this.wrapperOrgService.create(saveOrg);
            this.companyTenantRelService.save(operation.getInvitingCompanyId(), operation.getInvitingCompanyName(), operation.getCompanyId(), operation.getTenantId(), operation.getRelatedCompanyId(), operation.getRelatedTenantId(), operation.getSwitches(), 0, operation.getInvoiceStartDate(), operation.getStatementStartDate(), remark);
        }
    }

    @Transactional(rollbackFor={RuntimeException.class})
    public void refuse(long operationId, String remark) {
        IAuthorizedUser authorizedUser = UserInfoHolder.currentUser();
        CompanyTenantRelOperation operation = this.operationService.findById(operationId, Collections.emptySet());
        if (!operation.getRelatedTenantId().equals(authorizedUser.getTenantId())) {
            throw new IllegalArgumentException("\u5f53\u524d\u767b\u5f55\u8d26\u6237\u6240\u5728\u79df\u6237(" + authorizedUser.getTenantName() + ")\u548c\u53d7\u9080\u79df\u6237(" + operation.getRelatedTenantName() + ")\u4e0d\u4e00\u81f4");
        }
        if (CompanyTenantRelOperationDto.Status.ACCEPTED.value() == operation.getStatus().intValue()) {
            throw new IllegalArgumentException("\u8be5\u9080\u8bf7\u5df2\u7ecf\u63a5\u53d7\u4e86");
        }
        if (CompanyTenantRelOperationDto.Status.REFUSED.value() == operation.getStatus().intValue()) {
            throw new IllegalArgumentException("\u8be5\u9080\u8bf7\u5df2\u7ecf\u88ab\u62d2\u7edd\u4e86, \u8bf7\u4e0d\u8981\u91cd\u590d\u64cd\u4f5c");
        }
        if (CompanyTenantRelOperationDto.Status.CANCELED.value() == operation.getStatus().intValue()) {
            throw new IllegalArgumentException("\u8be5\u9080\u8bf7\u5df2\u7ecf\u88ab\u53d6\u6d88\u4e86");
        }
        operation.setStatus(Integer.valueOf(CompanyTenantRelOperationDto.Status.REFUSED.value()));
        operation.setAuditRemark(remark);
        this.operationDao.save((Object)operation);
    }

    @Transactional(rollbackFor={Exception.class})
    public void unrelateById(long relId) {
        IAuthorizedUser authorizedUser = UserInfoHolder.currentUser();
        CompanyTenantRel existRel = this.companyTenantRelService.findById(relId);
        if (!(authorizedUser.getTenantId().equals(existRel.getTenantId()) || authorizedUser.getTenantId().equals(existRel.getRelatedTenantId()) || authorizedUser.getTenantId().equals(existRel.getHostTenantId()))) {
            throw new IllegalArgumentException("\u6ca1\u6709\u6743\u9650\u6267\u884c\u6b64\u64cd\u4f5c");
        }
        existRel.fillTenant();
        existRel.fillCompany();
        existRel.fillRelatedEntity();
        if (existRel.getCompany() != null) {
            Tenant hostTenant = existRel.getCompany().getHostTenant();
            existRel.fillHostTenant((TenantDto)hostTenant);
        }
        this.orgService.deleteByTenantIdAndCompanyId(existRel.getRelatedTenantId(), existRel.getCompanyId());
        this.companyTenantRelDao.deleteById((Object)existRel.getId());
        this.operationService.saveUnrelateOperation(authorizedUser, existRel.getCompany(), existRel);
    }
}

