/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.business.company.service;

import com.xforceplus.api.model.CompanyTenantRelOperationModel;
import com.xforceplus.api.model.OrgModel;
import com.xforceplus.business.company.service.CompanyTenantRelService;
import com.xforceplus.business.tenant.service.OrgService;
import com.xforceplus.dao.CompanyDao;
import com.xforceplus.dao.CompanyTenantRelAuditDao;
import com.xforceplus.dao.CompanyTenantRelDao;
import com.xforceplus.dao.CompanyTenantRelOperationDao;
import com.xforceplus.dao.OrgStructDao;
import com.xforceplus.dao.TenantDao;
import com.xforceplus.domain.company.CompanyTenantRelOperationDto;
import com.xforceplus.domain.company.Switch;
import com.xforceplus.entity.Company;
import com.xforceplus.entity.CompanyTenantRel;
import com.xforceplus.entity.CompanyTenantRelOperation;
import com.xforceplus.entity.OrgStruct;
import com.xforceplus.entity.Tenant;
import com.xforceplus.query.CompanyTenantRelOperationQueryHelper;
import com.xforceplus.query.OrgQueryHelper;
import com.xforceplus.tenant.security.core.context.UserInfoHolder;
import com.xforceplus.tenant.security.core.domain.IAuthorizedUser;
import com.xforceplus.tenant.security.core.domain.OrgType;
import io.geewit.core.utils.enums.BinaryUtils;
import io.geewit.data.jpa.essential.domain.EntityGraphs;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.persistence.Tuple;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class CompanyTenantRelOperationService {
    private static final Logger logger = LoggerFactory.getLogger(CompanyTenantRelOperationService.class);
    private final CompanyTenantRelOperationDao operationDao;
    @Autowired
    private CompanyTenantRelService relService;
    @Autowired
    private OrgStructDao orgDao;
    @Autowired
    private TenantDao tenantDao;
    @Autowired
    private CompanyDao companyDao;
    @Autowired
    private CompanyTenantRelDao companyTenantRelDao;
    @Autowired
    private CompanyTenantRelAuditDao auditDao;
    @Autowired
    private OrgService orgService;

    public CompanyTenantRelOperationService(CompanyTenantRelOperationDao operationDao) {
        this.operationDao = operationDao;
    }

    @Transactional
    public CompanyTenantRelOperation invite(CompanyTenantRelOperationModel.Request.Invitation model) {
        Tenant relatedTenant;
        IAuthorizedUser authorizedUser = UserInfoHolder.currentUser();
        Long tenantId = authorizedUser.getTenantId();
        OrgModel.Request.Query query = new OrgModel.Request.Query();
        query.setCompanyId(model.getInvitingCompanyId());
        query.setTenantId(tenantId);
        query.setStatus(Integer.valueOf(1));
        List invitingOrgs = this.orgDao.findAll(OrgQueryHelper.querySpecification((OrgModel.Request.Query)query));
        if (invitingOrgs.isEmpty()) {
            throw new IllegalArgumentException("\u9080\u8bf7\u65b9\u516c\u53f8\u5728\u5f53\u524d\u79df\u6237\u4e0b\u4e0d\u4e0d\u5b58\u5728");
        }
        Company company = null;
        Long hostTenantId = null;
        if (model.getCompanyName() != null && model.getTaxNum() != null) {
            List companies = this.orgDao.findCompaniesByTenantIdAndCompanyNameAndTaxNum(tenantId.longValue(), model.getCompanyName(), model.getTaxNum());
            if (companies == null || companies.isEmpty()) {
                String message = "\u975e\u6cd5\u7684\u516c\u53f8\u7a0e\u53f7(" + model.getTaxNum() + ")\u548c\u540d\u79f0(" + model.getCompanyName() + ")";
                logger.info(message);
                throw new IllegalArgumentException(message);
            }
            company = (Company)companies.stream().findFirst().get();
            hostTenantId = company.getHostTenantId();
        }
        if ((relatedTenant = this.tenantDao.findByTenantCode(model.getInvitatedTenantCode())) == null) {
            throw new IllegalArgumentException("\u4e0d\u5b58\u5728\u7684\u79df\u6237\u4ee3\u7801(" + model.getInvitatedTenantCode() + ")");
        }
        if (relatedTenant.getTenantId().equals(company.getHostTenantId())) {
            throw new IllegalArgumentException("\u53d7\u9080\u65b9\u79df\u6237\u548c\u516c\u53f8\u6240\u5c5e\u79df\u6237\u4e0d\u80fd\u4e3a\u540c\u4e00\u4e2a");
        }
        CompanyTenantRel existRel = this.companyTenantRelDao.findByTenantIdAndCompanyIdAndRelatedTenantId(tenantId.longValue(), company.getCompanyId().longValue(), relatedTenant.getTenantId().longValue());
        if (existRel != null) {
            throw new IllegalArgumentException("\u5df2\u7ecf\u5b58\u5728\u6709\u4e00\u6a21\u4e00\u6837\u7684\u914d\u7f6e\u4e86, \u4e0d\u7528\u91cd\u590d\u63d0\u4ea4");
        }
        List existOperations = this.operationDao.findInvitionsByTenantIdAndCompanyIdAndRelatedTenantId(tenantId.longValue(), company.getCompanyId().longValue(), relatedTenant.getTenantId().longValue());
        if (CollectionUtils.isNotEmpty((Collection)existOperations)) {
            throw new IllegalArgumentException("\u5df2\u7ecf\u5b58\u5728\u6709\u4e00\u6a21\u4e00\u6837\u7684\u9080\u8bf7\u4e86, \u4e0d\u7528\u91cd\u590d\u63d0\u4ea4");
        }
        int switches = Switch.toValue((Collection)model.getSwitches());
        CompanyTenantRelOperation operation = new CompanyTenantRelOperation();
        operation.setTenantId(authorizedUser.getTenantId());
        operation.setTenantCode(authorizedUser.getTenantCode());
        operation.setTenantName(authorizedUser.getTenantName());
        operation.setCompanyId(company.getCompanyId());
        operation.setTaxNum(company.getTaxNum());
        operation.setCompanyName(company.getCompanyName());
        operation.setCompanyCode(company.getCompanyCode());
        operation.setSwitches(Integer.valueOf(switches));
        operation.setInviteRemark(model.getRemark());
        if (model.getInvitingCompanyId() != null && model.getInvitingCompanyId() > 0L) {
            Company invitingCompany = this.orgDao.findCompanyByTenantIdAndCompanyId(tenantId.longValue(), model.getInvitingCompanyId().longValue());
            if (invitingCompany == null) {
                throw new IllegalArgumentException("\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u6240\u5c5e\u79df\u6237\u4e3b\u4f53\u516c\u53f8(" + model.getInvitingCompanyId() + ")");
            }
            operation.setInvitingCompanyId(invitingCompany.getCompanyId());
            operation.setInvitingCompanyName(invitingCompany.getCompanyName());
        }
        this.fillSwitches(operation, switches, model.getInvoiceStartDate(), model.getStatementStartDate());
        OrgModel.Request.Query orgQuery = new OrgModel.Request.Query();
        orgQuery.setTenantId(relatedTenant.getTenantId());
        orgQuery.setOrgType(OrgType.COMPANY.name());
        orgQuery.setTaxNum(model.getInvitatedTaxNum());
        orgQuery.setCompanyNameEqual(model.getInvitatedCompanyName());
        List companyOrgs = this.orgDao.findAll(OrgQueryHelper.querySpecification((OrgModel.Request.Query)orgQuery), EntityGraphs.named((String)"Org.graph"));
        if (companyOrgs.isEmpty()) {
            String message = String.format("\u53d7\u9080\u65b9\u4fe1\u606f\u9519\u8bef, \u516c\u53f8\u540d\u79f0(" + model.getInvitatedCompanyName() + "), \u7a0e\u53f7(" + model.getInvitatedTaxNum() + ")", new Object[0]);
            throw new IllegalArgumentException(message);
        }
        OrgStruct relatedOrg = (OrgStruct)companyOrgs.stream().findFirst().get();
        operation.setRelatedTenantId(relatedTenant.getTenantId());
        operation.setRelatedTenantCode(relatedTenant.getTenantCode());
        operation.setRelatedTenantName(relatedTenant.getTenantName());
        operation.setRelatedCompanyId(relatedOrg.getCompanyId());
        operation.setRelatedCompanyCode(relatedOrg.getCompanyCode());
        operation.setRelatedCompanyName(relatedOrg.getCompanyName());
        operation.setRelatedTaxNum(relatedOrg.getTaxNum());
        operation.setStatus(Integer.valueOf(CompanyTenantRelOperationDto.Status.INITED.value()));
        operation.setOperationType(Integer.valueOf(0));
        operation = (CompanyTenantRelOperation)this.operationDao.save((Object)operation);
        if (company != null) {
            operation.setCompany(company);
        }
        return operation;
    }

    public Page<CompanyTenantRelOperation> page(CompanyTenantRelOperationModel.Request.Query query, Pageable pageable) {
        Page page;
        boolean isTuple = false;
        boolean hasHostTenantId = false;
        boolean hasHostTenantCode = false;
        boolean hasHostTenantName = false;
        if (query.getWithExtendParamSet() != null && !query.getWithExtendParamSet().isEmpty()) {
            for (String withExtendParam : query.getWithExtendParamSet()) {
                if ("hostTenantId".equalsIgnoreCase(withExtendParam)) {
                    hasHostTenantId = true;
                    query.setHasHostTenantId(hasHostTenantId);
                    continue;
                }
                if ("hostTenantCode".equalsIgnoreCase(withExtendParam)) {
                    hasHostTenantCode = true;
                    query.setHasHostTenantCode(hasHostTenantCode);
                    continue;
                }
                if (!"hostTenantName".equalsIgnoreCase(withExtendParam)) continue;
                hasHostTenantName = true;
                query.setHasHostTenantName(hasHostTenantName);
            }
            isTuple = hasHostTenantId | hasHostTenantCode | hasHostTenantName;
            query.setTuple(isTuple);
        }
        if (isTuple) {
            Page tuples = this.operationDao.findTuples(query, pageable);
            List contents = tuples.getContent().stream().map(tuple -> {
                CompanyTenantRelOperation operation = (CompanyTenantRelOperation)tuple.get("operation", CompanyTenantRelOperation.class);
                if (operation != null) {
                    String hostTenantName;
                    String hostTenantCode;
                    Long hostTenantId;
                    if (query.isHasHostTenantId() && (hostTenantId = (Long)tuple.get("hostTenantId", Long.class)) != null) {
                        operation.setHostTenantId(hostTenantId);
                    }
                    if (query.isHasHostTenantCode() && (hostTenantCode = (String)tuple.get("hostTenantCode", String.class)) != null) {
                        operation.setHostTenantCode(hostTenantCode);
                    }
                    if (query.isHasHostTenantName() && (hostTenantName = (String)tuple.get("hostTenantName", String.class)) != null) {
                        operation.setHostTenantName(hostTenantName);
                    }
                }
                return operation;
            }).collect(Collectors.toList());
            page = new PageImpl(contents, pageable, tuples.getTotalElements());
        } else {
            Specification specification = CompanyTenantRelOperationQueryHelper.querySpecification((CompanyTenantRelOperationModel.Request.Query)query);
            page = this.operationDao.findAll(specification, pageable);
        }
        return page;
    }

    public List<CompanyTenantRelOperation> list(Specification<CompanyTenantRelOperation> specification, Sort sort) {
        return this.operationDao.findAll(specification, sort);
    }

    public CompanyTenantRelOperation findById(long operationId, Set<String> withExtendParams) {
        CompanyTenantRelOperation operation;
        boolean isTuple = false;
        boolean hasHostTenantId = false;
        boolean hasHostTenantCode = false;
        boolean hasHostTenantName = false;
        if (withExtendParams != null && !withExtendParams.isEmpty()) {
            for (String withExtendParam : withExtendParams) {
                if ("hostTenantId".equalsIgnoreCase(withExtendParam)) {
                    hasHostTenantId = true;
                    continue;
                }
                if ("hostTenantCode".equalsIgnoreCase(withExtendParam)) {
                    hasHostTenantCode = true;
                    continue;
                }
                if (!"hostTenantName".equalsIgnoreCase(withExtendParam)) continue;
                hasHostTenantName = true;
            }
            isTuple = hasHostTenantId | hasHostTenantCode | hasHostTenantName;
        }
        if (isTuple) {
            String hostTenantName;
            String hostTenantCode;
            Long hostTenantId;
            Tuple tuple;
            CompanyTenantRelOperationModel.Request.Query query = new CompanyTenantRelOperationModel.Request.Query();
            query.setId(Long.valueOf(operationId));
            query.setTuple(isTuple);
            if (hasHostTenantId) {
                query.setHasHostTenantId(true);
            }
            if (hasHostTenantCode) {
                query.setHasHostTenantCode(true);
            }
            if (hasHostTenantName) {
                query.setHasHostTenantName(true);
            }
            if ((operation = (CompanyTenantRelOperation)(tuple = this.operationDao.findTuple(query)).get("operation", CompanyTenantRelOperation.class)) == null) {
                throw new IllegalArgumentException("\u672a\u627e\u5230\u516c\u53f8\u79df\u6237\u5173\u8054\u5173\u7cfb(" + operationId + ")\u64cd\u4f5c\u5b9e\u4f53");
            }
            if (hasHostTenantId && (hostTenantId = (Long)tuple.get("hostTenantId", Long.class)) != null) {
                operation.setHostTenantId(hostTenantId);
            }
            if (hasHostTenantCode && (hostTenantCode = (String)tuple.get("hostTenantCode", String.class)) != null) {
                operation.setHostTenantCode(hostTenantCode);
            }
            if (hasHostTenantName && (hostTenantName = (String)tuple.get("hostTenantName", String.class)) != null) {
                operation.setHostTenantName(hostTenantName);
            }
        } else {
            operation = (CompanyTenantRelOperation)this.operationDao.findById((Object)operationId).orElseThrow(() -> new IllegalArgumentException("\u672a\u627e\u5230\u516c\u53f8\u79df\u6237\u5173\u8054\u5173\u7cfb(" + operationId + ")\u64cd\u4f5c\u5b9e\u4f53"));
        }
        return operation;
    }

    @Transactional(rollbackFor={RuntimeException.class})
    public void cancel(long operationId) {
        IAuthorizedUser authorizedUser = UserInfoHolder.currentUser();
        CompanyTenantRelOperation operation = this.findById(operationId, Collections.emptySet());
        if (operation.getStatus().intValue() == CompanyTenantRelOperationDto.Status.CANCELED.value()) {
            throw new IllegalArgumentException("\u5f53\u524d\u9080\u8bf7\u5df2\u7ecf\u64a4\u9500\u4e86");
        }
        if (!authorizedUser.getTenantId().equals(operation.getCreaterTenantId())) {
            throw new IllegalArgumentException("\u5f53\u524d\u767b\u5f55\u7528\u6237\u6240\u5728\u79df\u6237\u548c\u8be5\u9080\u8bf7\u521b\u5efa\u4eba\u6240\u5728\u79df\u6237\u4e0d\u4e00\u81f4");
        }
        operation.setStatus(Integer.valueOf(CompanyTenantRelOperationDto.Status.CANCELED.value()));
        this.operationDao.save((Object)operation);
    }

    private void fillSwitches(CompanyTenantRelOperation operation, int switches, Date invoiceStartDate, Date statementStartDate) {
        if (BinaryUtils.is((Enum)Switch.INVOICE, (int)switches)) {
            if (invoiceStartDate == null) {
                throw new IllegalArgumentException("\u5f00\u542f\u5305\u542b\u5386\u53f2\u53d1\u7968\u5fc5\u987b\u586b\u5199\u5171\u4eab\u5386\u53f2\u53d1\u7968\u8d77\u59cb\u65e5\u671f");
            }
            operation.setInvoiceStartDate(invoiceStartDate);
        } else {
            operation.setInvoiceStartDate(null);
        }
        if (BinaryUtils.is((Enum)Switch.STATEMENT, (int)switches)) {
            if (statementStartDate == null) {
                throw new IllegalArgumentException("\u5f00\u542f\u5305\u542b\u5386\u53f2\u7ed3\u7b97\u5355\u5fc5\u987b\u586b\u5199\u5171\u4eab\u5386\u53f2\u7ed3\u7b97\u5355\u8d77\u59cb\u65e5\u671f");
            }
            operation.setStatementStartDate(statementStartDate);
        } else {
            operation.setStatementStartDate(null);
        }
    }

    public CompanyTenantRelOperation saveUnrelateOperation(IAuthorizedUser authorizedUser, Company company, CompanyTenantRel existRel) {
        CompanyTenantRelOperation operation = new CompanyTenantRelOperation();
        operation.setInvitingCompanyId(existRel.getInvitingCompanyId());
        operation.setInvitingCompanyName(existRel.getInvitingCompanyName());
        operation.setTenantId(existRel.getTenantId());
        operation.setTenantCode(existRel.getTenantCode());
        operation.setTenantName(existRel.getTenantName());
        operation.setCompanyId(company.getCompanyId());
        operation.setHostTenantId(existRel.getHostTenantId());
        operation.setHostTenantName(existRel.getHostTenantName());
        operation.setHostTenantCode(existRel.getHostTenantCode());
        operation.setTaxNum(company.getTaxNum());
        operation.setCompanyName(company.getCompanyName());
        operation.setCompanyCode(company.getCompanyCode());
        operation.setSwitches(existRel.getSwitches());
        operation.setRelatedTenantId(existRel.getRelatedTenantId());
        operation.setRelatedTenantCode(existRel.getRelatedTenantCode());
        operation.setRelatedTenantName(existRel.getRelatedTenantName());
        operation.setRelatedCompanyId(existRel.getRelatedCompanyId());
        operation.setRelatedCompanyName(existRel.getRelatedCompanyName());
        operation.setRelatedTaxNum(existRel.getRelatedTaxNum());
        operation.setRelatedCompanyCode(existRel.getRelatedCompanyCode());
        operation.setOperationType(Integer.valueOf(1));
        operation = (CompanyTenantRelOperation)this.operationDao.save((Object)operation);
        return operation;
    }
}

