/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.business.company.service;

import com.xforceplus.api.model.CompanyTenantRelModel;
import com.xforceplus.dao.CompanyDao;
import com.xforceplus.dao.CompanyTenantRelAuditDao;
import com.xforceplus.dao.CompanyTenantRelDao;
import com.xforceplus.dao.CompanyTenantRelOperationDao;
import com.xforceplus.dao.OrgStructDao;
import com.xforceplus.dao.TenantDao;
import com.xforceplus.domain.company.Switch;
import com.xforceplus.domain.tenant.TenantDto;
import com.xforceplus.entity.Company;
import com.xforceplus.entity.CompanyTenantRel;
import com.xforceplus.entity.CompanyTenantRelAudit;
import com.xforceplus.entity.Tenant;
import com.xforceplus.query.CompanyTenantRelQueryHelper;
import com.xforceplus.tenant.security.core.context.UserInfoHolder;
import com.xforceplus.tenant.security.core.domain.IAuthorizedUser;
import io.geewit.core.utils.enums.BinaryUtils;
import io.geewit.data.jpa.essential.domain.EntityGraphs;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.time.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class CompanyTenantRelService {
    private static final Logger logger = LoggerFactory.getLogger(CompanyTenantRelService.class);
    private final CompanyTenantRelDao companyTenantRelDao;
    @Autowired
    private CompanyTenantRelAuditDao auditDao;
    @Autowired
    private CompanyTenantRelOperationDao operationDao;
    @Autowired
    private OrgStructDao orgDao;
    @Autowired
    private CompanyDao companyDao;
    @Autowired
    private TenantDao tenantDao;

    public CompanyTenantRelService(CompanyTenantRelDao companyTenantRelDao) {
        this.companyTenantRelDao = companyTenantRelDao;
    }

    public Page<CompanyTenantRel> page(CompanyTenantRelModel.Request.Query query, Pageable pageable) {
        Specification specification = CompanyTenantRelQueryHelper.querySpecification((CompanyTenantRelModel.Request.Query)query);
        Page page = this.companyTenantRelDao.findAll(specification, pageable, EntityGraphs.named((String)"CompanyTenantRel.graph"));
        return page;
    }

    public List<CompanyTenantRel> list(CompanyTenantRelModel.Request.Query query, Sort sort) {
        Specification specification = CompanyTenantRelQueryHelper.querySpecification((CompanyTenantRelModel.Request.Query)query);
        List list = this.companyTenantRelDao.findAll(specification, sort, EntityGraphs.named((String)"CompanyTenantRel.graph"));
        return list;
    }

    public List<CompanyTenantRel> list(Specification<CompanyTenantRel> specification, Sort sort) {
        return this.companyTenantRelDao.findAll(specification, sort, EntityGraphs.named((String)"CompanyTenantRel.graph"));
    }

    public CompanyTenantRel findById(long relId) {
        return (CompanyTenantRel)this.companyTenantRelDao.findById((Serializable)Long.valueOf(relId), EntityGraphs.named((String)"CompanyTenantRel.graph")).orElseThrow(() -> new IllegalArgumentException("\u672a\u627e\u5230\u516c\u53f8\u79df\u6237\u5173\u8054\u5173\u7cfb\u5b9e\u4f53"));
    }

    public Tenant findHostTenantByCompanyId(long companyId) {
        Tenant hostTenant = this.companyDao.findHostTenantByCompanyId(companyId);
        return hostTenant;
    }

    public CompanyTenantRelModel.Response.Info info(long relId) {
        Optional hostTenantOptional;
        CompanyTenantRel rel = this.findById(relId);
        rel.fillCompany();
        rel.fillRelatedEntity();
        rel.fillTenant();
        Company company = rel.getCompany();
        if (company != null && company.getHostTenantId() != null && (hostTenantOptional = this.tenantDao.findById((Object)company.getHostTenantId())).isPresent()) {
            rel.fillHostTenant((TenantDto)hostTenantOptional.get());
        }
        CompanyTenantRelModel.Response.Info info = new CompanyTenantRelModel.Response.Info();
        info.setCompanyId(rel.getCompanyId());
        info.setCompanyName(rel.getCompanyName());
        info.setTaxNum(rel.getTaxNum());
        info.setTenantId(rel.getTenantId());
        info.setTenantName(rel.getTenantName());
        info.setHostTenantId(rel.getHostTenantId());
        info.setHostTenantName(rel.getHostTenantName());
        info.setRelatedCompanyId(rel.getRelatedCompanyId());
        info.setRelatedCompanyName(rel.getRelatedCompanyName());
        info.setRelatedTaxNum(rel.getRelatedTaxNum());
        info.setRelatedTenantId(rel.getRelatedTenantId());
        info.setRelatedTenantName(rel.getRelatedTenantName());
        int switches = rel.getSwitches() != null ? rel.getSwitches() : 0;
        int switchSize = BinaryUtils.fromBinary((int)switches, Switch.class).size();
        List audits = this.auditDao.findAuditsByRelId(rel.getId().longValue(), rel.getSwitches().intValue());
        HashMap<Switch, CompanyTenantRelModel.Response.History> historiesMap = new HashMap<Switch, CompanyTenantRelModel.Response.History>();
        for (CompanyTenantRelAudit audit : audits) {
            int auditSwitches;
            int n = auditSwitches = audit.getSwitches() == null ? 0 : audit.getSwitches();
            if ((auditSwitches &= switches) == 0) continue;
            int switchAdditions = audit.getSwitchAdditions() == null ? 0 : audit.getSwitchAdditions();
            switchAdditions &= switches;
            boolean isOver = false;
            for (Switch switchMask : Switch.values()) {
                if (!BinaryUtils.is((Enum)switchMask, (int)switchAdditions) || historiesMap.containsKey(switchMask)) continue;
                CompanyTenantRelModel.Response.History history = new CompanyTenantRelModel.Response.History();
                history.setSwitches(auditSwitches);
                history.setOnSwitch(switchMask);
                if (Switch.INVOICE.equals((Object)switchMask)) {
                    history.setStartDate(audit.getInvoiceStartDate());
                } else if (Switch.STATEMENT.equals((Object)switchMask)) {
                    history.setStartDate(audit.getStatementStartDate());
                }
                history.setGrantTime(audit.getCreateTime());
                history.setRemark(audit.getRemark());
                historiesMap.put(switchMask, history);
                boolean bl = isOver = historiesMap.size() == switchSize;
                if (isOver) break;
            }
            if (!isOver) continue;
            break;
        }
        ArrayList histories = new ArrayList(historiesMap.values());
        Collections.sort(histories, new Comparator<CompanyTenantRelModel.Response.History>(){

            @Override
            public int compare(CompanyTenantRelModel.Response.History h1, CompanyTenantRelModel.Response.History h2) {
                return h1.getOnSwitch().compareTo((Enum)h2.getOnSwitch());
            }
        });
        info.setHistories(histories);
        return info;
    }

    @Transactional
    public void update(long relId, CompanyTenantRelModel.Request.Update model) {
        IAuthorizedUser authorizedUser = UserInfoHolder.currentUser();
        CompanyTenantRel existRel = this.findById(relId);
        Optional companyOptional = this.companyDao.findById((Object)existRel.getCompanyId());
        Company company = null;
        if (!companyOptional.isPresent()) {
            throw new IllegalArgumentException("\u8be5\u516c\u53f8(" + existRel.getCompanyId() + ")\u5df2\u7ecf\u4e0d\u5b58\u5728\u4e86");
        }
        company = (Company)companyOptional.get();
        Long hostTenantId = company.getHostTenantId();
        if (hostTenantId != null && !hostTenantId.equals(authorizedUser.getTenantId())) {
            throw new IllegalArgumentException("\u8be5\u516c\u53f8(" + existRel.getCompanyId() + ")\u7684\u4e3b\u79df\u6237\u5df2\u7ecf\u4e0d\u662f\u60a8\u5f53\u524d\u767b\u5f55\u8d26\u6237\u7684\u79df\u6237\u4e86");
        }
        int newSwitches = Switch.toValue((Collection)model.getSwitches());
        CompanyTenantRelAudit audit = this.fillRelAndAudit(existRel, newSwitches, existRel.getSwitches(), model.getInvoiceStartDate(), model.getStatementStartDate());
        existRel = (CompanyTenantRel)this.companyTenantRelDao.save((Object)existRel);
        audit.setRelId(existRel.getId());
        audit.setRemark(model.getRemark());
        this.auditDao.save((Object)audit);
    }

    @Transactional
    public CompanyTenantRel save(long invitingCompanyId, String invitingCompanyName, long companyId, long tenantId, long relatedCompanyId, long relatedTenantId, int switches, int existSwitches, Date invoiceStartDate, Date statementStartDate, String remark) {
        IAuthorizedUser authorizedUser = UserInfoHolder.currentUser();
        CompanyTenantRel rel = this.companyTenantRelDao.findByCompanyIdAndTenantIdAndRelatedTenantId(companyId, tenantId, relatedTenantId);
        if (rel == null) {
            rel = new CompanyTenantRel();
            rel.setInvitingCompanyId(Long.valueOf(invitingCompanyId));
            rel.setInvitingCompanyName(invitingCompanyName);
            rel.setCompanyId(Long.valueOf(companyId));
            rel.setTenantId(Long.valueOf(tenantId));
            rel.setRelatedCompanyId(Long.valueOf(relatedCompanyId));
            rel.setRelatedTenantId(Long.valueOf(relatedTenantId));
            rel.setSwitches(Integer.valueOf(switches));
        }
        CompanyTenantRelAudit audit = this.fillRelAndAudit(rel, switches, existSwitches, invoiceStartDate, statementStartDate);
        rel = (CompanyTenantRel)this.companyTenantRelDao.save((Object)rel);
        audit.setRelId(rel.getId());
        audit.setRemark(remark);
        this.auditDao.save((Object)audit);
        return rel;
    }

    public CompanyTenantRelAudit fillRelAndAudit(CompanyTenantRel rel, int switches, int existSwitches, Date invoiceStartDate, Date statementStartDate) {
        CompanyTenantRelAudit audit = new CompanyTenantRelAudit();
        int switchAdditions = 0;
        int switchDiffs = existSwitches ^ switches;
        switchAdditions = switchDiffs & switches;
        rel.setSwitches(Integer.valueOf(switches));
        Date now = null;
        if (BinaryUtils.is((Enum)Switch.INVOICE, (int)switches)) {
            if (invoiceStartDate == null) {
                throw new IllegalArgumentException("\u5f00\u542f\u5305\u542b\u5386\u53f2\u53d1\u7968\u5fc5\u987b\u586b\u5199\u5171\u4eab\u5386\u53f2\u53d1\u7968\u8d77\u59cb\u65e5\u671f");
            }
            audit.setInvoiceStartDate(invoiceStartDate);
            if (rel.getInvoiceStartDate() == null || !DateUtils.isSameDay((Date)invoiceStartDate, (Date)rel.getInvoiceStartDate())) {
                switchAdditions |= BinaryUtils.toBinary((Enum)Switch.INVOICE);
            }
            rel.setInvoiceStartDate(invoiceStartDate);
            if (now == null) {
                now = Calendar.getInstance().getTime();
            }
            rel.setInvoiceGrantedTime(now);
        } else {
            rel.setInvoiceStartDate(null);
        }
        if (BinaryUtils.is((Enum)Switch.STATEMENT, (int)switches)) {
            if (statementStartDate == null) {
                throw new IllegalArgumentException("\u5f00\u542f\u5305\u542b\u5386\u53f2\u7ed3\u7b97\u5355\u5fc5\u987b\u586b\u5199\u5171\u4eab\u5386\u53f2\u7ed3\u7b97\u5355\u8d77\u59cb\u65e5\u671f");
            }
            audit.setStatementStartDate(statementStartDate);
            if (rel.getStatementStartDate() == null || !DateUtils.isSameDay((Date)statementStartDate, (Date)rel.getStatementStartDate())) {
                switchAdditions |= BinaryUtils.toBinary((Enum)Switch.STATEMENT);
            }
            rel.setStatementStartDate(statementStartDate);
            if (now == null) {
                now = Calendar.getInstance().getTime();
            }
            rel.setStatementGrantedTime(now);
        } else {
            rel.setStatementStartDate(null);
        }
        audit.setSwitches(Integer.valueOf(switches));
        audit.setSwitchAdditions(Integer.valueOf(switchAdditions));
        if (now == null) {
            now = Calendar.getInstance().getTime();
        }
        audit.setCreateTime(now);
        return audit;
    }
}

