/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.business.company.service.impl;

import com.xforceplus.business.company.service.CompanyHistoryService;
import com.xforceplus.business.company.service.CompanyService;
import com.xforceplus.dao.CompanyDao;
import com.xforceplus.domain.company.CompanyHisDTO;
import com.xforceplus.entity.Company;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class CompanyHistoryServiceImpl
implements CompanyHistoryService {
    private final CompanyDao companyDao;
    private final CompanyService companyService;

    public CompanyHistoryServiceImpl(CompanyDao companyDao, CompanyService companyService) {
        this.companyDao = companyDao;
        this.companyService = companyService;
    }

    @Override
    @Transactional(readOnly=true, rollbackFor={RuntimeException.class})
    public Optional<Company> findByHisTaxNum(String taxNum) {
        return this.companyDao.findCompanyHistoryByTaxNum(taxNum);
    }

    @Override
    @Transactional(readOnly=true, rollbackFor={RuntimeException.class})
    public Page<CompanyHisDTO> pageHistory(String taxNum, Pageable pageable) {
        Page pageHistory = this.companyDao.pageHistoryByTaxNum(taxNum, pageable);
        Set companyIds = pageHistory.getContent().stream().map(CompanyHisDTO::getCompanyId).collect(Collectors.toSet());
        List<Company> companyList = this.companyService.findByIds(new ArrayList<Long>(companyIds));
        Map companyMap = companyList.stream().collect(Collectors.toMap(Company::getCompanyId, Function.identity(), (key1, key2) -> key1));
        pageHistory = pageHistory.map(e -> {
            if (!companyMap.containsKey(e.getCompanyId())) {
                return e;
            }
            Company company = (Company)companyMap.get(e.getCompanyId());
            if (StringUtils.isEmpty((CharSequence)e.getCompanyName()) && StringUtils.isNotEmpty((CharSequence)company.getCompanyName())) {
                e.setCompanyName(e.getCompanyName());
            }
            if (StringUtils.isEmpty((CharSequence)e.getTaxNum()) && StringUtils.isNotEmpty((CharSequence)company.getTaxNum())) {
                e.setStatus(company.getStatus());
            }
            if (StringUtils.isNotEmpty((CharSequence)company.getCompanyCode())) {
                e.setCompanyCode(company.getCompanyCode());
            }
            if (null != company.getStatus()) {
                e.setStatus(company.getStatus());
            }
            if (null != company.getUpdateTime()) {
                e.setUpdateTime(company.getUpdateTime());
            }
            return e;
        });
        return pageHistory;
    }
}

