/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.business.conf.service;

import com.xforceplus.api.model.PrivacyAgreementModel;
import com.xforceplus.dao.PrivacyAgreementDao;
import com.xforceplus.dao.PrivacyAgreementProtocolDao;
import com.xforceplus.domain.conf.PrivacyAgreementDto;
import com.xforceplus.entity.PrivacyAgreement;
import com.xforceplus.entity.PrivacyAgreementProtocol;
import com.xforceplus.query.PrivacyAgreementQueryHelper;
import io.geewit.data.jpa.essential.domain.EntityGraphs;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class PrivacyAgreementService {
    private static final Logger logger = LoggerFactory.getLogger(PrivacyAgreementService.class);
    private final PrivacyAgreementDao privacyAgreementDao;
    private final PrivacyAgreementProtocolDao privacyAgreementProtocolDao;
    private final Integer ENABLE = 1;
    private final Integer DISABLE = 0;

    public PrivacyAgreementService(PrivacyAgreementDao privacyAgreementDao, PrivacyAgreementProtocolDao privacyAgreementProtocolDao) {
        this.privacyAgreementDao = privacyAgreementDao;
        this.privacyAgreementProtocolDao = privacyAgreementProtocolDao;
    }

    @Transactional
    public PrivacyAgreement add(PrivacyAgreementModel.Request.Save model) {
        PrivacyAgreementModel.Request.Query query = new PrivacyAgreementModel.Request.Query();
        query.setVersion(model.getVersion());
        List privacyAgreements = this.privacyAgreementDao.findAll(PrivacyAgreementQueryHelper.querySpecification((PrivacyAgreementModel.Request.Query)query), EntityGraphs.named((String)"PrivacyAgreement.graph"));
        Optional<PrivacyAgreement> existPrivacyAgreementOptional = privacyAgreements.stream().filter(Objects::nonNull).findFirst();
        if (existPrivacyAgreementOptional.isPresent()) {
            return existPrivacyAgreementOptional.get();
        }
        PrivacyAgreement privacyAgreement = new PrivacyAgreement();
        privacyAgreement.setContent(model.getContent());
        privacyAgreement.setVersion(model.getVersion());
        privacyAgreement.setStatus((Integer)ObjectUtils.defaultIfNull((Object)model.getStatus(), (Object)1));
        privacyAgreement = (PrivacyAgreement)this.privacyAgreementDao.saveAndFlush((Object)privacyAgreement);
        if (model.getProtocols() != null && !model.getProtocols().isEmpty()) {
            ArrayList<PrivacyAgreementProtocol> protocols = new ArrayList<PrivacyAgreementProtocol>(model.getProtocols().size());
            List protocolModels = model.getProtocols();
            for (PrivacyAgreementModel.Request.ProtocolSave protocolModel : protocolModels) {
                PrivacyAgreementProtocol agreementProtocol = new PrivacyAgreementProtocol();
                agreementProtocol.setAgreementId(privacyAgreement.getId());
                agreementProtocol.setTitle(protocolModel.getTitle());
                agreementProtocol.setUrl(protocolModel.getUrl());
                protocols.add(agreementProtocol);
            }
            privacyAgreement.setProtocols(protocols);
            privacyAgreement.arrangeProtocolsOrdinal();
            this.privacyAgreementProtocolDao.saveAllAndFlush(protocols);
        }
        return privacyAgreement;
    }

    public PrivacyAgreement get(long id) {
        PrivacyAgreement result = (PrivacyAgreement)this.privacyAgreementDao.findById((Serializable)Long.valueOf(id), EntityGraphs.named((String)"PrivacyAgreement.graph")).orElseThrow(() -> new IllegalArgumentException("\u65e0\u6cd5\u627e\u5230\u8be5\u4fe1\u606f(" + id + ")"));
        return result;
    }

    @Transactional
    public PrivacyAgreement update(PrivacyAgreementModel.Request.Save model) {
        PrivacyAgreement existEntity = (PrivacyAgreement)this.privacyAgreementDao.findById((Serializable)model.getId(), EntityGraphs.named((String)"PrivacyAgreement.graph")).orElseThrow(() -> new IllegalArgumentException("\u65e0\u6cd5\u627e\u5230\u8be5\u4fe1\u606f(" + model.getId() + ")"));
        if (StringUtils.isNotBlank((CharSequence)model.getVersion()) && !model.getVersion().equals(existEntity.getVersion())) {
            PrivacyAgreementModel.Request.Query query = new PrivacyAgreementModel.Request.Query();
            query.setVersion(model.getVersion());
            long count = this.privacyAgreementDao.count(PrivacyAgreementQueryHelper.querySpecification((PrivacyAgreementModel.Request.Query)query));
            if (count > 0L) {
                throw new IllegalArgumentException("\u8be5version(" + model.getVersion() + ")\u7684\u9690\u79c1\u534f\u8bae\u5df2\u5b58\u5728");
            }
            existEntity.setVersion(model.getVersion());
        }
        if (StringUtils.isNotBlank((CharSequence)model.getContent())) {
            existEntity.setContent(model.getContent());
        }
        if (model.getStatus() != null) {
            existEntity.setStatus(model.getStatus());
        }
        existEntity = (PrivacyAgreement)this.privacyAgreementDao.saveAndFlush((Object)existEntity);
        if (model.getProtocols() != null && !model.getProtocols().isEmpty()) {
            this.privacyAgreementProtocolDao.deleteByAgreementId(existEntity.getId().longValue());
            ArrayList<PrivacyAgreementProtocol> protocols = new ArrayList<PrivacyAgreementProtocol>(model.getProtocols().size());
            List protocolModels = model.getProtocols();
            for (PrivacyAgreementModel.Request.ProtocolSave protocolModel : protocolModels) {
                PrivacyAgreementProtocol agreementProtocol = new PrivacyAgreementProtocol();
                agreementProtocol.setAgreementId(existEntity.getId());
                agreementProtocol.setTitle(protocolModel.getTitle());
                agreementProtocol.setUrl(protocolModel.getUrl());
                protocols.add(agreementProtocol);
            }
            existEntity.setProtocols(protocols);
            existEntity.arrangeProtocolsOrdinal();
            this.privacyAgreementProtocolDao.saveAllAndFlush(protocols);
        }
        return existEntity;
    }

    @Transactional
    public PrivacyAgreement enable(long id) {
        PrivacyAgreement existEntity = (PrivacyAgreement)this.privacyAgreementDao.findById((Object)id).orElseThrow(() -> new IllegalArgumentException("\u65e0\u6cd5\u627e\u5230\u8be5\u4fe1\u606f(" + id + ")"));
        existEntity.setStatus(this.ENABLE);
        return (PrivacyAgreement)this.privacyAgreementDao.saveAndFlush((Object)existEntity);
    }

    @Transactional
    public PrivacyAgreement disable(Long id) {
        PrivacyAgreement existEntity = (PrivacyAgreement)this.privacyAgreementDao.findById((Object)id).orElseThrow(() -> new IllegalArgumentException("\u65e0\u6cd5\u627e\u5230\u8be5\u4fe1\u606f(" + id + ")"));
        existEntity.setStatus(this.DISABLE);
        return (PrivacyAgreement)this.privacyAgreementDao.saveAndFlush((Object)existEntity);
    }

    @Transactional
    public void delete(Long id) {
        PrivacyAgreement existEntity = (PrivacyAgreement)this.privacyAgreementDao.findById((Object)id).orElseThrow(() -> new IllegalArgumentException("\u65e0\u6cd5\u627e\u5230\u8be5\u4fe1\u606f(" + id + ")"));
        this.privacyAgreementDao.deleteById((Object)existEntity.getId());
        this.privacyAgreementProtocolDao.deleteByAgreementId(existEntity.getId().longValue());
    }

    public PrivacyAgreement getLatest() {
        PageRequest pageable = PageRequest.of((int)0, (int)1, (Sort)Sort.by((Sort.Order[])new Sort.Order[]{Sort.Order.desc((String)"createTime")}));
        Page privacyAgreements = this.privacyAgreementDao.findAll((Pageable)pageable, EntityGraphs.named((String)"PrivacyAgreement.graph"));
        return (PrivacyAgreement)privacyAgreements.stream().findFirst().orElseThrow(() -> new IllegalArgumentException("\u6c92\u6709\u627e\u5230\u6709\u6548\u7684\u4fe1\u606f\uff01"));
    }

    @Transactional
    public void sortUpProtocols(long protocolId) {
        PrivacyAgreementProtocol protocol = (PrivacyAgreementProtocol)this.privacyAgreementProtocolDao.findById((Object)protocolId).orElseThrow(() -> new IllegalArgumentException("\u4e0d\u5b58\u5728id(" + protocolId + ")\u7684\u9690\u79c1\u534f\u8bae\u8be6\u60c5"));
        Long agreementId = protocol.getAgreementId();
        if (agreementId == null) {
            throw new IllegalArgumentException("id(" + protocolId + ")\u7684\u9690\u79c1\u534f\u8bae\u8be6\u60c5\u7684agreementId\u4e3anull");
        }
        List protocols = this.privacyAgreementProtocolDao.findByAgreementId(agreementId.longValue());
        PrivacyAgreementDto.sortProtocols((List)protocols);
        PrivacyAgreementDto.arrangeProtocolsOrdinal((List)protocols);
        protocol = protocols.stream().filter(p -> p.getId().equals(protocolId)).findFirst().orElseThrow(() -> new IllegalArgumentException("\u4e0d\u5b58\u5728id(" + protocolId + ")\u7684\u9690\u79c1\u534f\u8bae\u8be6\u60c5"));
        Integer ordinal = protocol.getOrdinal();
        if (ordinal <= 1) {
            this.privacyAgreementProtocolDao.saveAndFlush((Object)protocol);
            return;
        }
        Integer upperOrdinal = ordinal - 1;
        protocol.setOrdinal(upperOrdinal);
        this.privacyAgreementProtocolDao.saveAndFlush((Object)protocol);
        PrivacyAgreementProtocol upperProtocol = protocols.stream().filter(p -> p.getOrdinal().equals(upperOrdinal)).findFirst().orElseThrow(() -> new IllegalArgumentException("\u4e0d\u5b58\u5728agreementId(" + agreementId + "),ordinal(" + upperOrdinal + ")\u7684\u9690\u79c1\u534f\u8bae\u8be6\u60c5"));
        upperProtocol.setOrdinal(ordinal);
        this.privacyAgreementProtocolDao.saveAndFlush((Object)upperProtocol);
    }

    @Transactional
    public void sortDownProtocols(long protocolId) {
        PrivacyAgreementProtocol protocol = (PrivacyAgreementProtocol)this.privacyAgreementProtocolDao.findById((Object)protocolId).orElseThrow(() -> new IllegalArgumentException("\u4e0d\u5b58\u5728id(" + protocolId + ")\u7684\u9690\u79c1\u534f\u8bae\u8be6\u60c5"));
        Long agreementId = protocol.getAgreementId();
        if (agreementId == null) {
            throw new IllegalArgumentException("id(" + protocolId + ")\u7684\u9690\u79c1\u534f\u8bae\u8be6\u60c5\u7684agreementId\u4e3anull");
        }
        List protocols = this.privacyAgreementProtocolDao.findByAgreementId(agreementId.longValue());
        PrivacyAgreementDto.sortProtocols((List)protocols);
        PrivacyAgreementDto.arrangeProtocolsOrdinal((List)protocols);
        protocol = protocols.stream().filter(p -> p.getId().equals(protocolId)).findFirst().orElseThrow(() -> new IllegalArgumentException("\u4e0d\u5b58\u5728id(" + protocolId + ")\u7684\u9690\u79c1\u534f\u8bae\u8be6\u60c5"));
        Integer ordinal = protocol.getOrdinal();
        if (ordinal >= protocols.size()) {
            this.privacyAgreementProtocolDao.saveAndFlush((Object)protocol);
            return;
        }
        Integer lowerOrdinal = ordinal + 1;
        protocol.setOrdinal(lowerOrdinal);
        this.privacyAgreementProtocolDao.saveAndFlush((Object)protocol);
        PrivacyAgreementProtocol upperProtocol = protocols.stream().filter(p -> p.getOrdinal().equals(lowerOrdinal)).findFirst().orElseThrow(() -> new IllegalArgumentException("\u4e0d\u5b58\u5728agreementId(" + agreementId + "),ordinal(" + lowerOrdinal + ")\u7684\u9690\u79c1\u534f\u8bae\u8be6\u60c5"));
        upperProtocol.setOrdinal(ordinal);
        this.privacyAgreementProtocolDao.saveAndFlush((Object)upperProtocol);
    }
}

