/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.business.excel;

import com.xforceplus.business.excel.ExcelSheet;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class BusinessAttribute {
    private String name;
    private String exportTemplateFile;
    private String importTemplateFile;
    private Integer batchSize;
    private List<ExcelSheet> sheets;

    protected BusinessAttribute(String name, String exportTemplateFile, String importTemplateFile, Integer batchSize, List<ExcelSheet> sheets) {
        this.name = name;
        this.exportTemplateFile = exportTemplateFile;
        this.importTemplateFile = importTemplateFile;
        this.batchSize = batchSize;
        this.sheets = sheets;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getName() {
        return this.name;
    }

    public String getExportTemplateFile() {
        return this.exportTemplateFile;
    }

    public String getImportTemplateFile() {
        return this.importTemplateFile;
    }

    public Integer getBatchSize() {
        return this.batchSize;
    }

    public List<ExcelSheet> getSheets() {
        return this.sheets;
    }

    public static final class Builder {
        private String name;
        private String exportTemplateFile;
        private String importTemplateFile;
        private Integer batchSize;
        private List<ExcelSheet> sheets;

        private Builder() {
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder exportTemplateFile(String exportTemplateFile) {
            this.exportTemplateFile = exportTemplateFile;
            return this;
        }

        public Builder importTemplateFile(String importTemplateFile) {
            this.importTemplateFile = importTemplateFile;
            return this;
        }

        public Builder batchSize(Integer batchSize) {
            this.batchSize = batchSize;
            return this;
        }

        public Builder sheets(List<ExcelSheet> sheets) {
            this.sheets = sheets;
            return this;
        }

        public BusinessAttribute build() {
            if (StringUtils.isBlank((CharSequence)this.name)) {
                throw new IllegalArgumentException("\u4e1a\u52a1\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StringUtils.isBlank((CharSequence)this.exportTemplateFile)) {
                throw new IllegalArgumentException("\u5bfc\u51fa\u6a21\u677f\u8def\u5f84\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (CollectionUtils.isEmpty(this.sheets)) {
                throw new IllegalArgumentException("\u5bfc\u5165\u6216\u5bfc\u51faExcel\u7684Sheet\u4e0d\u80fd\u4e3a\u7a7a");
            }
            return new BusinessAttribute(this.name, this.exportTemplateFile, this.importTemplateFile, this.batchSize, this.sheets);
        }
    }
}

