/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.business.excel;

import com.xforceplus.business.excel.ExcelFile;
import com.xforceplus.business.excel.ExcelSheet;
import com.xforceplus.tenant.security.core.context.UserInfoHolder;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExcelBook {
    private static final Logger log = LoggerFactory.getLogger(ExcelBook.class);
    private String name;
    private String fileNameExt;
    private String sourceFileName;
    private String sourceFilePath;
    private String targetFileName;
    private String targetFilePath;
    private List<ExcelSheet> excelSheets;
    private Map<String, String> messages;
    private Long targetFileId;
    private Long sourceFileId;
    private Exception exception;
    private Long tenantId;
    private Long userId;
    private Boolean debug;
    private Map<String, Object> params;

    protected ExcelBook(String fileNameExt, String templateFileName, String templatePath, String fileName, String filePath, List<ExcelSheet> excelSheets, Map<String, String> messages, Long fileId, Long tenantId, Long userId, Boolean debug, String name, Long sourceFileId) {
        this.fileNameExt = fileNameExt;
        this.sourceFileName = templateFileName;
        this.sourceFilePath = templatePath;
        this.targetFileName = fileName;
        this.targetFilePath = filePath;
        this.excelSheets = excelSheets;
        this.messages = messages;
        this.targetFileId = fileId;
        this.userId = userId;
        this.tenantId = tenantId;
        this.debug = debug;
        this.name = name;
        this.params = new HashMap<String, Object>(6);
        this.sourceFileId = sourceFileId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public void param(String key, Object obj) {
        this.params.put(key, obj);
    }

    public <T> T getParam(String key) {
        if (this.params.containsKey(key)) {
            try {
                return (T)this.params.get(key);
            }
            catch (Exception e) {
                log.warn(e.getMessage(), (Throwable)e);
            }
        }
        return null;
    }

    public Path getSourcePath() {
        if (StringUtils.isNotBlank((CharSequence)this.sourceFileName) && this.sourceFileName.endsWith(".xlsx")) {
            return Paths.get(this.sourceFilePath, this.sourceFileName);
        }
        if (StringUtils.isBlank((CharSequence)this.fileNameExt)) {
            this.fileNameExt = ".xlsx";
        }
        return Paths.get(this.sourceFilePath, this.sourceFileName + this.fileNameExt);
    }

    public Path getTargetPath() {
        if (StringUtils.isBlank((CharSequence)this.targetFileName)) {
            return Paths.get(ExcelFile.createExcelFilePath(), new String[0]);
        }
        if (StringUtils.isNotBlank((CharSequence)this.targetFileName) && this.targetFileName.endsWith(".xlsx")) {
            return Paths.get(this.targetFilePath, this.targetFileName);
        }
        if (StringUtils.isBlank((CharSequence)this.fileNameExt)) {
            this.fileNameExt = ".xlsx";
        }
        return Paths.get(this.targetFilePath, this.targetFileName + this.fileNameExt);
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setFileNameExt(String fileNameExt) {
        this.fileNameExt = fileNameExt;
    }

    public void setSourceFileName(String sourceFileName) {
        this.sourceFileName = sourceFileName;
    }

    public void setSourceFilePath(String sourceFilePath) {
        this.sourceFilePath = sourceFilePath;
    }

    public void setTargetFileName(String targetFileName) {
        this.targetFileName = targetFileName;
    }

    public void setTargetFilePath(String targetFilePath) {
        this.targetFilePath = targetFilePath;
    }

    public void setExcelSheets(List<ExcelSheet> excelSheets) {
        this.excelSheets = excelSheets;
    }

    public void setMessages(Map<String, String> messages) {
        this.messages = messages;
    }

    public void setTargetFileId(Long targetFileId) {
        this.targetFileId = targetFileId;
    }

    public void setSourceFileId(Long sourceFileId) {
        this.sourceFileId = sourceFileId;
    }

    public void setException(Exception exception) {
        this.exception = exception;
    }

    public void setTenantId(Long tenantId) {
        this.tenantId = tenantId;
    }

    public void setUserId(Long userId) {
        this.userId = userId;
    }

    public void setDebug(Boolean debug) {
        this.debug = debug;
    }

    public void setParams(Map<String, Object> params) {
        this.params = params;
    }

    public String getName() {
        return this.name;
    }

    public String getFileNameExt() {
        return this.fileNameExt;
    }

    public String getSourceFileName() {
        return this.sourceFileName;
    }

    public String getSourceFilePath() {
        return this.sourceFilePath;
    }

    public String getTargetFileName() {
        return this.targetFileName;
    }

    public String getTargetFilePath() {
        return this.targetFilePath;
    }

    public List<ExcelSheet> getExcelSheets() {
        return this.excelSheets;
    }

    public Map<String, String> getMessages() {
        return this.messages;
    }

    public Long getTargetFileId() {
        return this.targetFileId;
    }

    public Long getSourceFileId() {
        return this.sourceFileId;
    }

    public Exception getException() {
        return this.exception;
    }

    public Long getTenantId() {
        return this.tenantId;
    }

    public Long getUserId() {
        return this.userId;
    }

    public Boolean getDebug() {
        return this.debug;
    }

    public Map<String, Object> getParams() {
        return this.params;
    }

    public String toString() {
        return "ExcelBook(name=" + this.getName() + ", fileNameExt=" + this.getFileNameExt() + ", sourceFileName=" + this.getSourceFileName() + ", sourceFilePath=" + this.getSourceFilePath() + ", targetFileName=" + this.getTargetFileName() + ", targetFilePath=" + this.getTargetFilePath() + ", excelSheets=" + this.getExcelSheets() + ", messages=" + this.getMessages() + ", targetFileId=" + this.getTargetFileId() + ", sourceFileId=" + this.getSourceFileId() + ", exception=" + this.getException() + ", tenantId=" + this.getTenantId() + ", userId=" + this.getUserId() + ", debug=" + this.getDebug() + ", params=" + this.getParams() + ")";
    }

    public static class Builder {
        private String fileNameExt;
        private String sourceFileName;
        private String sourceFilePath;
        private String targetFileName;
        private String targetFilePath;
        private List<ExcelSheet> excelSheets;
        private Map<String, String> messages;
        private Long targetFileId;
        private Long tenantId;
        private Long userId;
        private Long sourceFileId;
        private Boolean debug = Boolean.FALSE;
        private Map<String, Object> params;
        private String name;

        protected Builder() {
            this.messages = new HashMap<String, String>(6);
            this.excelSheets = new ArrayList<ExcelSheet>(3);
            this.params = new HashMap<String, Object>(6);
        }

        public void param(String key, Object obj) {
            this.params.put(key, obj);
        }

        public Builder tenantId(Long tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        public Builder userId(Long userId) {
            this.userId = userId;
            return this;
        }

        public Builder excelSheets(List<ExcelSheet> excelSheets) {
            this.excelSheets.addAll(excelSheets);
            return this;
        }

        public Builder excelSheet(ExcelSheet excelSheet) {
            this.excelSheets.add(excelSheet);
            return this;
        }

        public Builder excelSheet(Integer sheetNo, String sheetName) {
            ExcelSheet excelSheet = new ExcelSheet(sheetNo, sheetName);
            this.excelSheets.add(excelSheet);
            return this;
        }

        public Builder excelSheet(Integer sheetNo, String sheetName, List<?> data) {
            ExcelSheet excelSheet = new ExcelSheet(sheetNo, sheetName, data);
            this.excelSheets.add(excelSheet);
            return this;
        }

        public Builder fileName(String fileName) {
            this.targetFileName = fileName;
            return this;
        }

        public Builder filePath(String filePath) {
            this.targetFilePath = filePath;
            return this;
        }

        public Builder sourcePath(String sourceFilePath) {
            this.sourceFilePath = sourceFilePath;
            return this;
        }

        public Builder sourceFileName(String sourceFileName) {
            this.sourceFileName = sourceFileName;
            return this;
        }

        public Builder message(String key, String content) {
            this.messages.put(key, content);
            return this;
        }

        public Builder targetFileId(Long targetFileId) {
            this.targetFileId = targetFileId;
            return this;
        }

        public Builder sourceFileId(Long sourceFileId) {
            this.sourceFileId = sourceFileId;
            return this;
        }

        public Builder fileNameExt(String fileNameExt) {
            this.fileNameExt = fileNameExt;
            return this;
        }

        public Builder debug(Boolean debug) {
            this.debug = debug;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public ExcelBook build() {
            if (this.tenantId == null) {
                this.tenantId = null != UserInfoHolder.get() ? UserInfoHolder.get().getTenantId() : Long.valueOf(0L);
            }
            if (this.userId == null) {
                this.userId = null != UserInfoHolder.get() ? UserInfoHolder.get().getId() : Long.valueOf(0L);
            }
            if (StringUtils.isBlank((CharSequence)this.fileNameExt)) {
                this.fileNameExt = ".xlsx";
            }
            if (StringUtils.isBlank((CharSequence)this.sourceFilePath)) {
                this.sourceFilePath = "";
            }
            if (StringUtils.isBlank((CharSequence)this.targetFilePath)) {
                this.targetFilePath = "";
            }
            if (StringUtils.isBlank((CharSequence)this.targetFileName)) {
                this.targetFileName = ExcelFile.createExcelFilePath();
            }
            return new ExcelBook(this.fileNameExt, this.sourceFileName, this.sourceFilePath, this.targetFileName, this.targetFilePath, this.excelSheets, this.messages, this.targetFileId, this.tenantId, this.userId, this.debug, this.name, this.sourceFileId);
        }
    }
}

