/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.business.excel;

import com.google.common.base.Joiner;
import com.xforceplus.business.excel.DataRow;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.validation.ConstraintViolation;
import javax.validation.Validator;
import javax.validation.groups.Default;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class ExcelValidator {
    private static Validator VALIDATOR;

    public static <T> void validate(T obj) {
        Set constraintViolations = VALIDATOR.validate(obj, new Class[]{Default.class});
        if (obj instanceof DataRow) {
            DataRow dataRow = (DataRow)obj;
            if (CollectionUtils.isEmpty((Collection)constraintViolations)) {
                dataRow.setValidatedStatus(Boolean.TRUE);
                return;
            }
            List messages = constraintViolations.stream().map(ConstraintViolation::getMessage).collect(Collectors.toCollection(() -> new ArrayList(constraintViolations.size())));
            String message = Joiner.on((String)";\r\n").skipNulls().join((Iterable)messages);
            dataRow.setValidatedStatus(Boolean.FALSE);
            dataRow.setValidatedMessage(message);
        }
    }

    @Autowired
    public void setValidator(Validator validator) {
        VALIDATOR = validator;
    }
}

