/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.business.excel;

import com.xforceplus.business.excel.ExcelBook;
import com.xforceplus.business.excel.ExcelHandler;
import com.xforceplus.utils.filetransfer.FileTransferUtilsService;
import io.geewit.web.utils.SpringContextUtil;
import java.io.File;
import java.io.FileNotFoundException;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileExcelWriterHandler
implements ExcelHandler {
    private static final Logger logger = LoggerFactory.getLogger(FileExcelWriterHandler.class);
    private final FileTransferUtilsService fileTransferUtilsService = (FileTransferUtilsService)SpringContextUtil.getBean(FileTransferUtilsService.class);

    @Override
    public void before(ExcelBook excelBook) {
        logger.info("\u4e0a\u4f20\u6587\u4ef6Before");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void after(ExcelBook excelBook) {
        logger.info("\u5f00\u59cb\u4e0a\u4f20\u6587\u4ef6...");
        File file = excelBook.getTargetPath().toFile();
        String filePath = file.getPath();
        try {
            logger.info("\u4e0a\u4f20\u6587\u4ef6\u8def\u5f84\u662f\uff1a{}", (Object)filePath);
            this.checkSize(file);
        }
        catch (Exception e) {
            logger.warn(e.getMessage(), (Throwable)e);
            excelBook.setException(e);
            FileUtils.deleteQuietly((File)file);
            return;
        }
        try {
            Long fileId = this.fileTransferUtilsService.upload(filePath, excelBook.getUserId(), excelBook.getTenantId());
            logger.info("\u4e0a\u4f20\u6210\u529f\u6587\u4ef6ID:{}", (Object)fileId);
            excelBook.setTargetFileId(fileId);
        }
        catch (FileNotFoundException e) {
            logger.error("\u5bfc\u51fa\u4fe1\u606f\u4e0a\u4f20\u6587\u4ef6\u670d\u52a1\u5931\u8d25,{}", (Object)filePath, (Object)e);
            excelBook.setException(e);
        }
        finally {
            FileUtils.deleteQuietly((File)file);
        }
        logger.info("\u7ed3\u675f\u4e0a\u4f20\u6587\u4ef6...");
    }

    protected void checkSize(File file) {
        long size = FileUtils.sizeOf((File)file);
        logger.info("file size:{}", (Object)size);
        if (size == 0L) {
            throw new IllegalStateException("\u6587\u4ef6\u5bfc\u51fa\u5165\u5931\u8d25");
        }
    }
}

