/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.business.excel;

import com.xforceplus.business.excel.ExcelBook;
import com.xforceplus.business.excel.ExcelConfig;
import com.xforceplus.business.excel.ExcelHandler;
import com.xforceplus.business.notice.dto.NoticeMessage;
import com.xforceplus.business.notice.service.NoticeService;
import com.xforceplus.utils.StrUtils;
import io.geewit.web.utils.SpringContextUtil;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageExcelWriterHandler
implements ExcelHandler {
    private static final Logger logger = LoggerFactory.getLogger(MessageExcelWriterHandler.class);
    private final NoticeService noticeService = (NoticeService)SpringContextUtil.getBean(NoticeService.class);

    @Override
    public void before(ExcelBook excelBook) {
        logger.info("\u53d1\u9001\u6d88\u606f\u901a\u77e5-Before");
        if (excelBook.getException() != null) {
            logger.error(excelBook.getException().getMessage(), excelBook.getException().getCause());
            String noticeKey = "EXP_EXCEPTION";
            String message = excelBook.getException().getMessage();
            if (StringUtils.isNotEmpty((CharSequence)message)) {
                message = StrUtils.matcherZh(message, " ");
            }
            if (StringUtils.isBlank((CharSequence)message)) {
                message = "\u7cfb\u7edf\u53d1\u751f\u9519\u8bef\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\u6216\u8054\u7cfb\u8fd0\u8425\u4eba\u5458";
            }
            Object[] params = new Object[]{excelBook.getName(), message};
            this.sendNoticeMessage(excelBook, noticeKey, params);
        }
    }

    @Override
    public void after(ExcelBook excelBook) {
        String noticeKey = "EXP_SUCCESS";
        String successSize = this.successSize(excelBook);
        String downloadUrl = ExcelConfig.getDownloadUrl();
        logger.info("\u53d1\u9001\u6d88\u606f\u901a\u77e5-after,downloadUrl:{}", (Object)downloadUrl);
        Object[] params = new Object[]{excelBook.getName(), successSize, downloadUrl + excelBook.getTargetFileId(), String.valueOf(excelBook.getTargetFileId())};
        if (excelBook.getException() != null) {
            noticeKey = "EXP_EXCEPTION";
            params = new Object[]{excelBook.getName(), excelBook.getException().getMessage()};
        }
        this.sendNoticeMessage(excelBook, noticeKey, params);
    }

    protected void sendNoticeMessage(ExcelBook excelBook, String noticeKey, Object[] params) {
        try {
            NoticeMessage noticeMessage = NoticeMessage.builder().userId(excelBook.getUserId()).tenantId(excelBook.getTenantId()).key(noticeKey).params(params).build();
            this.sendNotice(noticeMessage);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    private String successSize(ExcelBook excelBook) {
        if (excelBook.getParams().containsKey("SUCCESS_SIZE")) {
            return String.valueOf(excelBook.getParams().get("SUCCESS_SIZE"));
        }
        return String.valueOf(0);
    }

    protected void sendNotice(NoticeMessage noticeMessage) {
        this.noticeService.sendExcelProcessNotice(noticeMessage.getExcelProcessNotice());
    }
}

