/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.business.excel;

import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.ExcelWriter;
import com.alibaba.excel.write.metadata.WriteSheet;
import com.xforceplus.business.excel.ExcelBook;
import com.xforceplus.business.excel.ExcelHandler;
import com.xforceplus.business.excel.ExcelSheet;
import com.xforceplus.business.excel.FileExcelWriterHandler;
import com.xforceplus.business.excel.MessageExcelWriterHandler;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.ClassPathResource;
import org.springframework.util.CollectionUtils;

public class SimpleExcelWriter {
    private static final Logger logger = LoggerFactory.getLogger(SimpleExcelWriter.class);
    private Map<String, ExcelHandler> handlers;
    private ExcelBook excelBook;
    private ExcelWriter excelWriter;
    private Map<String, WriteSheet> writeSheets;

    private SimpleExcelWriter(Map<String, ExcelHandler> handlers, ExcelBook excelBook) {
        this.handlers = handlers;
        this.excelBook = excelBook;
        this.writeSheets = new HashMap<String, WriteSheet>(2);
    }

    public static Builder builder() {
        return new Builder();
    }

    protected SimpleExcelWriter start() {
        logger.info("\u5f00\u59cb\u5bfc\u51fa\u6587\u4ef6...");
        logger.info("filePath:{}", (Object)this.excelBook.getTargetPath().toFile());
        logger.info("TemplateFilePath:{}", (Object)this.excelBook.getSourcePath().toFile());
        try {
            InputStream inputStream = this.loadTemplateFile(this.excelBook.getSourcePath());
            this.excelWriter = EasyExcel.write((File)this.excelBook.getTargetPath().toFile()).withTemplate(inputStream).build();
        }
        catch (RuntimeException e) {
            this.excelBook.setException(e);
        }
        this.beforeHandler();
        try {
            this.createWriteSheet(this.excelBook.getExcelSheets());
        }
        catch (Exception e) {
            this.excelBook.setException(e);
        }
        return this;
    }

    public ExcelBook getExcelBook() {
        return this.excelBook;
    }

    private InputStream loadTemplateFile(Path path) {
        InputStream inputStream;
        try {
            logger.info("path:{}", (Object)path.toString());
            inputStream = new ClassPathResource(path.toString()).getInputStream();
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new IllegalArgumentException(e);
        }
        return inputStream;
    }

    protected void createWriteSheet(List<ExcelSheet> sheets) {
        if (CollectionUtils.isEmpty(sheets)) {
            logger.warn("\u65e0Sheet\u6587\u4ef6");
            return;
        }
        for (ExcelSheet sheet : sheets) {
            logger.info("sheetNo:{},SheetName:{}", (Object)sheet.getSheetNo(), (Object)sheet.getSheetName());
            this.writeSheets.put(sheet.getSheetName(), EasyExcel.writerSheet((Integer)sheet.getSheetNo(), (String)sheet.getSheetName()).build());
        }
    }

    protected void beforeHandler() {
        if (this.isHandlerEmpty()) {
            return;
        }
        for (Map.Entry<String, ExcelHandler> entry : this.handlers.entrySet()) {
            logger.info("Execute before Handler:{}", (Object)entry.getKey());
            entry.getValue().before(this.excelBook);
        }
    }

    public SimpleExcelWriter fill() {
        List<ExcelSheet> excelSheets = this.excelBook.getExcelSheets();
        if (CollectionUtils.isEmpty(excelSheets)) {
            logger.warn("ExcelContext hasn't ExcelSheet data");
            return this;
        }
        for (ExcelSheet sheet : excelSheets) {
            if (CollectionUtils.isEmpty(sheet.getData())) continue;
            this.write(sheet.getSheetName(), sheet.getData());
        }
        return this;
    }

    public void param(String key, Object obj) {
        this.excelBook.getParams().put(key, obj);
    }

    public void setException(Exception e) {
        this.excelBook.setException(e);
    }

    public SimpleExcelWriter fill(String sheetName, List<?> data) {
        if (CollectionUtils.isEmpty(data)) {
            logger.warn("SheetName:{}\u5199\u5165\u6570\u636e\u4e3a\u7a7a", (Object)sheetName);
            return this;
        }
        this.write(sheetName, data);
        return this;
    }

    protected void write(String sheetName, List<?> data) {
        if (!this.writeSheets.containsKey(sheetName)) {
            logger.info("\u6ca1\u6709\u627e\u5230Sheet\u540d\u79f0\u4e3a\uff1a{}\u7684Sheet", (Object)sheetName);
            return;
        }
        WriteSheet writeSheet = this.writeSheets.get(sheetName);
        this.excelWriter.fill(data, writeSheet);
    }

    public SimpleExcelWriter finish() {
        this.beforeFinish();
        if (this.excelWriter != null) {
            this.excelWriter.finish();
        }
        this.afterHandler();
        logger.info("\u7ed3\u675f\u5bfc\u51fa\u6587\u4ef6...");
        return this;
    }

    protected void beforeFinish() {
        List<ExcelSheet> excelSheets = this.excelBook.getExcelSheets();
        if (CollectionUtils.isEmpty(excelSheets)) {
            logger.warn("ExcelContext hasn't ExcelSheet data");
            return;
        }
        for (ExcelSheet sheet : excelSheets) {
            this.write(sheet.getSheetName(), Collections.EMPTY_LIST);
        }
    }

    protected boolean isHandlerEmpty() {
        if (CollectionUtils.isEmpty(this.handlers)) {
            logger.warn("SimpleExcelWriter hasn't Excel Handler");
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    protected void afterHandler() {
        if (this.isHandlerEmpty()) {
            return;
        }
        for (Map.Entry<String, ExcelHandler> entry : this.handlers.entrySet()) {
            logger.info("Execute After Handler:{}", (Object)entry.getKey());
            entry.getValue().after(this.excelBook);
        }
    }

    public static class Builder {
        public static final String DEFAULT_MESSAGE_HANDLER = "defaultMessageHandler";
        public static final String DEFAULT_FILE_EXCEL_HANDLER = "DEFAULT_FILE_EXCEL_HANDLER";
        private Map<String, ExcelHandler> handlers = new LinkedHashMap<String, ExcelHandler>(5);
        private ExcelBook excelBook;

        Builder() {
        }

        protected void init() {
            this.handlers.put(DEFAULT_FILE_EXCEL_HANDLER, new FileExcelWriterHandler());
            this.handlers.put(DEFAULT_MESSAGE_HANDLER, new MessageExcelWriterHandler());
        }

        public Builder handler(String name, ExcelHandler handler) {
            this.handlers.put(name, handler);
            return this;
        }

        public Builder excelBook(ExcelBook excelBook) {
            this.excelBook = excelBook;
            return this;
        }

        public SimpleExcelWriter build() {
            this.init();
            return new SimpleExcelWriter(this.handlers, this.excelBook).start();
        }
    }
}

