/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.business.excel.reader;

import com.alibaba.excel.metadata.CellData;
import com.xforceplus.business.excel.BusinessType;
import com.xforceplus.business.excel.ExcelBook;
import com.xforceplus.business.excel.ExcelConfig;
import com.xforceplus.business.excel.ExcelFile;
import com.xforceplus.business.excel.ExcelSheet;
import com.xforceplus.business.excel.SimpleExcelWriter;
import com.xforceplus.business.excel.file.ExcelFileDTO;
import com.xforceplus.business.excel.reader.MessageRow;
import com.xforceplus.business.excel.reader.SimpleExcelReader;
import com.xforceplus.tenant.security.core.domain.IAuthorizedUser;
import io.geewit.web.utils.JsonUtils;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Context {
    private static final Logger logger = LoggerFactory.getLogger(Context.class);
    private ExcelFileDTO fileDTO;
    private BusinessType businessType;
    private ExcelBook excelBook;
    private Class<?> clazz;
    private String sourceFilePath;
    private InputStream is;
    private String targetFilePath;
    private Map<String, MessageRow> messageRows;
    private Map<String, Map<Integer, CellData>> headMaps;
    private SimpleExcelReader simpleExcelReader;
    private SimpleExcelWriter simpleExcelWriter;
    private Map<String, Object> params;
    private Integer maxSize;
    private IAuthorizedUser authorizedUser;
    private Map<String, Integer> sheetHeaderMap;

    private Context(ExcelFileDTO fileDTO, BusinessType businessType, ExcelBook excelBook, Class<?> clazz, String sourceFilePath, String targetFilePath, IAuthorizedUser authorizedUser, Map<String, Object> params, Integer maxSize, Map<String, Integer> sheetHeaderMap) {
        this.fileDTO = fileDTO;
        this.businessType = businessType;
        this.excelBook = excelBook;
        this.clazz = clazz;
        this.sourceFilePath = sourceFilePath;
        this.messageRows = new ConcurrentHashMap<String, MessageRow>(6);
        this.headMaps = new ConcurrentHashMap<String, Map<Integer, CellData>>(6);
        this.targetFilePath = targetFilePath;
        this.authorizedUser = authorizedUser;
        this.params = params;
        this.maxSize = maxSize;
        this.sheetHeaderMap = sheetHeaderMap;
    }

    public static Builder builder() {
        return new Builder();
    }

    public SimpleExcelReader getSimpleExcelReader() {
        return this.simpleExcelReader;
    }

    public void setSimpleExcelReader(SimpleExcelReader simpleExcelReader) {
        this.simpleExcelReader = simpleExcelReader;
    }

    public Map<Integer, CellData> getHeadMap(String sheetName) {
        return this.headMaps.get(sheetName);
    }

    public void setHeadMap(String sheetName, Map<Integer, CellData> headMap) {
        this.headMaps.put(sheetName, headMap);
    }

    public List<ExcelSheet> excelSheets() {
        return this.excelBook.getExcelSheets();
    }

    public int getMaxPageSize() {
        int pageSize = this.maxSize / 1000;
        if (pageSize > 0) {
            --pageSize;
        }
        return pageSize;
    }

    public <T> T getParam(String key, Class<T> clazz) {
        if (this.fileDTO.getRerun().booleanValue()) {
            String jsonStr = JsonUtils.toJson((Object)this.params.get(key));
            return (T)JsonUtils.fromJson((String)jsonStr, clazz);
        }
        return (T)this.params.get(key);
    }

    public void messageRow(String sheetName, MessageRow messageRow) {
        if (this.messageRows.containsKey(sheetName)) {
            MessageRow messageRowTemp = this.messageRows.get(sheetName);
            messageRowTemp.putAll(messageRow.getRows());
            this.messageRows.put(sheetName, messageRowTemp);
        } else {
            this.messageRows.put(sheetName, messageRow);
        }
    }

    public MessageRow messageRow(String sheetName, Integer index, String message) {
        MessageRow existMessageRow = this.messageRows.containsKey(sheetName) ? this.messageRows.get(sheetName) : new MessageRow(sheetName);
        existMessageRow.fail(index, message);
        this.messageRows.put(sheetName, existMessageRow);
        return existMessageRow;
    }

    public void success(String sheetName, Integer rowIndex) {
        MessageRow existMessageRow = this.messageRows.get(sheetName);
        if (existMessageRow == null) {
            String message = "sheet(" + sheetName + "\u4e0d\u5b58\u5728";
            logger.warn(message);
        } else {
            existMessageRow.success(rowIndex);
        }
    }

    public void setFileDTO(ExcelFileDTO fileDTO) {
        this.fileDTO = fileDTO;
    }

    public void setBusinessType(BusinessType businessType) {
        this.businessType = businessType;
    }

    public void setExcelBook(ExcelBook excelBook) {
        this.excelBook = excelBook;
    }

    public void setClazz(Class<?> clazz) {
        this.clazz = clazz;
    }

    public void setSourceFilePath(String sourceFilePath) {
        this.sourceFilePath = sourceFilePath;
    }

    public void setIs(InputStream is) {
        this.is = is;
    }

    public void setTargetFilePath(String targetFilePath) {
        this.targetFilePath = targetFilePath;
    }

    public void setMessageRows(Map<String, MessageRow> messageRows) {
        this.messageRows = messageRows;
    }

    public void setHeadMaps(Map<String, Map<Integer, CellData>> headMaps) {
        this.headMaps = headMaps;
    }

    public void setSimpleExcelWriter(SimpleExcelWriter simpleExcelWriter) {
        this.simpleExcelWriter = simpleExcelWriter;
    }

    public void setParams(Map<String, Object> params) {
        this.params = params;
    }

    public void setMaxSize(Integer maxSize) {
        this.maxSize = maxSize;
    }

    public void setAuthorizedUser(IAuthorizedUser authorizedUser) {
        this.authorizedUser = authorizedUser;
    }

    public void setSheetHeaderMap(Map<String, Integer> sheetHeaderMap) {
        this.sheetHeaderMap = sheetHeaderMap;
    }

    public ExcelFileDTO getFileDTO() {
        return this.fileDTO;
    }

    public BusinessType getBusinessType() {
        return this.businessType;
    }

    public ExcelBook getExcelBook() {
        return this.excelBook;
    }

    public Class<?> getClazz() {
        return this.clazz;
    }

    public String getSourceFilePath() {
        return this.sourceFilePath;
    }

    public InputStream getIs() {
        return this.is;
    }

    public String getTargetFilePath() {
        return this.targetFilePath;
    }

    public Map<String, MessageRow> getMessageRows() {
        return this.messageRows;
    }

    public Map<String, Map<Integer, CellData>> getHeadMaps() {
        return this.headMaps;
    }

    public SimpleExcelWriter getSimpleExcelWriter() {
        return this.simpleExcelWriter;
    }

    public Map<String, Object> getParams() {
        return this.params;
    }

    public Integer getMaxSize() {
        return this.maxSize;
    }

    public IAuthorizedUser getAuthorizedUser() {
        return this.authorizedUser;
    }

    public Map<String, Integer> getSheetHeaderMap() {
        return this.sheetHeaderMap;
    }

    public String toString() {
        return "Context(fileDTO=" + this.getFileDTO() + ", businessType=" + this.getBusinessType() + ", excelBook=" + this.getExcelBook() + ", clazz=" + this.getClazz() + ", sourceFilePath=" + this.getSourceFilePath() + ", is=" + this.getIs() + ", targetFilePath=" + this.getTargetFilePath() + ", messageRows=" + this.getMessageRows() + ", headMaps=" + this.getHeadMaps() + ", simpleExcelReader=" + this.getSimpleExcelReader() + ", simpleExcelWriter=" + this.getSimpleExcelWriter() + ", params=" + this.getParams() + ", maxSize=" + this.getMaxSize() + ", authorizedUser=" + this.getAuthorizedUser() + ", sheetHeaderMap=" + this.getSheetHeaderMap() + ")";
    }

    public static final class Builder {
        private final Map<String, Object> params = new HashMap<String, Object>(2);
        private ExcelFileDTO fileDTO;
        private BusinessType businessType;
        private ExcelBook excelBook;
        private Class<?> clazz;
        private String sourceFilePath;
        private String targetFilePath;
        private IAuthorizedUser authorizedUser;
        private Integer maxSize;
        private Map<String, Integer> sheetHeaderMap;

        private Builder() {
        }

        public Builder sheetHeaderMap(Map<String, Integer> sheetHeaderMap) {
            this.sheetHeaderMap = sheetHeaderMap;
            return this;
        }

        public Builder fileDTO(ExcelFileDTO fileDTO) {
            this.fileDTO = fileDTO;
            return this;
        }

        public Builder businessType(BusinessType businessType) {
            this.businessType = businessType;
            return this;
        }

        public Builder excelBook(ExcelBook excelBook) {
            this.excelBook = excelBook;
            return this;
        }

        public Builder clazz(Class<?> clazz) {
            this.clazz = clazz;
            return this;
        }

        public Builder sourceFilePath(String sourceFilePath) {
            this.sourceFilePath = sourceFilePath;
            return this;
        }

        public Builder targetFilePath(String targetFilePath) {
            this.targetFilePath = targetFilePath;
            return this;
        }

        public Builder authorizedUser(IAuthorizedUser authorizedUser) {
            this.authorizedUser = authorizedUser;
            return this;
        }

        public Builder params(Map<String, Object> params) {
            if (null != params) {
                this.params.putAll(params);
            }
            return this;
        }

        public Builder params(String key, Object value) {
            this.params.put(key, value);
            return this;
        }

        public Builder maxSize(Integer maxSize) {
            if (maxSize > 0) {
                throw new IllegalArgumentException("\u5bfc\u51fa\u9650\u5236\u6700\u5927\u884c\u6570\u5e94\u8be5\u5927\u4e8e0");
            }
            this.maxSize = maxSize;
            return this;
        }

        public Context build() {
            if (StringUtils.isBlank((CharSequence)this.targetFilePath)) {
                this.targetFilePath = ExcelFile.createExcelFilePath();
            }
            if (this.maxSize == null) {
                this.maxSize = ExcelConfig.getLimitMaxSize();
            }
            return new Context(this.fileDTO, this.businessType, this.excelBook, this.clazz, this.sourceFilePath, this.targetFilePath, this.authorizedUser, this.params, this.maxSize, this.sheetHeaderMap);
        }
    }
}

