/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.business.excel.reader;

import com.google.common.base.Joiner;
import com.xforceplus.business.excel.AbstractExcelProcess;
import com.xforceplus.business.excel.ExcelBook;
import com.xforceplus.business.excel.ExcelProcess;
import com.xforceplus.business.excel.file.ExcelFileDTO;
import com.xforceplus.business.excel.reader.Context;
import com.xforceplus.business.excel.reader.ExcelMessageUtils;
import com.xforceplus.business.excel.reader.ExcelReaderUtils;
import com.xforceplus.business.excel.reader.MessageRow;
import com.xforceplus.business.excel.reader.SimpleExcelReader;
import com.xforceplus.business.service.ExcelReaderService;
import com.xforceplus.dao.ExcelFileStoreDao;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="excelImportProcess")
public class ExcelImportProcessImpl
extends AbstractExcelProcess
implements ExcelProcess {
    private static final Logger log = LoggerFactory.getLogger(ExcelImportProcessImpl.class);
    private static final Logger logger = LoggerFactory.getLogger(ExcelImportProcessImpl.class);

    public ExcelImportProcessImpl(ExcelFileStoreDao excelFileStoreDao) {
        super(excelFileStoreDao);
    }

    @Override
    public void before(Context context) {
        block5: {
            SimpleExcelReader simpleExcelReader;
            ExcelFileDTO excelFileDTO;
            block4: {
                logger.info("Excel Import process before...");
                this.beforeSet(context);
                excelFileDTO = context.getFileDTO();
                excelFileDTO.setBeginDate(new Date());
                simpleExcelReader = null;
                try {
                    ExcelBook excelBook = ExcelBook.builder().excelSheets(context.getBusinessType().sheets()).sourceFileId(context.getFileDTO().getSourceFileId()).sourceFileName(context.getSourceFilePath()).userId(context.getFileDTO().getUserId()).tenantId(context.getFileDTO().getTenantId()).name(context.getBusinessType().getBusinessName()).build();
                    context.setExcelBook(excelBook);
                    excelFileDTO.setSourceFilePath(context.getSourceFilePath());
                    excelFileDTO.setStatus(2);
                    excelFileDTO.setReadTime(excelFileDTO.getReadTime() + 1);
                    simpleExcelReader = SimpleExcelReader.builder().excelBook(excelBook).build();
                    context.setSimpleExcelReader(simpleExcelReader);
                }
                catch (Exception e) {
                    if (simpleExcelReader == null) break block4;
                    simpleExcelReader.setException(new IllegalArgumentException("Excel\u6587\u4ef6\u89e3\u6790\u9519\u8bef\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5"));
                }
            }
            try {
                this.beforeUpdate(excelFileDTO);
            }
            catch (Exception e) {
                if (simpleExcelReader == null) break block5;
                simpleExcelReader.setException(new IllegalArgumentException("Excel\u6587\u4ef6\u89e3\u6790\u9519\u8bef\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5"));
            }
        }
    }

    @Override
    public void process(Context context) {
        this.before(context);
        this.doRead(context);
        this.after(context);
    }

    protected void doRead(Context context) {
        ExcelReaderService excelReaderService = ExcelReaderUtils.getExcelReader(context.getBusinessType());
        try {
            if (excelReaderService != null) {
                excelReaderService.importExcel(context);
            }
        }
        catch (RuntimeException e) {
            log.warn(e.getMessage(), e.getCause());
            context.getExcelBook().setException(e);
        }
    }

    @Override
    public void after(Context context) {
        ExcelBook excelBook = context.getExcelBook();
        logger.info("\u4fdd\u5b58\u4fe1\u606f");
        context.getMessageRows().forEach((key, value) -> logger.info("key:{},value:{}", key, value));
        if (StringUtils.isEmpty((CharSequence)context.getSourceFilePath())) {
            context.setSourceFilePath(excelBook.getSourcePath().toString());
        }
        String targetFilePath = ExcelMessageUtils.write(context);
        logger.info("targetFilePath:{}", (Object)targetFilePath);
        excelBook.setTargetFileName(targetFilePath);
        Map<String, Summary> bookSummary = this.calcBookSummary(context.getMessageRows());
        Summary totalSummary = this.collectTotalSummary(bookSummary);
        SimpleExcelReader simpleExcelReader = context.getSimpleExcelReader();
        simpleExcelReader.setExcelBook(excelBook);
        simpleExcelReader.param("TOTAL_SIZE", totalSummary.getTotal());
        simpleExcelReader.param("SUCCESS_SIZE", totalSummary.getSuccess());
        simpleExcelReader.param("FAIL_SIZE", totalSummary.getFail());
        simpleExcelReader.param("SHEET_MESSAGE_KEY", totalSummary.getMessage());
        simpleExcelReader.param("SHEET_SIZE", bookSummary.size());
        simpleExcelReader.param("RESULT_STATE", this.isPartSuccess(totalSummary));
        simpleExcelReader.finish();
        ExcelFileDTO excelFileDTO = context.getFileDTO();
        excelFileDTO.setTargetFileId(simpleExcelReader.getExcelBook().getTargetFileId());
        excelFileDTO.setTargetFileName(context.getBusinessType().getBusinessName() + "\u5bfc\u5165\u7ed3\u679c" + ".xlsx");
        excelFileDTO.setEndDate(new Date());
        excelFileDTO.setCostTime(this.costTime(excelFileDTO.getBeginDate(), excelFileDTO.getEndDate()));
        excelFileDTO.setTotalSize(totalSummary.getTotal());
        excelFileDTO.setSuccessSize(totalSummary.getSuccess());
        if (bookSummary.size() > 0) {
            excelFileDTO.setMessage(totalSummary.getMessage());
        }
        excelFileDTO.setResultState(this.isPartSuccess(totalSummary));
        excelFileDTO.setStatus(3);
        this.afterUpdate(excelFileDTO);
        this.clear();
    }

    protected Integer isPartSuccess(Summary summary) {
        if (summary.getSuccess().equals(summary.getTotal())) {
            return 1;
        }
        if (summary.getSuccess() > 0 && summary.getSuccess() < summary.getTotal()) {
            return 2;
        }
        return 3;
    }

    protected Summary collectTotalSummary(Map<String, Summary> summaryMap) {
        Integer total = 0;
        Integer success = 0;
        Integer fail = 0;
        ArrayList<String> sheetMessages = new ArrayList<String>(summaryMap.size());
        for (Map.Entry<String, Summary> entry : summaryMap.entrySet()) {
            Summary summary = entry.getValue();
            total = total + summary.total;
            success = success + summary.success;
            fail = fail + summary.fail;
            sheetMessages.add(summary.getMessage());
        }
        String message = Joiner.on((String)";").join(sheetMessages);
        return new Summary("", total, success, fail, message);
    }

    protected Map<String, Summary> calcBookSummary(Map<String, MessageRow> messageRowMap) {
        HashMap<String, Summary> summaryMap = new HashMap<String, Summary>(messageRowMap.size());
        for (Map.Entry<String, MessageRow> rows : messageRowMap.entrySet()) {
            summaryMap.put(rows.getKey(), this.calcSheetSummary(rows.getKey(), rows.getValue().getRows()));
        }
        return summaryMap;
    }

    protected Summary calcSheetSummary(String sheetName, Map<Integer, MessageRow.Row> rows) {
        int total = 0;
        int success = 0;
        logger.info("sheetName:{},result-row size:{}", (Object)rows.size(), (Object)sheetName);
        for (Map.Entry<Integer, MessageRow.Row> row : rows.entrySet()) {
            ++total;
            if (!"\u6210\u529f".equals(row.getValue().getStatus())) continue;
            ++success;
        }
        int fail = total - success;
        Summary summary = new Summary(sheetName, total, success, fail);
        summary.setMessage(this.sheetMessage(summary));
        return summary;
    }

    protected String sheetMessage(Summary summary) {
        try {
            return MessageFormat.format("\u3010{0}\u3011\u5bfc\u5165\u7684\u603b\u6570\u4e3a:{1}\u6761\u6570\u636e\uff0c\u6210\u529f\u5bfc\u5165\u4e3a\uff1a{2}\u6761\u6570\u636e\uff0c\u5931\u8d25\u5bfc\u5165\u4e3a:{3}\u6761\u6570\u636e", summary.getSheetName(), String.valueOf(summary.getTotal()), String.valueOf(summary.getSuccess()), String.valueOf(summary.getFail()));
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return "";
        }
    }

    protected static class Summary {
        private String sheetName;
        private Integer total;
        private Integer success;
        private Integer fail;
        private String message;

        public Summary(String sheetName, Integer total, Integer success, Integer fail) {
            this.sheetName = sheetName;
            this.total = total;
            this.success = success;
            this.fail = fail;
        }

        public Summary(String sheetName, Integer total, Integer success, Integer fail, String message) {
            this(sheetName, total, success, fail);
            this.message = message;
        }

        public void setSheetName(String sheetName) {
            this.sheetName = sheetName;
        }

        public void setTotal(Integer total) {
            this.total = total;
        }

        public void setSuccess(Integer success) {
            this.success = success;
        }

        public void setFail(Integer fail) {
            this.fail = fail;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public String getSheetName() {
            return this.sheetName;
        }

        public Integer getTotal() {
            return this.total;
        }

        public Integer getSuccess() {
            return this.success;
        }

        public Integer getFail() {
            return this.fail;
        }

        public String getMessage() {
            return this.message;
        }

        public String toString() {
            return "ExcelImportProcessImpl.Summary(sheetName=" + this.getSheetName() + ", total=" + this.getTotal() + ", success=" + this.getSuccess() + ", fail=" + this.getFail() + ", message=" + this.getMessage() + ")";
        }
    }
}

