/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.business.excel.reader;

import com.xforceplus.business.excel.reader.Context;
import com.xforceplus.business.excel.reader.MessageRow;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ExcelMessageUtils {
    public static final String IMPORT_STATUS_COL_NAME = "\u5bfc\u5165\u6570\u636e\u72b6\u6001";
    public static final String IMPORT_MESSAGE_COL_NAME = "\u9519\u8bef\u63d0\u793a";
    private static final Logger logger = LoggerFactory.getLogger(ExcelMessageUtils.class);

    public static String write(Context context) {
        try (FileInputStream fileInputStream = new FileInputStream(context.getSourceFilePath());
             XSSFWorkbook workbook = new XSSFWorkbook((InputStream)fileInputStream);){
            for (Map.Entry<String, MessageRow> entry : context.getMessageRows().entrySet()) {
                XSSFSheet sheet = workbook.getSheet(entry.getKey());
                if (sheet == null) continue;
                Map<String, Integer> sheetHeaderMap = context.getSheetHeaderMap();
                Integer sheetHeaderNum = 0;
                if (sheetHeaderMap != null) {
                    sheetHeaderNum = sheetHeaderMap.get(sheet.getSheetName());
                    sheetHeaderNum = sheetHeaderNum != null && sheetHeaderNum > 0 ? Integer.valueOf(sheetHeaderNum - 1) : Integer.valueOf(0);
                }
                XSSFCellStyle cellStyle = ExcelMessageUtils.getCellStyle(workbook);
                ExcelMessageUtils.writeSheet(sheet, entry, context.getHeadMap(entry.getKey()).size(), cellStyle, sheetHeaderNum);
            }
            try (FileOutputStream out = new FileOutputStream(context.getTargetFilePath());){
                out.flush();
                workbook.write((OutputStream)out);
            }
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return context.getTargetFilePath();
    }

    private static XSSFCellStyle getCellStyle(XSSFWorkbook workbook) {
        XSSFCellStyle cellStyle = workbook.createCellStyle();
        XSSFFont font = workbook.createFont();
        font.setColor(IndexedColors.RED.getIndex());
        cellStyle.setFillForegroundColor(IndexedColors.YELLOW.getIndex());
        cellStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        cellStyle.setFont((Font)font);
        cellStyle.setWrapText(true);
        return cellStyle;
    }

    private static void writeSheet(XSSFSheet sheet, Map.Entry<String, MessageRow> entry, Integer headSize, XSSFCellStyle cellStyle, Integer headerNum) {
        XSSFRow hssfRow = sheet.getRow(headerNum.intValue());
        hssfRow.createCell(headSize.intValue()).setCellValue(IMPORT_STATUS_COL_NAME);
        hssfRow.createCell(headSize + 1).setCellValue(IMPORT_MESSAGE_COL_NAME);
        for (Map.Entry<Integer, MessageRow.Row> rowEntry : entry.getValue().getRows().entrySet()) {
            hssfRow = sheet.getRow(rowEntry.getKey().intValue());
            if (null == hssfRow) continue;
            if ("\u5931\u8d25".equals(rowEntry.getValue().getStatus())) {
                XSSFCell cell = hssfRow.createCell(headSize.intValue());
                cell.setCellStyle((CellStyle)cellStyle);
                cell.setCellValue(rowEntry.getValue().getStatus());
                XSSFCell cellMessage = hssfRow.createCell(headSize + 1);
                cellMessage.setCellStyle((CellStyle)cellStyle);
                cellMessage.setCellValue(rowEntry.getValue().getMessage());
                continue;
            }
            hssfRow.createCell(headSize.intValue()).setCellValue(rowEntry.getValue().getStatus());
            hssfRow.createCell(headSize + 1).setCellValue(rowEntry.getValue().getMessage());
        }
    }
}

