/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.business.excel.reader;

import com.xforceplus.business.excel.ExcelBook;
import com.xforceplus.business.excel.ExcelFile;
import com.xforceplus.business.excel.ExcelHandler;
import com.xforceplus.utils.filetransfer.FileTransferUtilsService;
import io.geewit.web.utils.SpringContextUtil;
import java.io.File;
import java.io.FileNotFoundException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileExcelReaderHandler
implements ExcelHandler {
    private static final Logger logger = LoggerFactory.getLogger(FileExcelReaderHandler.class);

    @Override
    public void before(ExcelBook excelBook) {
        if (StringUtils.isNotBlank((CharSequence)excelBook.getSourceFileName())) {
            logger.info("\u6587\u4ef6\u5df2\u5728\u672c\u5730\u5b58\u5728");
            return;
        }
        FileTransferUtilsService fileTransferUtilsService = (FileTransferUtilsService)SpringContextUtil.getBean(FileTransferUtilsService.class);
        String sourceFilePath = ExcelFile.createExcelFilePath();
        excelBook.setSourceFileName(sourceFilePath);
        try {
            logger.info("sourceFilePath:{}", (Object)sourceFilePath);
            fileTransferUtilsService.download(sourceFilePath, excelBook.getSourceFileId(), excelBook.getUserId(), excelBook.getTenantId());
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            excelBook.setException(new IllegalArgumentException("\u4e0a\u4f20\u6587\u4ef6\u4fdd\u5b58\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5"));
        }
        this.checkSize(new File(sourceFilePath));
        logger.info("\u4eceOSS\u4e0b\u8f7d\u6587\u4ef6");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void after(ExcelBook excelBook) {
        logger.info("\u5f00\u59cb\u4e0a\u4f20\u6587\u4ef6...");
        FileTransferUtilsService fileTransferUtilsService = (FileTransferUtilsService)SpringContextUtil.getBean(FileTransferUtilsService.class);
        File file = excelBook.getTargetPath().toFile();
        String filePath = file.getPath();
        try {
            this.checkSize(file);
        }
        catch (Exception e) {
            logger.warn(e.getMessage(), (Throwable)e);
            excelBook.setException(e);
            return;
        }
        try {
            logger.info("\u4e0a\u4f20\u6587\u4ef6\u8def\u5f84\u662f\uff1a{}", (Object)filePath);
            Long fileId = fileTransferUtilsService.upload(filePath, excelBook.getUserId(), excelBook.getTenantId());
            logger.info("\u4e0a\u4f20\u6210\u529f\u6587\u4ef6ID:{}", (Object)fileId);
            excelBook.setTargetFileId(fileId);
        }
        catch (FileNotFoundException e) {
            logger.error("\u9519\u8bef\u4fe1\u606f\u4e0a\u4f20\u6587\u4ef6\u670d\u52a1\u5931\u8d25,{}", (Object)filePath, (Object)e);
            excelBook.setException(new IllegalArgumentException("Excel\u89e3\u6790\u9519\u8bef\u63d0\u793a\u6587\u4ef6\uff0c\u4fdd\u5b58\u5931\u8d25"));
        }
        finally {
            FileUtils.deleteQuietly((File)file);
            FileUtils.deleteQuietly((File)excelBook.getSourcePath().toFile());
        }
        logger.info("\u7ed3\u675f\u4e0a\u4f20\u6587\u4ef6...");
    }

    protected void checkSize(File file) {
        long size = FileUtils.sizeOf((File)file);
        logger.info("filePath:{},fileSize:{}", (Object)file.getPath(), (Object)size);
        if (size == 0L) {
            throw new IllegalStateException("\u6587\u4ef6\u4e3a\u7a7a");
        }
    }
}

