/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.business.excel.reader;

import com.alibaba.excel.context.AnalysisContext;
import com.alibaba.excel.event.AnalysisEventListener;
import com.alibaba.excel.metadata.CellData;
import com.xforceplus.business.excel.DataRow;
import com.xforceplus.business.excel.ExcelValidator;
import com.xforceplus.business.excel.reader.Context;
import com.xforceplus.utils.BatchUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleDataReadListener {
    private static final Logger log = LoggerFactory.getLogger(SimpleDataReadListener.class);
    public static final int BATCH_SIZE = 3000;

    public static <T> AnalysisEventListener<T> listener(final Context context, final Consumer<List<T>> consumer) {
        return new AnalysisEventListener<T>(){
            private final List<T> list = new ArrayList();
            private final int batchSize = context.getFileDTO() != null ? context.getFileDTO().getBatchSize() : 3000;

            public void invoke(T data, AnalysisContext analysisContext) {
                if (data instanceof DataRow && !this.isEmptyRow(analysisContext)) {
                    Integer rowIndex = analysisContext.readRowHolder().getRowIndex();
                    ((DataRow)data).setRowIndex(rowIndex);
                    this.list.add(data);
                    if (this.list.size() >= this.batchSize) {
                        this.process(this.list);
                    }
                }
            }

            public void invokeHead(Map<Integer, CellData> headMap, AnalysisContext analysisContext) {
                context.setHeadMap(analysisContext.readSheetHolder().getSheetName(), headMap);
                super.invokeHead(headMap, analysisContext);
            }

            public void onException(Exception exception, AnalysisContext context2) throws Exception {
                if (this.list.size() > 0) {
                    this.process(this.list);
                }
                super.onException(exception, context2);
            }

            public void doAfterAllAnalysed(AnalysisContext context2) {
                if (this.list.size() > 0) {
                    this.process(this.list);
                }
            }

            private boolean isEmptyRow(AnalysisContext analysisContext) {
                Map celMap = analysisContext.readRowHolder().getCellMap();
                Set entrySet = celMap.entrySet();
                for (Map.Entry entry : entrySet) {
                    if (StringUtils.isEmpty((CharSequence)String.valueOf(entry.getValue()))) continue;
                    return false;
                }
                return true;
            }

            private void process(List<T> dataList) {
                ArrayList dataToProcess = new ArrayList(dataList);
                CompletableFuture<Void> future = BatchUtils.doBatchAsync(dataToProcess, this::batchValidate);
                future.get();
                consumer.accept(dataToProcess);
                this.list.clear();
            }

            private void batchValidate(List<T> dataList) {
                dataList.forEach(ExcelValidator::validate);
            }
        };
    }
}

