/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.business.excel.reader;

import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.event.AnalysisEventListener;
import com.alibaba.excel.read.builder.ExcelReaderSheetBuilder;
import com.alibaba.excel.write.metadata.WriteSheet;
import com.xforceplus.business.excel.ExcelBook;
import com.xforceplus.business.excel.ExcelHandler;
import com.xforceplus.business.excel.SimpleExcelWriter;
import com.xforceplus.business.excel.reader.FileExcelReaderHandler;
import com.xforceplus.business.excel.reader.MessageExcelReaderHandler;
import java.io.File;
import java.util.LinkedHashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class SimpleExcelReader {
    private static final Logger logger = LoggerFactory.getLogger(SimpleExcelWriter.class);
    private Map<String, ExcelHandler> handlers;
    private ExcelBook excelBook;
    private Map<String, WriteSheet> writeSheets;

    public SimpleExcelReader(Map<String, ExcelHandler> handlers, ExcelBook excelBook) {
        this.handlers = handlers;
        this.excelBook = excelBook;
    }

    public static Builder builder() {
        return new Builder();
    }

    protected SimpleExcelReader start() {
        this.beforeHandler();
        return this;
    }

    public void setException(Exception e) {
        this.excelBook.setException(e);
    }

    public void param(String key, Object obj) {
        this.excelBook.getParams().put(key, obj);
    }

    protected void beforeHandler() {
        if (this.isHandlerEmpty()) {
            return;
        }
        for (Map.Entry<String, ExcelHandler> entry : this.handlers.entrySet()) {
            logger.info("Execute before Handler:{}", (Object)entry.getKey());
            entry.getValue().before(this.excelBook);
        }
    }

    public <T> void read(Class<T> clazz, AnalysisEventListener<?> listener) {
        EasyExcel.read((File)this.getExcelBook().getSourcePath().toFile(), clazz, listener).sheet().doRead();
    }

    public <T> void read(Class<T> clazz, AnalysisEventListener<?> listener, int headerRowNum) {
        ((ExcelReaderSheetBuilder)EasyExcel.read((File)this.getExcelBook().getSourcePath().toFile(), clazz, listener).sheet().headRowNumber(Integer.valueOf(headerRowNum))).doRead();
    }

    public <T> void readSync(Class<T> clazz, AnalysisEventListener<?> listener) {
        EasyExcel.read((File)this.getExcelBook().getSourcePath().toFile(), clazz, listener).sheet().doReadSync();
    }

    public <T> void read(Class<?> clazz, AnalysisEventListener<?> listener, String sheetName) {
        EasyExcel.read((File)this.getExcelBook().getSourcePath().toFile(), clazz, listener).sheet(sheetName).doRead();
    }

    public <T> void read(Class<?> clazz, AnalysisEventListener<?> listener, String sheetName, int headerRowNum) {
        ((ExcelReaderSheetBuilder)EasyExcel.read((File)this.getExcelBook().getSourcePath().toFile(), clazz, listener).sheet(sheetName).headRowNumber(Integer.valueOf(headerRowNum))).doRead();
    }

    public <T> void read(Class<T> clazz, Integer sheetNo, AnalysisEventListener<?> listener, String sheetName) {
        EasyExcel.read((File)this.getExcelBook().getSourcePath().toFile(), clazz, listener).sheet(sheetNo, sheetName).doRead();
    }

    public <T> void read(Class<T> clazz, Integer sheetNo, AnalysisEventListener<?> listener, String sheetName, int headerRowNum) {
        ((ExcelReaderSheetBuilder)EasyExcel.read((File)this.getExcelBook().getSourcePath().toFile(), clazz, listener).sheet(sheetNo, sheetName).headRowNumber(Integer.valueOf(headerRowNum))).doRead();
    }

    protected boolean isHandlerEmpty() {
        if (CollectionUtils.isEmpty(this.handlers)) {
            logger.warn("SimpleExcelWriter hasn't Excel Handler");
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    protected void afterHandler() {
        if (this.isHandlerEmpty()) {
            return;
        }
        for (Map.Entry<String, ExcelHandler> entry : this.handlers.entrySet()) {
            logger.info("Execute After Handler:{}", (Object)entry.getKey());
            entry.getValue().after(this.excelBook);
        }
    }

    public void finish() {
        this.afterHandler();
    }

    public Map<String, ExcelHandler> getHandlers() {
        return this.handlers;
    }

    public ExcelBook getExcelBook() {
        return this.excelBook;
    }

    public Map<String, WriteSheet> getWriteSheets() {
        return this.writeSheets;
    }

    public void setHandlers(Map<String, ExcelHandler> handlers) {
        this.handlers = handlers;
    }

    public void setExcelBook(ExcelBook excelBook) {
        this.excelBook = excelBook;
    }

    public void setWriteSheets(Map<String, WriteSheet> writeSheets) {
        this.writeSheets = writeSheets;
    }

    public String toString() {
        return "SimpleExcelReader(handlers=" + this.getHandlers() + ", excelBook=" + this.getExcelBook() + ", writeSheets=" + this.getWriteSheets() + ")";
    }

    public static class Builder {
        public static final String DEFAULT_MESSAGE_HANDLER = "defaultMessageReaderHandler";
        public static final String DEFAULT_FILE_HANDLER = "defaultFileReaderHandler";
        private Map<String, ExcelHandler> handlers = new LinkedHashMap<String, ExcelHandler>(5);
        private ExcelBook excelBook;

        Builder() {
        }

        protected void init() {
            this.handlers.put(DEFAULT_FILE_HANDLER, new FileExcelReaderHandler());
            this.handlers.put(DEFAULT_MESSAGE_HANDLER, new MessageExcelReaderHandler());
        }

        public Builder handler(String name, ExcelHandler handler) {
            this.handlers.put(name, handler);
            return this;
        }

        public Builder excelBook(ExcelBook excelBook) {
            this.excelBook = excelBook;
            return this;
        }

        public SimpleExcelReader build() {
            this.init();
            return new SimpleExcelReader(this.handlers, this.excelBook).start();
        }
    }
}

