/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.business.excel.writer;

import com.xforceplus.business.excel.AbstractExcelProcess;
import com.xforceplus.business.excel.ExcelBook;
import com.xforceplus.business.excel.ExcelProcess;
import com.xforceplus.business.excel.SimpleExcelWriter;
import com.xforceplus.business.excel.file.ExcelFileDTO;
import com.xforceplus.business.excel.reader.Context;
import com.xforceplus.business.excel.writer.ExcelWriteUtils;
import com.xforceplus.business.service.ExcelWriteService;
import com.xforceplus.dao.ExcelFileStoreDao;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="excelExportProcess")
public class ExcelExportProcessImpl
extends AbstractExcelProcess
implements ExcelProcess {
    private static final Logger log = LoggerFactory.getLogger(ExcelExportProcessImpl.class);

    public ExcelExportProcessImpl(ExcelFileStoreDao excelFileStoreDao) {
        super(excelFileStoreDao);
    }

    @Override
    public void before(Context context) {
        block5: {
            SimpleExcelWriter simpleExcelWriter;
            ExcelFileDTO excelFileDTO;
            block4: {
                log.info("Excel process before...");
                this.beforeSet(context);
                excelFileDTO = context.getFileDTO();
                excelFileDTO.setBeginDate(new Date());
                simpleExcelWriter = null;
                try {
                    ExcelBook excelBook = ExcelBook.builder().name(context.getBusinessType().getBusinessName()).tenantId(excelFileDTO.getTenantId()).userId(excelFileDTO.getUserId()).excelSheets(context.getBusinessType().sheets()).sourceFileName(context.getBusinessType().getExportTemplateFile()).build();
                    simpleExcelWriter = SimpleExcelWriter.builder().excelBook(excelBook).build();
                    context.setExcelBook(excelBook);
                    excelFileDTO.setSourceFilePath(context.getSourceFilePath());
                    excelFileDTO.setStatus(2);
                    excelFileDTO.setReadTime(excelFileDTO.getReadTime() + 1);
                    context.setSourceFilePath(excelBook.getSourcePath().toString());
                    context.setSimpleExcelWriter(simpleExcelWriter);
                }
                catch (Exception e) {
                    if (simpleExcelWriter == null) break block4;
                    simpleExcelWriter.setException(new IllegalArgumentException("Excel\u6587\u4ef6\u89e3\u6790\u9519\u8bef\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5"));
                }
            }
            try {
                this.beforeUpdate(excelFileDTO);
            }
            catch (Exception e) {
                if (simpleExcelWriter == null) break block5;
                simpleExcelWriter.setException(new IllegalArgumentException("Excel\u6587\u4ef6\u89e3\u6790\u9519\u8bef\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5"));
            }
        }
    }

    @Override
    public void process(Context context) {
        this.before(context);
        try {
            this.doProcess(context);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            context.getExcelBook().setException(e);
        }
        this.after(context);
    }

    private void doProcess(Context context) {
        ExcelWriteService excelWriteService = ExcelWriteUtils.getExcelWriter(context.getBusinessType());
        if (excelWriteService != null) {
            excelWriteService.write(context);
        }
    }

    @Override
    public void after(Context context) {
        ExcelFileDTO excelFileDTO = context.getFileDTO();
        SimpleExcelWriter simpleExcelWriter = context.getSimpleExcelWriter();
        simpleExcelWriter.finish();
        ExcelBook excelBook = context.getExcelBook();
        log.info("targetFileId:{},targetFilePath:{}", (Object)simpleExcelWriter.getExcelBook().getTargetFileId(), (Object)excelBook.getTargetFileName());
        excelFileDTO.setTargetFileId(simpleExcelWriter.getExcelBook().getTargetFileId());
        excelFileDTO.setEndDate(new Date());
        excelFileDTO.setCostTime(this.costTime(excelFileDTO.getBeginDate(), excelFileDTO.getEndDate()));
        excelFileDTO.setStatus(3);
        excelFileDTO.setTargetFileName(context.getBusinessType().getBusinessName() + "\u5bfc\u51fa" + ".xlsx");
        excelFileDTO.setResultState(1);
        excelFileDTO.setSuccessSize(0);
        this.afterUpdate(excelFileDTO);
        this.clear();
    }
}

