/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.business.file.controller;

import com.xforceplus.api.common.response.ResponseEntity;
import com.xforceplus.business.excel.BusinessType;
import com.xforceplus.business.excel.ExcelConfig;
import com.xforceplus.business.excel.file.ExcelFileDTO;
import com.xforceplus.business.excel.writer.ExcelConfigBusinessType;
import com.xforceplus.business.file.controller.FileController;
import com.xforceplus.business.file.controller.vo.ExcelBusinessTypeRespVo;
import com.xforceplus.business.file.controller.vo.ExcelFileStorePageReqVo;
import com.xforceplus.business.file.controller.vo.ExcelFileStorePageRespVo;
import com.xforceplus.business.file.controller.vo.ExcelFileStoreRerunRespVo;
import com.xforceplus.business.file.service.ExcelFileStoreService;
import com.xforceplus.business.file.service.ExportFileService;
import com.xforceplus.business.file.service.ImportFileService;
import com.xforceplus.entity.ExcelFileStore;
import com.xforceplus.tenant.security.core.context.UserInfoHolder;
import com.xforceplus.tenant.security.core.domain.IAuthorizedUser;
import io.geewit.data.jpa.essential.domain.PageableFactory;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import javax.annotation.Resource;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/excelFileStories"})
@Api(value="ExcelFileStore", tags={"ExcelFileStore"})
public class ExcelFileStoreController {
    private static final Logger logger = LoggerFactory.getLogger(FileController.class);
    @Resource
    private ExcelFileStoreService excelFileStoreService;
    @Resource
    private ExportFileService exportFileService;
    @Resource
    private ImportFileService importFileService;

    @ApiOperation(value="\u4e1a\u52a1\u7c7b\u578b\u5217\u8868", notes="\u83b7\u53d6\u4e1a\u52a1\u5217\u8868")
    @GetMapping(name="\u4e1a\u52a1\u7c7b\u578b\u5217\u8868", value={"/businessType"})
    public ResponseEntity<List<ExcelBusinessTypeRespVo>> getBusinessType() {
        ArrayList<ExcelBusinessTypeRespVo> respVos = new ArrayList<ExcelBusinessTypeRespVo>();
        for (ExcelConfigBusinessType type : ExcelConfigBusinessType.values()) {
            respVos.add(new ExcelBusinessTypeRespVo(type.getBusinessName(), type.getName()));
        }
        return ResponseEntity.ok(respVos);
    }

    @ApiOperation(value="\u5206\u9875\u5217\u8868\u67e5\u8be2", notes="\u6839\u636e\u67e5\u8be2\u6761\u4ef6\u5206\u9875\u67e5\u8be2ExcelFile\u5217\u8868")
    @GetMapping(name="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    public ResponseEntity<Page<ExcelFileStorePageRespVo>> page(@ApiParam(value="request") ExcelFileStorePageReqVo query, @ApiParam(value="pageable") Pageable pageable) {
        Pageable currentPageable = PageableFactory.ofDefaultSort((Pageable)pageable, (Sort)Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"createTime"}));
        ExcelFileDTO fileDTO = new ExcelFileDTO();
        BeanUtils.copyProperties((Object)query, (Object)fileDTO);
        IAuthorizedUser authorizedUser = UserInfoHolder.get();
        if (authorizedUser != null) {
            fileDTO.setTenantId(authorizedUser.getTenantId());
            fileDTO.setUserId(authorizedUser.getId());
        }
        Page<ExcelFileStore> excelFileStorePage = this.excelFileStoreService.page(fileDTO, currentPageable);
        Page pageRespVos = excelFileStorePage.map(e -> {
            ExcelFileStorePageRespVo reqVo = new ExcelFileStorePageRespVo();
            BeanUtils.copyProperties((Object)e, (Object)reqVo);
            Optional<BusinessType> excelBusinessType = this.businessTypeValueOf(e.getBusinessType());
            if (excelBusinessType.isPresent()) {
                if (2 == e.getExcelFileType()) {
                    reqVo.setBusinessType(ExcelConfigBusinessType.valueOf(e.getBusinessType()).getBusinessName() + "\u5bfc\u51fa");
                } else {
                    reqVo.setBusinessType(excelBusinessType.get().getBusinessName() + "\u5bfc\u5165");
                }
            }
            reqVo.setExpired(this.excelFileExpired(e.getCreateTime()));
            return reqVo;
        });
        return ResponseEntity.ok((Object)pageRespVos);
    }

    private Optional<BusinessType> businessTypeValueOf(String businessTypeName) {
        Optional<BusinessType> businessType = Optional.empty();
        try {
            businessType = Optional.of(ExcelConfigBusinessType.valueOf(businessTypeName));
        }
        catch (Exception ex) {
            logger.warn(ex.getMessage(), (Throwable)ex);
        }
        return businessType;
    }

    private Boolean excelFileExpired(Date createTime) {
        DateTime dateTime = new DateTime((Object)createTime);
        return !(dateTime = dateTime.plusDays(ExcelConfig.getExpiredDay())).isAfterNow();
    }

    @ApiOperation(value="\u91cd\u65b0\u6267\u884c", notes="\u6839\u636eID\u91cd\u65b0\u6267\u884c\u5bfc\u5165\u5bfc\u51fa\u4efb\u52a1")
    @GetMapping(value={"/rerun/{id}"}, name="\u6839\u636eID\u91cd\u65b0\u6267\u884c\u5bfc\u5165\u6216\u5bfc\u51fa\u4efb\u52a1")
    public ResponseEntity<ExcelFileStoreRerunRespVo> rerun(@PathVariable(value="id") Long id) {
        Optional<ExcelFileStore> optionalExcelFileStore = this.excelFileStoreService.findById(id);
        if (!optionalExcelFileStore.isPresent()) {
            return ResponseEntity.fail((String)"0", (String)"\u6570\u636e\u4e0d\u5b58\u5728");
        }
        ExcelFileStore excelFileStore = optionalExcelFileStore.get();
        if (excelFileStore.getReadTime() >= ExcelConfig.getMaxRerunReadTime()) {
            return ResponseEntity.fail((String)"0", (String)"\u5df2\u8d85\u8fc7\u91cd\u8bd53\u6b21\u6570");
        }
        if (2 == excelFileStore.getStatus()) {
            return ResponseEntity.fail((String)"0", (String)"\u6b63\u5728\u6267\u884c\u4e2d...");
        }
        excelFileStore.setStatus(Integer.valueOf(2));
        excelFileStore.setSuccessSize(Integer.valueOf(0));
        excelFileStore.setTotalSize(Integer.valueOf(0));
        excelFileStore.setCostTime(Long.valueOf(0L));
        this.excelFileStoreService.update(excelFileStore);
        ExcelFileDTO excelFileDTO = new ExcelFileDTO();
        BeanUtils.copyProperties((Object)excelFileStore, (Object)excelFileDTO);
        if (2 == excelFileStore.getExcelFileType()) {
            this.exportFileService.rerun(excelFileDTO);
        } else if (1 == excelFileStore.getExcelFileType()) {
            this.importFileService.rerun(excelFileDTO);
        } else {
            return ResponseEntity.fail((String)"0", (String)"\u6ca1\u6709\u627e\u76f8\u5173\u7c7b\u578b \u7684\u6570\u636e");
        }
        return ResponseEntity.ok((Object)new ExcelFileStoreRerunRespVo());
    }
}

