/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.business.file.controller;

import com.alibaba.excel.util.DateUtils;
import com.xforceplus.business.enums.FileTemplateEnum;
import com.xforceplus.business.file.service.ImportFileService;
import com.xforceplus.tenant.core.exception.UnknownException;
import com.xforceplus.utils.BasePathUtils;
import com.xforceplus.utils.DownloadUtils;
import com.xforceplus.utils.filetransfer.FileTransferUtilsService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.File;
import java.util.Date;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Api(value="\u6587\u4ef6\u5904\u7406\u76f8\u5173\u63a5\u53e3", description="\u6587\u4ef6\u76f8\u5173\u63a5\u53e3")
@Validated
@Controller
@RequestMapping(value={"${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}"})
public class FileController {
    private static final Logger logger = LoggerFactory.getLogger(FileController.class);
    private static final String DOWNLOAD_FILE_NAME = "yyyyMMddHHmmssSSS";
    @Autowired
    private FileTransferUtilsService fileTransferUtilsService;
    @Autowired
    private ImportFileService importFileService;

    @ApiOperation(value="\u4e0b\u8f7d\u6587\u4ef6", notes="\u4e0b\u8f7d\u6587\u4ef6")
    @RequestMapping(name="\u4e0b\u8f7d\u6587\u4ef6", value={"/file/{fileId}"}, method={RequestMethod.GET})
    public void download(@PathVariable String fileId, HttpServletRequest request, HttpServletResponse response) {
        String filePath = BasePathUtils.ensureFilePath(request);
        try {
            logger.warn("\u4e0b\u8f7d\u5730\u5740\uff1a{}", (Object)filePath);
            this.fileTransferUtilsService.download(filePath, Long.valueOf(fileId));
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new UnknownException("\u4e0b\u8f7d\u6587\u4ef6\u5931\u8d25\u3002");
        }
        DownloadUtils.fileToDownload(response, filePath, DateUtils.format((Date)new Date(), (String)DOWNLOAD_FILE_NAME) + ".xlsx");
        this.deleteFile(filePath);
    }

    @Deprecated
    @ApiOperation(value="\u4e0b\u8f7d\u5bfc\u5165\u6a21\u677f")
    @RequestMapping(name="\u4e0b\u8f7d\u5bfc\u5165\u6a21\u677f", value={"/file/template"}, method={RequestMethod.GET})
    public void downloadTemplate(HttpServletRequest request, HttpServletResponse response, FileTemplateEnum.Template template) {
        String filePath = BasePathUtils.getTemplatePath(request, "templates", template.fileName());
        DownloadUtils.fileToDownload(response, filePath, template.targetName());
    }

    @ApiOperation(value="\u4e0b\u8f7d\u6279\u91cf\u5bfc\u5165\u6a21\u677f")
    @RequestMapping(name="\u4e0b\u8f7d\u6279\u91cf\u5bfc\u5165\u6a21\u677f", value={"/file/batchImportTemplate"}, method={RequestMethod.GET})
    public void importTemplate(HttpServletRequest request, HttpServletResponse response, FileTemplateEnum.BatchImportTemplate template) {
        String filePath = BasePathUtils.getTemplatePath(request, "templates/batch", template.fileName());
        DownloadUtils.fileToDownload(response, filePath, template.targetName());
    }

    private void deleteFile(String filePath) {
        File file = new File(filePath);
        if (file.exists()) {
            boolean deleteResult = file.delete();
            logger.info("\u5220\u9664\u6587\u4ef6\u7ed3\u679c:{}", (Object)deleteResult);
        }
    }
}

