/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.business.file.service;

import com.xforceplus.business.excel.file.ExcelFileDTO;
import com.xforceplus.dao.ExcelFileStoreDao;
import com.xforceplus.entity.ExcelFileStore;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Optional;
import javax.annotation.Resource;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import org.apache.commons.lang3.StringUtils;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ExcelFileStoreService {
    @Resource
    private ExcelFileStoreDao excelFileStoreDao;

    public Optional<ExcelFileStore> findById(Long id) {
        return this.excelFileStoreDao.findById((Object)id);
    }

    public Page<ExcelFileStore> page(ExcelFileDTO excelFileDTO, Pageable pageable) {
        return this.excelFileStoreDao.findAll(QueryHelper.querySpecification(excelFileDTO), pageable);
    }

    @Transactional(rollbackFor={RuntimeException.class})
    public void update(ExcelFileStore excelFileStore) {
        this.excelFileStoreDao.saveAndFlush((Object)excelFileStore);
    }

    public static final class QueryHelper {
        public static Specification<ExcelFileStore> querySpecification(ExcelFileDTO excelFileDTO) {
            return (Specification & Serializable)(root, criteriaQuery, builder) -> {
                ArrayList<Predicate> predicates = new ArrayList<Predicate>();
                predicates.add(builder.equal((Expression)root.get("tenantId"), (Object)excelFileDTO.getTenantId()));
                predicates.add(builder.equal((Expression)root.get("userId"), (Object)excelFileDTO.getUserId()));
                if (StringUtils.isNotBlank((CharSequence)excelFileDTO.getBusinessType())) {
                    predicates.add(builder.equal((Expression)root.get("businessType"), (Object)excelFileDTO.getBusinessType()));
                }
                if (excelFileDTO.getExcelFileType() != null) {
                    predicates.add(builder.equal((Expression)root.get("excelFileType"), (Object)excelFileDTO.getExcelFileType()));
                }
                if (excelFileDTO.getStatus() != null) {
                    predicates.add(builder.equal((Expression)root.get("status"), (Object)excelFileDTO.getStatus()));
                }
                if (excelFileDTO.getResultState() != null) {
                    predicates.add(builder.equal((Expression)root.get("resultState"), (Object)excelFileDTO.getResultState()));
                }
                if (!predicates.isEmpty()) {
                    criteriaQuery.where((Predicate[])predicates.stream().toArray(Predicate[]::new));
                }
                return criteriaQuery.getRestriction();
            };
        }
    }
}

