/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.business.file.service;

import com.alibaba.fastjson.JSON;
import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.eventbus.AsyncEventBus;
import com.google.common.eventbus.Subscribe;
import com.google.common.eventbus.SubscriberExceptionContext;
import com.google.common.eventbus.SubscriberExceptionHandler;
import com.xforceplus.business.excel.BusinessType;
import com.xforceplus.business.excel.ExcelProcess;
import com.xforceplus.business.excel.file.ExcelFileDTO;
import com.xforceplus.business.excel.reader.Context;
import com.xforceplus.business.excel.writer.ExcelConfigBusinessType;
import com.xforceplus.business.file.controller.FileController;
import com.xforceplus.config.ImportExportThreadPool;
import com.xforceplus.dao.ExcelFileStoreDao;
import com.xforceplus.entity.ExcelFileStore;
import com.xforceplus.tenant.security.core.context.UserInfoHolder;
import com.xforceplus.tenant.security.core.domain.IAuthorizedUser;
import io.geewit.core.utils.reflection.BeanUtils;
import io.geewit.web.utils.JsonUtils;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.Executor;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class ExportFileService
implements InitializingBean,
DisposableBean {
    public static final String ASYNC_EXCEL_EXPORT_PROCESS_EVENT_BUS = "AsyncExcelExportProcessEventBus";
    private static final Logger log = LoggerFactory.getLogger(FileController.class);
    private AsyncEventBus asyncEventBus;
    @Resource
    @Qualifier(value="excelExportProcess")
    private ExcelProcess excelProcess;
    @Resource
    private ExcelFileStoreDao excelFileStoreDao;

    public void destroy() throws Exception {
    }

    public void afterPropertiesSet() throws Exception {
        ExportSubscriberExceptionHandlerImpl subscriberExceptionHandler = new ExportSubscriberExceptionHandlerImpl();
        this.asyncEventBus = new AsyncEventBus((Executor)ImportExportThreadPool.get(), (SubscriberExceptionHandler)subscriberExceptionHandler);
        this.asyncEventBus.register((Object)new AsyncExcelProcessListener());
    }

    @Transactional(rollbackFor={RuntimeException.class})
    public ExcelFileStore asyncExcelExport(Map<String, Object> params, BusinessType businessType) {
        if (CollectionUtils.isEmpty(params)) {
            throw new IllegalArgumentException("\u5bfc\u51fa\u67e5\u8be2\u6761\u4ef6\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\uff01");
        }
        IAuthorizedUser authorizedUser = UserInfoHolder.currentUser();
        return this.asyncExcelExport(params, businessType, authorizedUser.getId(), authorizedUser.getTenantId());
    }

    @Transactional(rollbackFor={RuntimeException.class})
    public ExcelFileStore asyncExcelExport(Map<String, Object> params, BusinessType businessType, Long userId, Long tenantId) {
        ExcelFileDTO excelFileDTO = new ExcelFileDTO();
        excelFileDTO.setBusinessType(businessType.getName());
        excelFileDTO.setTenantId(tenantId);
        excelFileDTO.setUserId(userId);
        excelFileDTO.setStatus(1);
        excelFileDTO.setResultState(0);
        excelFileDTO.setReadTime(0);
        excelFileDTO.setSuccessSize(0);
        excelFileDTO.setTotalSize(0);
        excelFileDTO.setExcelFileType(2);
        excelFileDTO.setParams(JsonUtils.toJson(params));
        excelFileDTO.setCreateTime(new Date());
        ExcelFileStore excelFileStore = this.create(excelFileDTO);
        this.asyncExcelProcess(params, excelFileDTO, businessType);
        return excelFileStore;
    }

    @Transactional(rollbackFor={RuntimeException.class})
    public ExcelFileStore create(ExcelFileDTO excelFileDTO) {
        ExcelFileStore excelFileStore = new ExcelFileStore();
        BeanUtils.copyProperties((Object)excelFileDTO, (Object)excelFileStore, (String[])new String[]{"id"});
        this.excelFileStoreDao.saveAndFlush((Object)excelFileStore);
        BeanUtils.copyProperties((Object)excelFileStore, (Object)excelFileDTO);
        return excelFileStore;
    }

    @Transactional(rollbackFor={RuntimeException.class})
    public ExcelFileDTO rerun(ExcelFileDTO excelFileDTO) {
        ExcelConfigBusinessType businessType;
        if (StringUtils.isBlank((CharSequence)excelFileDTO.getParams())) {
            throw new IllegalArgumentException("\u67e5\u8be2\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        excelFileDTO.setRerun(true);
        Map params = (Map)JsonUtils.fromJson((String)excelFileDTO.getParams(), (TypeReference)new TypeReference<Map<String, Object>>(){});
        try {
            businessType = ExcelConfigBusinessType.valueOf(excelFileDTO.getBusinessType());
        }
        catch (Exception e) {
            throw new IllegalArgumentException("\u4e1a\u52a1\u7c7b\u578b\u4e0d\u6b63\u786e\uff0c\u8bf7\u91cd\u65b0\u4e0a\u4f20");
        }
        log.info("params:{},businessType:{}", (Object)params, (Object)businessType);
        this.asyncExcelProcess(params, excelFileDTO, businessType);
        return excelFileDTO;
    }

    private void asyncExcelProcess(Map<String, Object> params, ExcelFileDTO excelFileDTO, BusinessType importBusinessType) {
        log.info("importBusinessType:{},importFileDTO:{}", (Object)JSON.toJSONString((Object)importBusinessType), (Object)JSON.toJSONString((Object)excelFileDTO));
        Context context = Context.builder().businessType(importBusinessType).fileDTO(excelFileDTO).sourceFilePath(excelFileDTO.getSourceFilePath()).params(params).authorizedUser(UserInfoHolder.get()).build();
        try {
            this.asyncEventBus.post((Object)context);
        }
        catch (Exception e) {
            log.error("asyncExcelProcess:" + e.getMessage(), (Throwable)e);
            throw new IllegalArgumentException("\u5bfc\u5165\u6570\u636e\u5931\u8d25\uff0c\u5f53\u524d\u670d\u52a1\u5668\u7e41\u5fd9\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5");
        }
    }

    protected class AsyncExcelProcessListener {
        protected AsyncExcelProcessListener() {
        }

        @Subscribe
        public void doProcess(Context context) {
            ExportFileService.this.excelProcess.process(context);
        }
    }

    protected class ExportSubscriberExceptionHandlerImpl
    implements SubscriberExceptionHandler {
        protected ExportSubscriberExceptionHandlerImpl() {
        }

        public void handleException(Throwable exception, SubscriberExceptionContext context) {
            log.error(exception.getMessage(), exception);
            log.error("context:{}", (Object)JSON.toJSONString((Object)context));
        }
    }
}

