/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.business.file.service;

import com.alibaba.fastjson.JSON;
import com.xforceplus.utils.excel.ExcelUtils;
import com.xforceplus.utils.filetransfer.FileTransferUtilsService;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="sysFileService")
public class FileService {
    private static final Logger log = LoggerFactory.getLogger(FileService.class);
    @Autowired
    private FileTransferUtilsService fileTransferUtilsService;

    public Long uploadMsgExcel(List<String> errorMsgs) {
        if (CollectionUtils.isNotEmpty(errorMsgs)) {
            String filePath = "";
            try {
                ArrayList rows = new ArrayList();
                for (String errorMsg : errorMsgs) {
                    LinkedHashMap<String, String> row = new LinkedHashMap<String, String>();
                    row.put("key", errorMsg);
                    rows.add(row);
                }
                HashMap<String, String> rules = new HashMap<String, String>(2);
                rules.put("key", "\u5bfc\u5165\u9519\u8bef\u4fe1\u606f");
                String sheetName = "\u5bfc\u5165\u9519\u8bef\u4fe1\u606f";
                String json = JSON.toJSONString(rows);
                filePath = ExcelUtils.buildExcelFile(json, rules, sheetName);
                return this.fileTransferUtilsService.upload(filePath);
            }
            catch (FileNotFoundException e) {
                log.error("\u9519\u8bef\u4fe1\u606f\u4e0a\u4f20oss\u5931\u8d25,{}", (Object)filePath);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long exportDataExcel(String json, Map<String, String> rules, String sheetName) {
        String filePath = "";
        try {
            filePath = ExcelUtils.buildExcelFile(json, rules, sheetName);
            log.info("excel path=={}", (Object)filePath);
        }
        catch (Exception e) {
            log.error("\u8f6cexcel\u5931\u8d25,{}", (Object)filePath);
        }
        try {
            Long e = this.fileTransferUtilsService.upload(filePath);
            return e;
        }
        catch (FileNotFoundException e) {
            log.error("\u5bfc\u51fa\u4fe1\u606f\u4e0a\u4f20\u6587\u4ef6\u670d\u52a1\u5931\u8d25,{}", (Object)filePath);
        }
        finally {
            this.deleteFile(filePath);
        }
        return null;
    }

    private void deleteFile(String filePath) {
        File file = new File(filePath);
        if (file.exists()) {
            boolean deleteResult = file.delete();
            log.info("\u5220\u9664\u6587\u4ef6\uff1a{},\u7ed3\u679c:{}", (Object)filePath, (Object)deleteResult);
        }
    }
}

