/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.business.log.service;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.xforceplus.dao.SystemLogDao;
import com.xforceplus.domain.log.SystemLogDTO;
import com.xforceplus.entity.SystemLog;
import com.xforceplus.utils.EntityHelp;
import io.geewit.web.utils.JsonUtils;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.persistence.Id;
import javax.persistence.Table;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class LogService {
    private static Logger logger = LoggerFactory.getLogger(LogService.class);
    @Autowired
    private SystemLogDao systemLogDao;
    private ExecutorService logThreadPool = this.createThreadPool();

    private static <T> SystemLog getLogEntity(T doEntity) throws IllegalAccessException {
        SystemLog log = new SystemLog();
        log.setCreateTime(new Date());
        Class<?> doClass = doEntity.getClass();
        Table table = doClass.getAnnotation(Table.class);
        if (null == table) {
            throw new IllegalArgumentException(doClass.getSimpleName() + "\u672a\u6709@Table\u6ce8\u89e3");
        }
        log.setTableName(table.name());
        try {
            for (Method method : doClass.getMethods()) {
                if (null == method.getAnnotation(Id.class) || !method.getName().startsWith("get")) continue;
                method.setAccessible(true);
                log.setIdentityId((Long)method.invoke(doEntity, new Object[0]));
                break;
            }
        }
        catch (InvocationTargetException e) {
            logger.error("build SystemLog error,{}", (Throwable)e);
        }
        return log;
    }

    private void doInsertLog(SystemLog logEntity) {
        this.systemLogDao.saveAndFlush((Object)logEntity);
    }

    private ExecutorService createThreadPool() {
        int corePoolSize = 10;
        int maximumPoolSize = 200;
        ThreadFactory namedThreadFactory = new ThreadFactoryBuilder().setNameFormat("log-pool-%d").build();
        ThreadPoolExecutor threadPool = new ThreadPoolExecutor(corePoolSize, maximumPoolSize, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(10), namedThreadFactory, new ThreadPoolExecutor.AbortPolicy());
        return threadPool;
    }

    public <T> void insertLogBatch(List<Pair> doEntities, SystemLogDTO dto) {
        this.logThreadPool.execute(() -> {
            for (int i = 0; i < doEntities.size(); ++i) {
                this.doLog(((Pair)doEntities.get(i)).getLeft(), ((Pair)doEntities.get(i)).getRight(), dto);
            }
        });
    }

    public <T> void insertLog(T oldEntity, T doEntity, SystemLogDTO dto) {
        this.logThreadPool.execute(() -> this.doLog(oldEntity, doEntity, dto));
    }

    public <T> void doLog(T oldEntity, T doEntity, SystemLogDTO dto) {
        if (null == doEntity || null == oldEntity) {
            return;
        }
        try {
            SystemLog saveObj = LogService.getLogEntity(doEntity);
            saveObj.setBatchId(dto.getBatchId());
            saveObj.setBusinessType(dto.getBusinessType());
            saveObj.setActionCode(dto.getActionCode());
            saveObj.setRemark(dto.getRemark());
            Map<Object, Object> contentMap = new HashMap();
            switch (dto.getActionCode()) {
                case D: {
                    BeanUtils.populate(oldEntity, contentMap);
                    break;
                }
                case I: {
                    BeanUtils.populate(doEntity, contentMap);
                    break;
                }
                case U: {
                    contentMap = EntityHelp.compareObject(oldEntity, doEntity);
                    break;
                }
            }
            if (!contentMap.isEmpty()) {
                String json = JsonUtils.toJson(contentMap);
                saveObj.setContent(json);
            }
            this.doInsertLog(saveObj);
        }
        catch (Exception ex) {
            logger.error("DB\u64cd\u4f5c\u65e5\u5fd7\u4fee\u6539\u5199\u5165\u5931\u8d25\uff0cex ,{} " + ex.toString());
        }
    }
}

