/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.business.message.service;

import com.xforceplus.feign.tenant.message.EmailAuthCodeFeignClient;
import com.xforceplus.feign.tenant.message.SmsAuthCodeFeignClient;
import com.xforceplus.utils.PropertiesUtils;
import com.xforececlound.message.model.AuthCodeResp;
import com.xforececlound.message.model.EmailAuthCodeReq;
import com.xforececlound.message.model.EmailValidateReq;
import com.xforececlound.message.model.SmsCodeReq;
import com.xforececlound.message.model.SmsValidateReq;
import com.xforececlound.message.model.SmsValidateResp;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MessageService {
    @Autowired
    private EmailAuthCodeFeignClient emailAuthCodeFeignClient;
    @Autowired
    private SmsAuthCodeFeignClient smsAuthCodeFeignClient;

    private Long getTenantId() {
        return 0L;
    }

    public String sendAuthEmailCode(String email) {
        Long tenantId = this.getTenantId();
        EmailAuthCodeReq emailAuthCodeReq = new EmailAuthCodeReq();
        emailAuthCodeReq.setAppId(Long.valueOf(1L));
        emailAuthCodeReq.setEmail(email);
        emailAuthCodeReq.setTemplateCode(PropertiesUtils.EMAIL_CHANGE_PHONE);
        emailAuthCodeReq.setTenantId(tenantId);
        emailAuthCodeReq.setExpireTime(Integer.valueOf(3));
        AuthCodeResp resp = this.emailAuthCodeFeignClient.sendAuthCode(String.valueOf(tenantId), emailAuthCodeReq);
        if (resp == null) {
            throw new IllegalArgumentException("\u53d1\u9001\u9a8c\u8bc1\u7801\u5931\u8d25\u3002");
        }
        if (resp.getCode() != 1) {
            throw new IllegalArgumentException(resp.getDesc());
        }
        return resp.getMsgId();
    }

    public String sendAuthSmsCode(String phone) {
        Long tenantId = this.getTenantId();
        SmsCodeReq smsCodeReq = new SmsCodeReq();
        smsCodeReq.setMobile(phone);
        smsCodeReq.setSignName("\u7968\u7a0e\u52a9\u624b");
        smsCodeReq.setTemplateCode(PropertiesUtils.SMS_CHANGE_PHONE);
        smsCodeReq.setTenantId(tenantId);
        AuthCodeResp resp = this.smsAuthCodeFeignClient.sendAuthCode(String.valueOf(tenantId), smsCodeReq);
        if (resp == null) {
            throw new IllegalArgumentException("\u53d1\u9001\u9a8c\u8bc1\u7801\u5931\u8d25\u3002");
        }
        if (resp.getCode() != 1) {
            throw new IllegalArgumentException(resp.getDesc());
        }
        return resp.getMsgId();
    }

    public boolean checkAuthEmailCode(String captcha, String email, String msgId) {
        Long tenantId = this.getTenantId();
        EmailValidateReq emailValidateReq = new EmailValidateReq();
        emailValidateReq.setCode(captcha);
        emailValidateReq.setEmail(email);
        emailValidateReq.setMsgId(msgId);
        SmsValidateResp resp = this.emailAuthCodeFeignClient.validate(tenantId + "", emailValidateReq);
        return null != resp && resp.isCheck();
    }

    public boolean checkAuthSmsCode(String captcha, String phone, String msgId) {
        Long tenantId = this.getTenantId();
        SmsValidateReq smsValidateReq = new SmsValidateReq();
        smsValidateReq.setCode(captcha);
        smsValidateReq.setMobile(phone);
        smsValidateReq.setMsgId(msgId);
        SmsValidateResp resp = this.smsAuthCodeFeignClient.validate(tenantId + "", smsValidateReq);
        return null != resp && resp.isCheck();
    }
}

