/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.business.messagebus.bus;

import com.xforceplus.janus.message.sdk.MBClient;
import com.xforceplus.janus.message.sdk.RequestMessage;
import com.xforceplus.janus.message.sdk.request.PubRequest;
import com.xforceplus.janus.message.sdk.response.PubResponse;
import io.geewit.web.utils.JsonUtils;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Service;

@ConditionalOnProperty(prefix="pubsub", name={"enable"}, havingValue="true")
@Service
public class MessageBusService {
    private static Logger logger = LoggerFactory.getLogger(MessageBusService.class);
    private MBClient client;
    @Value(value="${remote.message.bus.server.url:}")
    private String url;
    @Value(value="${remote.message.bus.server.token:}")
    private String token;

    @PostConstruct
    public void init() {
        try {
            this.client = MBClient.getInstance((String)this.url, (String)this.token);
        }
        catch (Exception e) {
            logger.warn("message bus connect error", (Throwable)e);
        }
    }

    public String sendMessage(String requestName, String content, Map<String, String> tagkvs) {
        logger.info("xforce.message.bus.requestName={},tagkvs={},content={}", new Object[]{requestName, JsonUtils.toJson(tagkvs), content});
        try {
            RequestMessage requestMessage = new RequestMessage();
            requestMessage.setContent(content);
            requestMessage.addProperties(tagkvs);
            requestMessage.setSentTime(System.currentTimeMillis());
            PubRequest pubRequest = new PubRequest(requestName, requestMessage);
            PubResponse pub = this.client.pub(pubRequest);
            if (!pub.getSuccess().booleanValue()) {
                logger.error("send_message_error,error:{}", (Object)pub);
            }
            return JsonUtils.toJson((Object)pub);
        }
        catch (Exception e) {
            logger.error("message bus sendMessage messahe bus error", (Throwable)e);
            return null;
        }
    }
}

