/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.business.messagebus.bus;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.eventbus.AsyncEventBus;
import com.google.common.eventbus.Subscribe;
import com.xforceplus.api.model.CompanyModel;
import com.xforceplus.business.company.service.CompanyService;
import com.xforceplus.business.messagebus.model.ZeusCompany;
import com.xforceplus.business.messagebus.model.ZeusTenant;
import com.xforceplus.business.messagebus.model.ZeusUser;
import com.xforceplus.business.messagebus.model.ZeusUserRelCompany;
import com.xforceplus.business.tenant.service.OrgService;
import com.xforceplus.business.tenant.service.TenantService;
import com.xforceplus.business.tenant.service.UserService;
import com.xforceplus.dao.AccountDao;
import com.xforceplus.dao.OrgUserRelDao;
import com.xforceplus.dao.TenantDao;
import com.xforceplus.dao.UserDao;
import com.xforceplus.entity.Account;
import com.xforceplus.entity.Company;
import com.xforceplus.entity.OrgStruct;
import com.xforceplus.entity.Tenant;
import com.xforceplus.entity.User;
import com.xforceplus.janus.message.sdk.MBClient;
import com.xforceplus.janus.message.sdk.ResponseMessage;
import com.xforceplus.janus.message.sdk.request.AckRequest;
import com.xforceplus.janus.message.sdk.response.AckResponse;
import com.xforceplus.janus.message.sdk.response.SubResponse;
import com.xforceplus.tenant.security.core.domain.OrgType;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

@Component
@ConditionalOnExpression(value="${xforce.zeus.sync.enabled:false}")
public class ZeusPayerSyncService
implements InitializingBean,
DisposableBean {
    private static final Logger log = LoggerFactory.getLogger(ZeusPayerSyncService.class);
    @Autowired
    private CompanyService companyService;
    @Autowired
    private TenantService tenantService;
    @Autowired
    private OrgService orgService;
    @Autowired
    private UserDao userDao;
    @Autowired
    private AccountDao accountDao;
    @Autowired
    private TenantDao tenantDao;
    @Autowired
    private UserService userService;
    @Autowired
    private OrgUserRelDao orgUserRelDao;
    static final SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
    @Value(value="${remote.message.bus.server.url:}")
    private String url;
    @Value(value="${remote.message.bus.server.token:}")
    private String token;
    @Value(value="${zeus.bus.topic.company:zeus.pub.tenant-company-rel}")
    private String companyTopic;
    @Value(value="${zeus.bus.topic.user:zeus.pub.user}")
    private String userTopic;
    @Value(value="${zeus.bus.topic.tenant:zeus.pub.tenant}")
    private String tenantTopic;
    @Value(value="${zeus.bus.topic.user-rel-company:zeus.pub.user-rel-company}")
    private String userRelCompanyTopic;
    private MBClient client;
    @Autowired
    private ThreadPoolExecutor threadPoolExecutor;
    private AsyncEventBus asyncEventBus;

    @Scheduled(fixedRate=1000L)
    public void pullZeusMessage() {
        log.info("polling zeusPayer message...");
        SubResponse subResponse = this.client.sub();
        if (subResponse.getSuccess().booleanValue()) {
            subResponse.getResponseMessages().forEach(message -> {
                if (this.companyTopic.equalsIgnoreCase(message.getPubCode()) || this.userTopic.equalsIgnoreCase(message.getPubCode()) || this.tenantTopic.equalsIgnoreCase(message.getPubCode()) || this.userRelCompanyTopic.equalsIgnoreCase(message.getPubCode())) {
                    log.info("get message id:{},content:{}", (Object)message.getId(), (Object)message.getContent());
                    this.asyncEventBus.post(message);
                }
            });
        } else {
            log.error("pull zeus message error:{}", (Object)subResponse.getError());
        }
    }

    public void destroy() throws Exception {
        this.threadPoolExecutor.shutdown();
    }

    public void afterPropertiesSet() throws Exception {
        this.asyncEventBus = new AsyncEventBus((Executor)this.threadPoolExecutor, (exception, context) -> log.error(exception.getMessage(), exception));
        this.asyncEventBus.register((Object)new AsyncEventProcessListener());
    }

    @PostConstruct
    public void initPubsubConf() {
        try {
            log.info("starting init MBClient...");
            this.client = MBClient.getInstance((String)this.url, (String)this.token);
        }
        catch (Exception e) {
            log.error("error while initializing pubsub config:{}", (Object)e.getMessage());
        }
    }

    public boolean handleMessage(ResponseMessage message) {
        if (message == null) {
            log.error("cannot handle null message");
            return true;
        }
        String content = message.getContent();
        if (ObjectUtils.isEmpty((Object)content)) {
            log.error("cannot handle null content, messageId {}", (Object)message.getId());
            return true;
        }
        if (this.companyTopic.equalsIgnoreCase(message.getPubCode())) {
            try {
                this.doCompany(content);
            }
            catch (Exception e) {
                log.error("\u6d88\u8d39zeus\u516c\u53f8\u5f02\u5e38", (Throwable)e);
            }
        } else if (this.userTopic.equalsIgnoreCase(message.getPubCode())) {
            try {
                this.doUser(content);
            }
            catch (Exception e) {
                log.error("\u6d88\u8d39zeus\u7528\u6237\u5f02\u5e38", (Throwable)e);
            }
        } else if (this.tenantTopic.equalsIgnoreCase(message.getPubCode())) {
            try {
                this.doTenant(content);
            }
            catch (Exception e) {
                log.error("\u6d88\u8d39zeus\u79df\u6237\u5f02\u5e38", (Throwable)e);
            }
        } else if (this.userRelCompanyTopic.equalsIgnoreCase(message.getPubCode())) {
            try {
                this.doUserRelCompany(content);
            }
            catch (Exception e) {
                log.error("\u6d88\u8d39zeus\u4eba\u5458-rel-\u516c\u53f8\u5f02\u5e38", (Throwable)e);
            }
        }
        return true;
    }

    private void doCompany(String content) {
        ZeusCompany.Model.CompanyRelModel companyRelModel = (ZeusCompany.Model.CompanyRelModel)JSONObject.parseObject((String)content, ZeusCompany.Model.CompanyRelModel.class);
        ZeusCompany.Model.CompanyModel companyModel = companyRelModel.getCompany();
        ZeusCompany.Model.RelModel relModel = companyRelModel.getRel();
        if (null == companyModel) {
            throw new IllegalArgumentException("zeus.company.companyModel is null");
        }
        if (null == relModel) {
            throw new IllegalArgumentException("zeus.company.relModel is null");
        }
        if (null == companyModel.getExternalId()) {
            throw new IllegalArgumentException("zeus.company.externalId is null");
        }
        Long tenantId = relModel.getTenantId();
        if (null == tenantId) {
            throw new IllegalArgumentException("zeus.company.tenantId is null");
        }
        Company saveObj = this.companyService.getByTaxNum(companyModel.getTaxNum());
        CompanyModel.Request.Query query = new CompanyModel.Request.Query();
        query.setCompanyId(companyModel.getExternalId());
        Company extCompany = this.companyService.findOne(query).orElse(null);
        if (null != saveObj && null != extCompany && !saveObj.getCompanyId().equals(extCompany.getCompanyId())) {
            throw new IllegalArgumentException("\u5df2\u5b58\u5728\u7684\u7a0e\u53f7id:" + saveObj.getCompanyId() + "\u4e0ezeus\u7684\u7a0e\u53f7id:" + extCompany.getCompanyId() + "\u4e0d\u4e00\u81f4");
        }
        List<Object> orgStructs = new ArrayList();
        Company save = new Company();
        save.setCompanyId(companyModel.getExternalId());
        save.setTaxNum(companyModel.getTaxNum());
        save.setStatus(Integer.valueOf(1));
        save.setRegistLocationAddr(companyModel.getChineseAddress());
        save.setTaxpayerQualificationType(companyModel.getTaxpayerType());
        save.setCompanyName(companyModel.getCompanyName());
        save.setCompanyCode(companyModel.getCompanyCode());
        save.setHostTenantId(tenantId);
        save.setUpdaterId(companyModel.getUpdateUserId());
        save.setUpdaterName(companyModel.getUpdateUserId());
        try {
            save.setUpdateTime(sdf.parse(companyModel.getUpdateTime()));
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        if (null == saveObj && null == extCompany) {
            save.setCreaterId(companyModel.getCreateUserId());
            save.setHostTenantId(relModel.getTenantId());
            save.setCreaterId(companyModel.getCreateUserId());
            save.setCreaterName(companyModel.getCreateUserId());
            try {
                save.setCreateTime(sdf.parse(companyModel.getCreateTime()));
            }
            catch (ParseException parseException) {
                // empty catch block
            }
            this.companyService.saveAndFlush(save);
        } else if (null != extCompany) {
            if (sdf.format(extCompany.getUpdateTime()).equals(companyModel.getUpdateTime())) {
                log.info("company.updateTime\u4e00\u81f4\uff0c\u4e0d\u505a\u64cd\u4f5cid:{}", (Object)extCompany.getCompanyId());
                return;
            }
            save.setCompanyId(extCompany.getCompanyId());
            this.companyService.saveAndFlush(save);
            orgStructs = this.orgService.findByTenantIdAndCompanyId(tenantId, save.getCompanyId());
        } else {
            if (sdf.format(saveObj.getUpdateTime()).equals(companyModel.getUpdateTime())) {
                log.info("company.updateTime\u4e00\u81f4\uff0c\u4e0d\u505a\u64cd\u4f5cid:{}", (Object)saveObj.getCompanyId());
                return;
            }
            save.setCompanyId(saveObj.getCompanyId());
            this.companyService.saveAndFlush(save);
            orgStructs = this.orgService.findByTenantIdAndCompanyId(tenantId, save.getCompanyId());
        }
        if (CollectionUtils.isEmpty(orgStructs)) {
            OrgStruct org = new OrgStruct();
            org.setTenantId(tenantId);
            org.setCompanyId(save.getCompanyId());
            org.setOrgName(save.getCompanyName());
            org.setOrgCode(save.getCompanyCode());
            org.setOrgType(OrgType.COMPANY);
            org.setStatus(Integer.valueOf(1));
            org.setOrgDesc("zeus\u540c\u6b65");
            this.orgService.saveAndFlush(org);
        } else {
            for (OrgStruct orgStruct : orgStructs) {
                orgStruct.setOrgName(save.getCompanyName());
                orgStruct.setOrgCode(save.getCompanyCode());
                orgStruct.setStatus(Integer.valueOf(1));
                orgStruct.setOrgDesc("zeus\u540c\u6b65");
                this.orgService.saveAndFlush(orgStruct);
            }
        }
    }

    private void doUser(String content) {
        Account account;
        ZeusUser.Model.UserAccountModel userAccountModel = (ZeusUser.Model.UserAccountModel)JSONObject.parseObject((String)content, ZeusUser.Model.UserAccountModel.class);
        Long tenantId = userAccountModel.getTenantId();
        ZeusUser.Model.AccountModel accountModel = userAccountModel.getAccount();
        ZeusUser.Model.UserModel userModel = userAccountModel.getUser();
        if (null == tenantId) {
            throw new IllegalArgumentException("zeus.account.tenantId is null");
        }
        if (null == userModel) {
            throw new IllegalArgumentException("zeus.account.userModel is null");
        }
        if (null == accountModel) {
            throw new IllegalArgumentException("zeus.account.accountModel is null");
        }
        if (null == accountModel.getExternalId()) {
            throw new IllegalArgumentException("zeus.account.externalId is null");
        }
        accountModel.setPassword(accountModel.getPassword().toUpperCase());
        HashMap<Long, Account> accountMap = new HashMap<Long, Account>();
        if (StringUtils.isNotBlank((CharSequence)accountModel.getEmail()) && null != (account = this.accountDao.findByEmail(accountModel.getEmail()))) {
            accountMap.put(account.getAccountId(), account);
        }
        if (StringUtils.isNotBlank((CharSequence)accountModel.getMobile()) && null != (account = this.accountDao.findByTelPhone(accountModel.getMobile()))) {
            accountMap.put(account.getAccountId(), account);
        }
        if (StringUtils.isNotBlank((CharSequence)accountModel.getAccountName()) && null != (account = this.accountDao.findByUsername(accountModel.getAccountName()))) {
            accountMap.put(account.getAccountId(), account);
        }
        if (accountMap.size() > 1) {
            log.error("zeus\u4e00\u4e2a\u8d26\u53f7\u5bf9\u5e94\u7528\u6237\u4e2d\u5fc3\u591a\u4e2a\u8d26\u53f7\uff0cemail\uff1a{},mobile\uff1a{}\uff0caccount\uff1a{}", new Object[]{accountModel.getEmail(), accountModel.getMobile(), accountModel.getAccountName()});
            throw new IllegalArgumentException("zeus\u4e00\u4e2a\u8d26\u53f7\u5bf9\u5e94\u7528\u6237\u4e2d\u5fc3\u591a\u4e2a\u8d26\u53f7");
        }
        if (accountMap.size() == 0) {
            account = new Account();
            account.setAccountId(accountModel.getExternalId());
            account.setPassword(accountModel.getPassword());
            account.setUsername(accountModel.getAccountName());
            account.setTelPhone(accountModel.getMobile());
            account.setEmail(accountModel.getEmail());
            account.setChangePasswordFlag(Boolean.valueOf(false));
            account.setCreaterId(accountModel.getCreateUserId());
            account.setCreaterName(accountModel.getCreateUserId());
            try {
                account.setCreateTime(sdf.parse(accountModel.getCreateTime()));
            }
            catch (ParseException parseException) {
                // empty catch block
            }
            account.setUpdaterId(accountModel.getUpdateUserId());
            account.setUpdaterName(accountModel.getUpdateUserId());
            try {
                account.setUpdateTime(sdf.parse(accountModel.getUpdateTime()));
            }
            catch (ParseException parseException) {
                // empty catch block
            }
            account = (Account)this.accountDao.saveAndFlush((Object)account);
            User user = new User();
            ZeusUser.Model.Build.buildUserEntity(user, userModel);
            user.setTenantId(tenantId);
            user.setAccountId(account.getAccountId());
            user.setCreaterId(userModel.getCreateUserId());
            user.setCreaterName(userModel.getCreateUserId());
            try {
                user.setCreateTime(sdf.parse(userModel.getCreateTime()));
            }
            catch (ParseException parseException) {
                // empty catch block
            }
            user.setUpdaterId(userModel.getUpdateUserId());
            user.setUpdaterName(userModel.getUpdateUserId());
            try {
                user.setUpdateTime(sdf.parse(userModel.getUpdateTime()));
            }
            catch (ParseException parseException) {
                // empty catch block
            }
            this.userDao.saveAndFlush((Object)user);
        }
        if (accountMap.size() == 1) {
            account = (Account)((Map.Entry)accountMap.entrySet().stream().findFirst().get()).getValue();
            if (!account.getAccountId().equals(accountModel.getExternalId())) {
                String message = "zeus\u5bf9\u5e94\u7684accountId\uff1a{" + accountModel.getExternalId() + "}\u4e0e\u7528\u6237\u4e2d\u5fc3accountId\uff1a{" + account.getAccountId() + "}\u4e0d\u4e00\u81f4";
                throw new IllegalArgumentException(message);
            }
            if (sdf.format(account.getUpdateTime()).equals(accountModel.getUpdateTime())) {
                log.info("accout.updateTime\u4e00\u81f4\uff0c\u4e0d\u505a\u64cd\u4f5cid:{}", (Object)account.getAccountId());
                return;
            }
            account.setPassword(accountModel.getPassword());
            try {
                account.setUpdateTime(sdf.parse(accountModel.getUpdateTime()));
            }
            catch (ParseException message) {
                // empty catch block
            }
            account.setUpdaterId(accountModel.getUpdateUserId());
            account.setUpdaterName(accountModel.getUpdateUserId());
            this.accountDao.saveAndFlush((Object)account);
            Optional optionalUser = this.userDao.findById((Object)userModel.getExternalId());
            if (!optionalUser.isPresent()) {
                throw new IllegalArgumentException("\u4e0d\u5b58\u5728\u7684zeus.userId:" + userModel.getExternalId());
            }
            User user = (User)optionalUser.get();
            if (sdf.format(user.getUpdateTime()).equals(userModel.getUpdateTime())) {
                log.info("user.updateTime\u4e00\u81f4\uff0c\u4e0d\u505a\u64cd\u4f5cid:{}", (Object)user.getId());
                return;
            }
            ZeusUser.Model.Build.buildUserEntity(user, userModel);
            user.setTenantId(tenantId);
            user.setAccountId(account.getAccountId());
            try {
                user.setUpdateTime(sdf.parse(userModel.getUpdateTime()));
            }
            catch (ParseException parseException) {
                // empty catch block
            }
            user.setUpdaterId(userModel.getUserId());
            user.setUpdaterName(userModel.getUserName());
            this.userDao.saveAndFlush((Object)user);
        }
    }

    private void doTenant(String content) {
        ZeusTenant.Model.TenantModel tenantModel = (ZeusTenant.Model.TenantModel)JSONObject.parseObject((String)content, ZeusTenant.Model.TenantModel.class);
        Long externalId = tenantModel.getExternalId();
        if (null == externalId) {
            return;
        }
        Tenant tenant = this.tenantService.findById(externalId);
        if (sdf.format(tenant.getUpdateTime()).equals(tenantModel.getUpdateTime())) {
            log.info("tenant.updateTime\u4e00\u81f4\uff0c\u4e0d\u505a\u64cd\u4f5cid:{}", (Object)tenant.getTenantId());
            return;
        }
        tenant.setTenantCode(tenantModel.getTenantCode());
        tenant.setTenantName(tenantModel.getTenantName());
        tenant.setStatus(Integer.valueOf(Integer.parseInt(tenantModel.getStatus())));
        tenant.setUpdaterId(tenantModel.getUpdateUserId());
        tenant.setUpdaterName(tenantModel.getUpdateUserId());
        try {
            tenant.setUpdateTime(sdf.parse(tenantModel.getUpdateTime()));
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        this.tenantDao.saveAndFlush((Object)tenant);
    }

    private void doUserRelCompany(String content) {
        ZeusUserRelCompany.Model.ZeusUserRelCompanyModel relModel = (ZeusUserRelCompany.Model.ZeusUserRelCompanyModel)JSONObject.parseObject((String)content, ZeusUserRelCompany.Model.ZeusUserRelCompanyModel.class);
        Long userId = relModel.getUserId();
        if (null == userId) {
            return;
        }
        Optional optionalUser = this.userDao.findById((Object)userId);
        if (optionalUser.isPresent()) {
            throw new IllegalArgumentException("\u4e0d\u5b58\u5728\u7684\u7528\u6237id:" + userId);
        }
        if (CollectionUtils.isEmpty(relModel.getList())) {
            this.orgUserRelDao.deleteByUserId(userId.longValue());
            return;
        }
        User user = (User)optionalUser.get();
        HashSet<Long> orgIds = new HashSet<Long>();
        for (Long companyId : relModel.getList()) {
            Set set = this.orgService.findByTenantIdAndCompanyId(user.getTenantId(), companyId).stream().map(OrgStruct::getOrgId).collect(Collectors.toSet());
            if (CollectionUtils.isEmpty(set)) continue;
            orgIds.addAll(set);
        }
        if (!CollectionUtils.isEmpty(orgIds)) {
            this.userService.bindOrgs(user.getTenantId(), userId, orgIds, null, true, false, false);
        }
    }

    private class AsyncEventProcessListener {
        private AsyncEventProcessListener() {
        }

        @Subscribe
        public void process(ResponseMessage responseMessage) {
            try {
                boolean result = ZeusPayerSyncService.this.handleMessage(responseMessage);
                if (result) {
                    AckRequest ackRequest = new AckRequest(Collections.singletonList(responseMessage.getReceiptHandle()));
                    AckResponse ackResponse = ZeusPayerSyncService.this.client.ack(ackRequest);
                    if (!ackResponse.getSuccess().booleanValue()) {
                        log.error("ack message error:[{}]", (Object)responseMessage.getId());
                    }
                } else {
                    log.error("failed to handle message:{}", (Object)JSON.toJSONString((Object)responseMessage));
                }
            }
            catch (Exception e) {
                log.error("error while handling message with messageId:{}, exception: {}", (Object)responseMessage.getId(), (Object)e.getMessage());
            }
        }
    }
}

