/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.business.messagebus.impl;

import com.xforceplus.business.messagebus.UserPubService;
import com.xforceplus.business.messagebus.bus.MessageBusAsyncService;
import com.xforceplus.business.pub.service.PubSubAsyncService;
import com.xforceplus.entity.Account;
import com.xforceplus.entity.Tenant;
import com.xforceplus.entity.User;
import io.geewit.core.jackson.view.View;
import io.geewit.core.utils.reflection.BeanUtils;
import io.geewit.web.utils.JsonUtils;
import java.util.HashMap;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class UserPubServiceImpl
implements UserPubService {
    private static final Logger log = LoggerFactory.getLogger(UserPubServiceImpl.class);
    private final MessageBusAsyncService messageBusAsyncService;
    private final PubSubAsyncService pubSubAsyncService;
    @Value(value="${xforce.pub.accountUserTenant:account_user_tenant}")
    private String accountUserTenant;
    @Value(value="${pub.sub.uc.push.user-pubsub:tenant.user.change.status}")
    private String userStatusPubSubCode;
    @Value(value="${pub.sub.uc.push.user-status:false}")
    private boolean pushUserStatus;

    @Override
    public void pub(User user, Account account, Tenant tenant) {
        User copyUser = new User();
        Account copyAccount = new Account();
        try {
            BeanUtils.copyProperties((Object)user, (Object)copyUser, (String[])((String[])Stream.of("account", "tenant", "filteredOrgs", "hostCompanies").toArray(String[]::new)));
            BeanUtils.copyProperties((Object)account, (Object)copyAccount, (String[])((String[])Stream.of("salt", "password").toArray(String[]::new)));
        }
        catch (Exception e) {
            log.error("send_account_user_tenant_error", (Throwable)e);
        }
        HashMap<String, String> tagkvs = new HashMap<String, String>();
        tagkvs.put("requestName", this.accountUserTenant);
        tagkvs.put("businessNo", copyUser.getId() + "");
        tagkvs.put("tenantId", String.valueOf(tenant.getTenantId()));
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("account", copyAccount);
        map.put("user", copyUser);
        map.put("tenant", tenant);
        try {
            String content = JsonUtils.toJson(map);
            this.messageBusAsyncService.sendMessage(this.accountUserTenant, tagkvs, content);
        }
        catch (Exception e) {
            log.error("send_account_user_tenant_error", (Throwable)e);
        }
    }

    @Override
    public void sendUserToPubsub(User existEntity, Long tenantId) {
        if (!this.pushUserStatus) {
            return;
        }
        User user = new User();
        BeanUtils.copyProperties((Object)existEntity, (Object)user, (String[])((String[])Stream.of("roleUserRels", "orgUserRels", "orgVirtualNodeUserRels", "userApps").toArray(String[]::new)));
        HashMap<String, String> tagkvs = new HashMap<String, String>();
        tagkvs.put("tenantId", tenantId.toString());
        tagkvs.put("id", user.getId().toString());
        tagkvs.put("status", user.getStatus().toString());
        tagkvs.put("businessNo", user.getId().toString());
        user.setTicketOpeningTerminal("");
        user.setPrintingEquipment("");
        user.setBusinessExtensionAttribute("");
        String content = JsonUtils.toJson((Object)user, View.Info.class);
        this.pubSubAsyncService.sendMessage(this.userStatusPubSubCode, tagkvs, content);
        this.messageBusAsyncService.sendMessage(this.userStatusPubSubCode, tagkvs, content);
    }

    public UserPubServiceImpl(MessageBusAsyncService messageBusAsyncService, PubSubAsyncService pubSubAsyncService) {
        this.messageBusAsyncService = messageBusAsyncService;
        this.pubSubAsyncService = pubSubAsyncService;
    }
}

