/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.business.notice.dto;

import com.xforceplus.business.notice.dto.ExcelNoticeConfig;
import com.xforceplus.business.notice.dto.NoticeTemplate;
import com.xforceplus.business.notice.entity.ExcelProcessNotice;
import java.text.MessageFormat;
import java.util.Arrays;

public class NoticeMessage {
    private final String key;
    private final Long userId;
    private final Long tenantId;
    private final Long fileId;
    private final Object[] params;
    private final ExcelProcessNotice excelProcessNotice;

    public NoticeMessage(String key, Long userId, Long tenantId, Long fileId, Object[] params, ExcelProcessNotice excelProcessNotice) {
        this.key = key;
        this.userId = userId;
        this.tenantId = tenantId;
        this.fileId = fileId;
        this.params = params;
        this.excelProcessNotice = excelProcessNotice;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getKey() {
        return this.key;
    }

    public Long getUserId() {
        return this.userId;
    }

    public Long getTenantId() {
        return this.tenantId;
    }

    public Long getFileId() {
        return this.fileId;
    }

    public Object[] getParams() {
        return this.params;
    }

    public ExcelProcessNotice getExcelProcessNotice() {
        return this.excelProcessNotice;
    }

    public String toString() {
        return "NoticeMessage(key=" + this.getKey() + ", userId=" + this.getUserId() + ", tenantId=" + this.getTenantId() + ", fileId=" + this.getFileId() + ", params=" + Arrays.deepToString(this.getParams()) + ", excelProcessNotice=" + this.getExcelProcessNotice() + ")";
    }

    public static final class Builder {
        private String key;
        private Long userId;
        private Long tenantId;
        private Long fileId;
        private Object[] params;

        private Builder() {
        }

        public Builder key(String key) {
            this.key = key;
            return this;
        }

        public Builder userId(Long userId) {
            this.userId = userId;
            return this;
        }

        public Builder tenantId(Long tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        public Builder fileId(Long fileId) {
            this.fileId = fileId;
            return this;
        }

        public Builder params(Object[] params) {
            this.params = params;
            return this;
        }

        private String format(String message, Object[] params) {
            return MessageFormat.format(message, params);
        }

        public NoticeMessage build() {
            NoticeTemplate noticeTemplate = ExcelNoticeConfig.getTemplate(this.key);
            String content = this.format(noticeTemplate.getContent(), this.params);
            String title = this.format(noticeTemplate.getTitle(), this.params);
            ExcelProcessNotice excelProcessNotice = ExcelProcessNotice.builder().content(content).title(title).tenantId(this.tenantId).senderId(this.userId).build();
            return new NoticeMessage(this.key, this.userId, this.tenantId, this.fileId, this.params, excelProcessNotice);
        }
    }
}

