/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.business.org.virtual.controller;

import com.xforceplus.api.common.response.ResponseEntity;
import com.xforceplus.api.current.org.virtual.OrgVirtualApi;
import com.xforceplus.api.model.OrgVirtualModel;
import com.xforceplus.api.model.TreeModel;
import com.xforceplus.business.common.controller.AbstractController;
import com.xforceplus.business.excel.QueryParam;
import com.xforceplus.business.excel.writer.ExcelConfigBusinessType;
import com.xforceplus.business.file.controller.vo.ImportFileRespVo;
import com.xforceplus.business.file.service.ExportFileService;
import com.xforceplus.business.file.service.ImportFileService;
import com.xforceplus.business.org.virtual.service.OrgVirtualNodeService;
import com.xforceplus.business.org.virtual.service.OrgVirtualService;
import com.xforceplus.domain.orgVirtual.OrgVirtualDTO;
import com.xforceplus.entity.ExcelFileStore;
import com.xforceplus.entity.OrgVirtual;
import com.xforceplus.tenant.security.autoscan.annotation.AuthorizedDefinition;
import com.xforceplus.tenant.security.core.context.UserInfoHolder;
import com.xforceplus.tenant.security.core.domain.IAuthorizedUser;
import io.geewit.data.jpa.essential.domain.PageableFactory;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.validation.Valid;
import org.apache.commons.lang3.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;

@Api(value="\u865a\u62df\u7ec4\u7ec7")
@Controller
public class OrgVirtualController
extends AbstractController
implements OrgVirtualApi,
com.xforceplus.api.tenant.org.virtual.OrgVirtualApi {
    private static final Logger log = LoggerFactory.getLogger(OrgVirtualController.class);
    @Autowired
    private OrgVirtualService orgVirtualService;
    @Autowired
    private OrgVirtualNodeService orgVirtualNodeService;
    @Autowired
    private ExportFileService exportFileService;
    @Autowired
    private ImportFileService importFileService;
    @Value(value="${params.max-size.orgIds:100}")
    private int maxSizeOrgIds;

    @AuthorizedDefinition(resources={"xforce:ucenter:org-virtual:org:read"})
    public <O extends OrgVirtualDTO> ResponseEntity<Page<O>> currentPage(OrgVirtualModel.Request.Query query, Pageable pageable) {
        Pageable currentPageable = PageableFactory.ofDefaultSort((Pageable)pageable, (Sort)Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"createTime"}));
        query.setTenantId(UserInfoHolder.currentUser().getTenantId());
        Page<OrgVirtual> page = this.orgVirtualService.page(query, currentPageable);
        return ResponseEntity.ok(page);
    }

    @AuthorizedDefinition(resources={"xforce:ucenter:org-virtual:org:read"})
    public <O extends OrgVirtualDTO> ResponseEntity<O> currentCreate(OrgVirtualModel.Request.Create model) {
        if (null == model.getStatus()) {
            model.setStatus(Integer.valueOf(1));
        }
        model.setTenantId(UserInfoHolder.currentUser().getTenantId());
        OrgVirtual result = this.orgVirtualService.create(model);
        return ResponseEntity.ok((Object)result);
    }

    @AuthorizedDefinition(resources={"xforce:ucenter:org-virtual:org:save"})
    public <O extends OrgVirtualDTO> ResponseEntity<O> currentUpdate(Long orgVirtualId, OrgVirtualModel.Request.Update model) {
        model.setTenantId(UserInfoHolder.currentUser().getTenantId());
        model.setOrgVirtualId(orgVirtualId);
        OrgVirtual result = this.orgVirtualService.update(model);
        return ResponseEntity.ok((Object)result);
    }

    @AuthorizedDefinition(resources={"xforce:ucenter:org-virtual:org:read"})
    public ResponseEntity<OrgVirtualDTO> currentInfo(Long orgVirtualId) {
        Long tenantId = UserInfoHolder.currentUser().getTenantId();
        OrgVirtualDTO dto = this.orgVirtualService.currentInfo(tenantId, orgVirtualId);
        return ResponseEntity.ok((Object)dto);
    }

    @AuthorizedDefinition(resources={"xforce:ucenter:org-virtual:org:save"})
    public ResponseEntity<String> currentEnable(Long orgVirtualId) {
        Long tenantId = UserInfoHolder.currentUser().getTenantId();
        this.orgVirtualService.currentEnable(tenantId, orgVirtualId);
        return ResponseEntity.ok();
    }

    @AuthorizedDefinition(resources={"xforce:ucenter:org-virtual:org:save"})
    public ResponseEntity<String> currentDisable(Long orgVirtualId) {
        Long tenantId = UserInfoHolder.currentUser().getTenantId();
        this.orgVirtualService.currentDisable(tenantId, orgVirtualId);
        return ResponseEntity.ok();
    }

    public ResponseEntity<List<OrgVirtualModel.Response.Model>> listByUserId(String tenantKey, Long typeId, Long userId, @ApiParam(value="byTenantCode") Boolean byTenantCode) {
        long tenantId = super.toTenantId(tenantKey, byTenantCode);
        List<OrgVirtualModel.Response.Model> list = this.orgVirtualNodeService.listByUserId(typeId, userId, tenantId);
        return ResponseEntity.ok(list);
    }

    public ResponseEntity<List<OrgVirtualModel.Response.Model>> listByNodeId(String tenantKey, Long nodeId, @ApiParam(value="byTenantCode") Boolean byTenantCode, TreeModel.Scope scope) {
        long tenantId = super.toTenantId(tenantKey, byTenantCode);
        if (null == scope) {
            scope = TreeModel.Scope.CHILDREN;
        }
        List<OrgVirtualModel.Response.Model> list = this.orgVirtualNodeService.listByNodeId(nodeId, tenantId, scope);
        return ResponseEntity.ok(list);
    }

    public ResponseEntity<OrgVirtualModel.Response.Model> treeByNodeId(String tenantKey, Long nodeId, @ApiParam(value="byTenantCode") Boolean byTenantCode, TreeModel.Scope scope) {
        long tenantId = super.toTenantId(tenantKey, byTenantCode);
        if (null == scope) {
            scope = TreeModel.Scope.CHILDREN;
        }
        OrgVirtualModel.Response.Model model = this.orgVirtualNodeService.treeByNodeId(nodeId, tenantId, scope);
        return ResponseEntity.ok((Object)model);
    }

    public ResponseEntity<List<OrgVirtualModel.Response.Model>> listByKeys(String tenantKey, @ApiParam(value="byTenantCode") Boolean byTenantCode, TreeModel.Scope scope, Integer nodeTypeId, boolean byId, String orgVirtualKeys) {
        String[] keys = orgVirtualKeys.split(",");
        if (keys.length > this.maxSizeOrgIds) {
            throw new IllegalArgumentException("orgIds\u6761\u6570\u9650\u5236\u4e3a" + this.maxSizeOrgIds);
        }
        Set<String> keySet = Arrays.stream(keys).collect(Collectors.toSet());
        long tenantId = super.toTenantId(tenantKey, byTenantCode);
        List<OrgVirtualModel.Response.Model> list = this.orgVirtualNodeService.listByKeys(tenantId, scope, nodeTypeId, byId, keySet);
        return ResponseEntity.ok(list);
    }

    public <O extends OrgVirtualDTO> ResponseEntity<O> tenantCreate(String tenantKey, @ApiParam(value="byTenantCode") Boolean byTenantCode, // Could not load outer class - annotation placement on inner may be incorrect
     @Valid OrgVirtualModel.Request.Create model) {
        long tenantId = super.toTenantId(tenantKey, byTenantCode);
        if (null == model.getStatus()) {
            model.setStatus(Integer.valueOf(1));
        }
        model.setTenantId(Long.valueOf(tenantId));
        OrgVirtual result = this.orgVirtualService.create(model);
        return ResponseEntity.ok((Object)result);
    }

    public <O extends OrgVirtualDTO> ResponseEntity<Page<O>> tenantPage(String tenantKey, Boolean byTenantCode, OrgVirtualModel.Request.Query query, Pageable pageable) {
        long tenantId = super.toTenantId(tenantKey, byTenantCode);
        Pageable currentPageable = PageableFactory.ofDefaultSort((Pageable)pageable, (Sort)Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"createTime"}));
        query.setTenantId(Long.valueOf(tenantId));
        Page<OrgVirtual> page = this.orgVirtualService.page(query, currentPageable);
        return ResponseEntity.ok(page);
    }

    public <O extends OrgVirtualDTO> ResponseEntity<O> tenantUpdate(String tenantKey, Boolean byTenantCode, Long orgVirtualId, // Could not load outer class - annotation placement on inner may be incorrect
     @Valid OrgVirtualModel.Request.Update model) {
        long tenantId = super.toTenantId(tenantKey, byTenantCode);
        model.setTenantId(Long.valueOf(tenantId));
        model.setOrgVirtualId(orgVirtualId);
        OrgVirtual result = this.orgVirtualService.update(model);
        return ResponseEntity.ok((Object)result);
    }

    @ResponseBody
    @AuthorizedDefinition(resources={"xforce:ucenter:org-virtual:org:save"})
    @ApiOperation(value="\u4e1a\u52a1\u7ec4\u7ec7\u5f02\u6b65\u5bfc\u51fa", notes="\u4e1a\u52a1\u7ec4\u7ec7\u5f02\u6b65\u5bfc\u51fa")
    @RequestMapping(name="\u4e1a\u52a1\u7ec4\u7ec7\u5f02\u6b65\u5bfc\u51fa", value={"${xforce.tenant.service.url.prefix:/api}/current${xforce.tenant.service.version:}/org-virtuals/export"}, method={RequestMethod.POST})
    public ResponseEntity<ImportFileRespVo> exportCompanyConfig(@ApiParam(value="request") @RequestBody OrgVirtualModel.Request.ExcelExportQuery query) {
        if (ArrayUtils.isEmpty((Object[])query.getSheets())) {
            throw new IllegalArgumentException("\u8bf7\u9009\u62e9SheetName");
        }
        QueryParam queryParam = QueryParam.builder().param("P_QUERY", query).build();
        ExcelFileStore excelFileStore = this.exportFileService.asyncExcelExport(queryParam.params(), ExcelConfigBusinessType.ORG_VIRTUAL_CONFIG_EXCEL_FILE);
        ImportFileRespVo respVo = new ImportFileRespVo();
        respVo.setId(excelFileStore.getId());
        respVo.setBusinessType(ExcelConfigBusinessType.ORG_VIRTUAL_CONFIG_EXCEL_FILE.getBusinessName());
        return ResponseEntity.ok((Object)respVo);
    }

    @AuthorizedDefinition(resources={"xforce:ucenter:org-virtual:org:save"})
    @ApiOperation(value="\u4e1a\u52a1\u7ec4\u7ec7\u5bfc\u5165excel")
    @ResponseBody
    @RequestMapping(name="\u4e1a\u52a1\u7ec4\u7ec7\u5bfc\u5165excel", value={"${xforce.tenant.service.url.prefix:/api}/current${xforce.tenant.service.version:}/org-virtuals/import"}, produces={"application/json"}, method={RequestMethod.POST})
    public ResponseEntity<ImportFileRespVo> batchImportBind(@RequestParam(value="file") MultipartFile file) {
        IAuthorizedUser currentUser = UserInfoHolder.currentUser();
        Long tenantId = currentUser.getTenantId();
        Long userId = currentUser.getId();
        String businessType = ExcelConfigBusinessType.ORG_VIRTUAL_IMPORT.name();
        ExcelFileStore excelFileStore = this.importFileService.createAndSaveFile(file, businessType, userId, tenantId);
        ImportFileRespVo respVo = new ImportFileRespVo();
        respVo.setBusinessType(businessType);
        respVo.setFileId(excelFileStore.getSourceFileId());
        respVo.setId(excelFileStore.getId());
        return ResponseEntity.ok((Object)respVo);
    }
}

