/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.business.org.virtual.service;

import com.google.common.eventbus.AsyncEventBus;
import com.google.common.eventbus.Subscribe;
import com.xforceplus.business.org.virtual.service.OrgVirtualNodeUserService;
import java.util.concurrent.Executor;
import java.util.concurrent.ThreadPoolExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AsyncOrgVirtualNodeUserService
implements InitializingBean,
DisposableBean {
    private static final Logger logger = LoggerFactory.getLogger(AsyncOrgVirtualNodeUserService.class);
    private static final long SLEEP_MILLS = 1000L;
    private AsyncEventBus asyncEventBus;
    @Autowired
    private ThreadPoolExecutor threadPoolExecutor;
    @Autowired
    private OrgVirtualNodeUserService orgVirtualNodeUserService;

    public void afterPropertiesSet() {
        this.asyncEventBus = new AsyncEventBus((Executor)this.threadPoolExecutor, (exception, context) -> logger.error(exception.getMessage(), exception));
        this.asyncEventBus.register((Object)new AsyncProcessListener());
    }

    public void autoBindParentUsers(Long tenantId, Long nodeId) {
        logger.info("tenantId:{}, nodeId: {}", (Object)tenantId, (Object)nodeId);
        if (tenantId == null || tenantId == 0L || nodeId == null || nodeId == 0L) {
            logger.info("tenantId == 0 || nodeId == 0, return");
            return;
        }
        Context context = Context.builder().tenantId(tenantId).nodeId(nodeId).build();
        try {
            this.asyncEventBus.post((Object)context);
        }
        catch (Exception e) {
            logger.error("asyncExcelProcess:" + e.getMessage(), (Throwable)e);
            throw new IllegalArgumentException("\u5bfc\u5165\u6570\u636e\u5931\u8d25\uff0c\u5f53\u524d\u670d\u52a1\u5668\u7e41\u5fd9\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5");
        }
    }

    public void destroy() {
    }

    protected class AsyncProcessListener {
        protected AsyncProcessListener() {
        }

        @Subscribe
        public void doProcess(Context context) {
            logger.info("AsyncProcessListener.doProcess, context.tenantId = {}, context.nodeId = {}", (Object)context.tenantId, (Object)context.nodeId);
            if (context.nodeId > 0L) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    logger.warn(e.getMessage());
                    Thread.currentThread().interrupt();
                }
                finally {
                    try {
                        AsyncOrgVirtualNodeUserService.this.orgVirtualNodeUserService.autoBindUsers(context.tenantId, context.nodeId);
                    }
                    catch (Exception e) {
                        logger.warn(e.getMessage());
                    }
                }
            }
        }
    }

    static class Context {
        long tenantId;
        long nodeId;

        Context(long tenantId, long nodeId) {
            this.tenantId = tenantId;
            this.nodeId = nodeId;
        }

        public static ContextBuilder builder() {
            return new ContextBuilder();
        }

        public static class ContextBuilder {
            private long tenantId;
            private long nodeId;

            ContextBuilder() {
            }

            public ContextBuilder tenantId(long tenantId) {
                this.tenantId = tenantId;
                return this;
            }

            public ContextBuilder nodeId(long nodeId) {
                this.nodeId = nodeId;
                return this;
            }

            public Context build() {
                return new Context(this.tenantId, this.nodeId);
            }

            public String toString() {
                return "AsyncOrgVirtualNodeUserService.Context.ContextBuilder(tenantId=" + this.tenantId + ", nodeId=" + this.nodeId + ")";
            }
        }
    }
}

