/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.business.org.virtual.service;

import com.xforceplus.api.model.OrgVirtualNodeModel;
import com.xforceplus.business.excel.BusinessType;
import com.xforceplus.business.excel.SimpleExcelWriter;
import com.xforceplus.business.excel.reader.Context;
import com.xforceplus.business.excel.writer.ExcelConfigBusinessType;
import com.xforceplus.business.org.virtual.service.OrgVirtualNodeService;
import com.xforceplus.business.service.ExcelWriteService;
import java.util.List;
import org.springframework.stereotype.Service;

@Service
public class OrgVirtualNodeExportServiceImpl
implements ExcelWriteService {
    private final OrgVirtualNodeService orgVirtualNodeService;

    public OrgVirtualNodeExportServiceImpl(OrgVirtualNodeService orgVirtualNodeService) {
        this.orgVirtualNodeService = orgVirtualNodeService;
    }

    @Override
    public BusinessType getBusinessType() {
        return ExcelConfigBusinessType.ORG_VIRTUAL_NODE_CONFIG_EXCEL_FILE;
    }

    @Override
    public void write(Context context) {
        OrgVirtualNodeModel.Request.ExcelExportQuery query = context.getParam("P_QUERY", OrgVirtualNodeModel.Request.ExcelExportQuery.class);
        Long tenantId = context.getFileDTO().getTenantId();
        SimpleExcelWriter simpleExcelWriter = context.getSimpleExcelWriter();
        query.setTenantId(tenantId);
        String[] stringArray = query.getSheets();
        int n = stringArray.length;
        block8: for (int i = 0; i < n; ++i) {
            String sheetName;
            switch (sheetName = stringArray[i]) {
                case "\u4e1a\u52a1\u7ec4\u7ec7\u6811": {
                    List<OrgVirtualNodeModel.Response.ExcelExportModel> orgModes = this.orgVirtualNodeService.listNodeToExcel(query);
                    simpleExcelWriter.fill(sheetName, orgModes);
                    continue block8;
                }
                case "\u5173\u8054\u4eba\u5458": {
                    List<OrgVirtualNodeModel.Response.ExcelExportModel> list = this.orgVirtualNodeService.listNodeRelAccountToExcel(query);
                    simpleExcelWriter.fill(sheetName, list);
                    continue block8;
                }
            }
        }
    }
}

