/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.business.org.virtual.service;

import com.google.common.collect.Lists;
import com.xforceplus.api.model.OrgVirtualNodeModel;
import com.xforceplus.business.excel.ExcelValidator;
import com.xforceplus.business.org.virtual.dto.OrgVirtualNodeRelUserImportDto;
import com.xforceplus.business.org.virtual.service.OrgVirtualNodeService;
import com.xforceplus.business.tenant.service.TenantService;
import com.xforceplus.business.tenant.service.UserService;
import com.xforceplus.dao.OrgVirtualNodeDao;
import com.xforceplus.dao.OrgVirtualUserRelDao;
import com.xforceplus.dao.user.OrgUserExtendDao;
import com.xforceplus.entity.OrgVirtualNode;
import com.xforceplus.entity.OrgVirtualNodeUserRel;
import com.xforceplus.entity.Tenant;
import com.xforceplus.entity.User;
import com.xforceplus.utils.OrgVirtualNodeUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class OrgVirtualNodeUserService {
    private static final Logger logger = LoggerFactory.getLogger(OrgVirtualNodeUserService.class);
    private final OrgVirtualUserRelDao orgVirtualUserRelDao;
    private final OrgVirtualNodeDao orgVirtualNodeDao;
    @Resource
    private OrgVirtualNodeService orgVirtualNodeService;
    @Resource
    private UserService userService;
    @Resource
    private TenantService tenantService;

    public OrgVirtualNodeUserService(OrgVirtualUserRelDao orgVirtualUserRelDao, OrgVirtualNodeDao orgVirtualNodeDao, OrgUserExtendDao orgUserExtendDao) {
        this.orgVirtualUserRelDao = orgVirtualUserRelDao;
        this.orgVirtualNodeDao = orgVirtualNodeDao;
    }

    @Transactional(rollbackFor={Exception.class})
    public void autoBindUsers(Long tenantId, Long nodeId) {
        Optional optionalOrgVirtualNode = this.orgVirtualNodeDao.findById((Object)nodeId);
        if (!optionalOrgVirtualNode.isPresent()) {
            logger.warn("\u4f20\u7684nodeId({})\u4e0d\u5b58\u5728", (Object)nodeId);
            return;
        }
        OrgVirtualNode currentNode = (OrgVirtualNode)optionalOrgVirtualNode.get();
        if (StringUtils.isBlank((CharSequence)currentNode.getParentIds())) {
            logger.warn("\u4f20\u7684nodeId({})\u4e0d\u5b58\u5728\u6216\u5bf9\u5e94\u7684parentIds\u4e3a\u7a7a", (Object)nodeId);
            return;
        }
        String parentIds = currentNode.getParentIds();
        Set<Long> parentnodeIds = OrgVirtualNodeUtils.findNodeIdInParentIds(parentIds);
        if (CollectionUtils.isEmpty(parentnodeIds = parentnodeIds.stream().filter(parentId -> !parentId.equals(nodeId)).collect(Collectors.toSet()))) {
            logger.warn("\u4f20\u7684nodeId({})\u4e0d\u5b58\u5728\u6216\u5bf9\u5e94\u7684parentIds\u4e3a\u7a7a", (Object)nodeId);
            return;
        }
        Set boundUserOrgVirtualNodeRels = this.orgVirtualUserRelDao.findByOrgVirtualNodeIdIn(parentnodeIds);
        if (CollectionUtils.isEmpty((Collection)boundUserOrgVirtualNodeRels)) {
            logger.warn("\u5728\u7236\u865a\u62df\u865a\u62df\u7ec4\u7ec7\u6811\u4e2d\u6ca1\u6709\u627e\u5230\u5df2\u7ed1\u5b9a\u7684\u7528\u6237");
            return;
        }
        Set shouldBoundUserIds = boundUserOrgVirtualNodeRels.stream().filter(r -> r.getControlFlag() == 1).map(OrgVirtualNodeUserRel::getUserId).collect(Collectors.toSet());
        if (CollectionUtils.isEmpty(shouldBoundUserIds)) {
            logger.warn("\u5728\u7236\u865a\u62df\u865a\u62df\u7ec4\u7ec7\u6811\u4e2d\u6ca1\u6709\u627e\u5230\u5df2\u7ed1\u5b9a\u7684\u7528\u6237");
            return;
        }
        shouldBoundUserIds.stream().filter(shouldBoundUserId -> boundUserOrgVirtualNodeRels.stream().noneMatch(rel -> rel.getOrgVirtualNodeId().equals(nodeId) && rel.getUserId().equals(shouldBoundUserId))).filter(Objects::nonNull).forEach(shouldBoundUserId -> {
            OrgVirtualNodeUserRel rel = new OrgVirtualNodeUserRel();
            rel.setOrgVirtualNodeId(nodeId);
            rel.setTenantId(tenantId);
            rel.setUserId(shouldBoundUserId);
            rel.setControlFlag(Integer.valueOf(0));
            this.orgVirtualUserRelDao.saveAndFlush((Object)rel);
        });
    }

    @Transactional(rollbackFor={Exception.class})
    public String importSave(OrgVirtualNodeRelUserImportDto dto, Long tenantId, Long typeId) {
        Optional optionalNodeId;
        ArrayList<String> errMsg = new ArrayList<String>();
        ExcelValidator.validate(dto);
        if (StringUtils.isNotBlank((CharSequence)dto.getValidatedMessage())) {
            errMsg.add(dto.getValidatedMessage());
        }
        if (!(optionalNodeId = this.orgVirtualNodeDao.findByNodeTypeIdAndOrgCodeAndTenantId(tenantId, typeId, dto.getOrgCode())).isPresent()) {
            errMsg.add("\u4e0d\u5b58\u5728\u7684\u4e1a\u52a1\u7ec4\u7ec7[" + dto.getOrgCode() + "]");
        }
        Tenant tenant = this.tenantService.findById(tenantId);
        String username = dto.getUsername();
        String tenantUsername = this.userService.getDomainAccountName(username, tenant.getTenantCode());
        Optional<User> userOptional = this.userService.findByTenantIdAndUsername(tenantId, tenantUsername);
        if (!userOptional.isPresent() && !(userOptional = this.userService.findByTenantIdAndUsername(tenantId, username)).isPresent()) {
            errMsg.add("\u4e0d\u5b58\u5728\u7684\u8d26\u53f7[" + dto.getUsername() + "]");
        }
        if (!CollectionUtils.isEmpty(errMsg)) {
            return String.join((CharSequence)";", errMsg);
        }
        if (userOptional.isPresent()) {
            User user = userOptional.get();
            if ("\u7ed1\u5b9a".equals(dto.getAction())) {
                OrgVirtualNodeModel.Request.BindUsers bindUsers = new OrgVirtualNodeModel.Request.BindUsers();
                bindUsers.setUserIds((List)Lists.newArrayList((Object[])new Long[]{user.getId()}));
                optionalNodeId.ifPresent(nodeId -> this.orgVirtualNodeService.bindUsers(tenantId, (Long)nodeId, bindUsers));
                if ("\u5f53\u524d\u7ec4\u7ec7\u53ca\u4e0b\u7ea7\u7ec4\u7ec7".equals(dto.getControlFlag())) {
                    OrgVirtualNodeModel.Request.UsersScope usersScope = new OrgVirtualNodeModel.Request.UsersScope();
                    usersScope.setControlFlag(1);
                    usersScope.setUserIds((List)Lists.newArrayList((Object[])new Long[]{user.getId()}));
                    optionalNodeId.ifPresent(nodeId -> this.orgVirtualNodeService.updateControlScope(tenantId, (Long)nodeId, usersScope));
                }
                if ("1".equals(dto.getAdminFlag())) {
                    OrgVirtualNodeModel.Request.BindAdminInfo bindAdminInfo = new OrgVirtualNodeModel.Request.BindAdminInfo();
                    OrgVirtualNodeModel.Request.AdminInfo adminInfo = new OrgVirtualNodeModel.Request.AdminInfo();
                    adminInfo.setUserId(user.getId());
                    adminInfo.setSort(Integer.valueOf(1));
                    bindAdminInfo.setAdmins((List)Lists.newArrayList((Object[])new OrgVirtualNodeModel.Request.AdminInfo[]{adminInfo}));
                    optionalNodeId.ifPresent(nodeId -> this.orgVirtualNodeService.bindAdminInfo(tenantId, (Long)nodeId, bindAdminInfo));
                }
            } else if ("\u89e3\u7ed1".equals(dto.getAction())) {
                OrgVirtualNodeModel.Request.UnbindUsers unbindUsers = new OrgVirtualNodeModel.Request.UnbindUsers();
                unbindUsers.setUserIds((List)Lists.newArrayList((Object[])new Long[]{user.getId()}));
                optionalNodeId.ifPresent(nodeId -> this.orgVirtualNodeService.unbindUsers(tenantId, (Long)nodeId, unbindUsers));
            }
        }
        return null;
    }
}

