/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.business.org.virtual.service;

import com.alibaba.excel.event.AnalysisEventListener;
import com.alibaba.fastjson.JSON;
import com.xforceplus.business.excel.BusinessType;
import com.xforceplus.business.excel.ExcelSheet;
import com.xforceplus.business.excel.reader.Context;
import com.xforceplus.business.excel.reader.MessageRow;
import com.xforceplus.business.excel.reader.SimpleDataReadListener;
import com.xforceplus.business.excel.writer.ExcelConfigBusinessType;
import com.xforceplus.business.org.virtual.dto.OrgVirtualImportDto;
import com.xforceplus.business.org.virtual.dto.OrgVirtualOrgStructImportDto;
import com.xforceplus.business.org.virtual.service.OrgVirtualOrgStructService;
import com.xforceplus.business.service.ExcelReaderService;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class OrgVirtualOrgStructImportService
implements ExcelReaderService {
    public static final String ACTION_CREATE = "\u65b0\u589e";
    public static final String ACTION_DELETE = "\u5220\u9664";
    public static final List<String> ACTION_LISTS = Arrays.asList("\u65b0\u589e", "\u5220\u9664");
    private static final Logger logger = LoggerFactory.getLogger(OrgVirtualOrgStructImportService.class);
    @Resource
    private OrgVirtualOrgStructService orgVirtualOrgStructService;

    @Override
    public BusinessType getBusinessType() {
        return ExcelConfigBusinessType.ORG_VIRTUAL_ORG_STRUCT_CONFIG_EXCEL_FILE;
    }

    @Override
    public Context importExcel(Context context) {
        List<ExcelSheet> sheets = context.getExcelBook().getExcelSheets();
        for (ExcelSheet sheet : sheets) {
            MessageRow messageRows = new MessageRow(sheet.getSheetName());
            AnalysisEventListener excelDataListener = SimpleDataReadListener.listener(context, rows -> this.saveData(messageRows, context, (List<OrgVirtualOrgStructImportDto>)rows));
            context.getSimpleExcelReader().read(OrgVirtualImportDto.class, excelDataListener);
        }
        return context;
    }

    public void saveData(MessageRow messageRows, Context context, List<OrgVirtualOrgStructImportDto> list) {
        if (logger.isDebugEnabled()) {
            logger.debug("list:{}", (Object)JSON.toJSONString(list));
        }
        for (OrgVirtualOrgStructImportDto dto : list) {
            if (logger.isDebugEnabled()) {
                logger.debug("dto:{}", (Object)JSON.toJSONString((Object)dto));
            }
            String msg = this.orgVirtualOrgStructService.importSave(dto, context.getFileDTO().getTenantId());
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{msg})) {
                messageRows.fail(dto.getRowIndex(), msg);
                continue;
            }
            messageRows.success(dto.getRowIndex());
        }
        context.messageRow(messageRows.getSheetName(), messageRows);
    }
}

