/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.business.pub.dto;

import java.util.HashMap;
import java.util.Map;

public class PubContext {
    private String content;
    private String code;
    private Map<String, String> param;

    private PubContext() {
    }

    public static Builder builder() {
        return new Builder();
    }

    public void setContent(String content) {
        this.content = content;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public void setParam(Map<String, String> param) {
        this.param = param;
    }

    public String getContent() {
        return this.content;
    }

    public String getCode() {
        return this.code;
    }

    public Map<String, String> getParam() {
        return this.param;
    }

    public String toString() {
        return "PubContext(content=" + this.getContent() + ", code=" + this.getCode() + ", param=" + this.getParam() + ")";
    }

    public static final class Builder {
        private String content;
        private String code;
        private Map<String, String> param = new HashMap<String, String>(3);

        private Builder() {
        }

        public Builder content(String content) {
            this.content = content;
            return this;
        }

        public Builder code(String code) {
            this.code = code;
            return this;
        }

        public Builder param(Map<String, String> param) {
            this.param.putAll(param);
            return this;
        }

        public Builder param(String key, String value) {
            this.param.put(key, value);
            return this;
        }

        public PubContext build() {
            PubContext messageContext = new PubContext();
            messageContext.setContent(this.content);
            messageContext.setCode(this.code);
            messageContext.setParam(this.param);
            return messageContext;
        }
    }
}

