/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.business.pub.service;

import com.google.common.eventbus.AsyncEventBus;
import com.google.common.eventbus.Subscribe;
import com.google.common.eventbus.SubscriberExceptionHandler;
import com.xforceplus.business.pub.dto.PubContext;
import com.xforceplus.business.pub.service.PubsubService;
import com.xforceplus.business.pub.service.SubscriberExceptionHandlerImpl;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.ThreadPoolExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

@Service
public class PubSubAsyncService
implements InitializingBean,
DisposableBean {
    private static final Logger log = LoggerFactory.getLogger(PubSubAsyncService.class);
    public static final String ASYNC_PUS_SUB_EVENT_BUS = "ASYNC_PUS_SUB_EVENT_BUS";
    @Autowired(required=false)
    private PubsubService pubsubService;
    private AsyncEventBus asyncEventBus;
    @Autowired
    private ThreadPoolExecutor threadPoolExecutor;

    public void destroy() throws Exception {
    }

    public void afterPropertiesSet() throws Exception {
        SubscriberExceptionHandlerImpl subscriberExceptionHandler = new SubscriberExceptionHandlerImpl();
        this.asyncEventBus = new AsyncEventBus((Executor)this.threadPoolExecutor, (SubscriberExceptionHandler)subscriberExceptionHandler);
        this.asyncEventBus.register((Object)new AsyncPubSubProcessListener());
    }

    @Async(value="threadPoolExecutor")
    public void send(PubContext pubContext) {
        if (this.pubsubService == null) {
            log.warn("PubSubAsyncService.pubsub.enable:{}", (Object)false);
        }
        this.asyncEventBus.post((Object)pubContext);
    }

    public void sendMessage(String code, Map<String, String> tagkvs, String content) {
        PubContext pubContext = PubContext.builder().code(code).param(tagkvs).content(content).build();
        try {
            this.send(pubContext);
        }
        catch (Exception e) {
            log.error("xforce.pub.bus.error,requestName={}", (Object)code, (Object)e);
        }
    }

    protected class AsyncPubSubProcessListener {
        protected AsyncPubSubProcessListener() {
        }

        @Subscribe
        public void doProcess(PubContext context) {
            try {
                String messageId = PubSubAsyncService.this.pubsubService.sendMessage(context.getCode(), context.getContent(), context.getParam());
                log.info("pubsub code:{},messageId:{}", (Object)context.getCode(), (Object)messageId);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

