/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.business.pub.service;

import com.xforceplus.config.PubsubConfig;
import com.xforceplus.janus.pubsub.sdk.IMessageListener;
import com.xforceplus.janus.pubsub.sdk.MCFactory;
import com.xforceplus.janus.pubsub.sdk.msg.SealedMessage;
import com.xforceplus.janus.pubsub.sdk.utils.SealedMessageBuilder;
import io.geewit.web.utils.JsonUtils;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Service;

@ConditionalOnProperty(prefix="pubsub", name={"enable"}, havingValue="true")
@Service
public class PubsubService {
    private static Logger logger = LoggerFactory.getLogger(PubsubService.class);
    private MCFactory pubsubFactory;
    @Autowired
    private PubsubConfig pubsubConfig;

    @PostConstruct
    public void init() {
        try {
            this.pubsubFactory = MCFactory.getInstance((String)this.pubsubConfig.getUsername(), (String)this.pubsubConfig.getPassword(), (String)this.pubsubConfig.getHost(), (int)this.pubsubConfig.getPort());
        }
        catch (Exception e) {
            logger.warn(e.getMessage(), (Throwable)e);
        }
    }

    public void register(String requestName, IMessageListener listener, String ... tags) {
        this.pubsubFactory.registerListener(requestName, listener, 1, tags);
    }

    public void acknowlege(SealedMessage sealedMessage) {
        this.pubsubFactory.acknowlege(sealedMessage);
    }

    public String sendMessage(String requestName, String message, Map<String, String> tagkvs) {
        logger.info("sendMessage requestName ={} ", (Object)requestName);
        logger.info("sendMessage message ={}", (Object)message);
        logger.debug("sendMessage description ={}", (Object)JsonUtils.toJson(tagkvs));
        try {
            SealedMessage sealedMessage = SealedMessageBuilder.buildSendMsg((String)requestName, (Object)message, tagkvs);
            return this.pubsubFactory.sendMessage(sealedMessage);
        }
        catch (Exception e) {
            String error = "sendMessage pub error = " + e.getMessage();
            logger.warn(error, (Throwable)e);
            return null;
        }
    }
}

