/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.business.resource.controller;

import com.xforceplus.api.common.response.ResponseEntity;
import com.xforceplus.api.model.ResourceModel;
import com.xforceplus.api.tenant.resource.ResourceApi;
import com.xforceplus.bo.ResourceQueryBo;
import com.xforceplus.business.excel.QueryParam;
import com.xforceplus.business.excel.writer.ExcelConfigBusinessType;
import com.xforceplus.business.file.controller.vo.ImportFileRespVo;
import com.xforceplus.business.file.service.ExportFileService;
import com.xforceplus.business.file.service.ImportFileService;
import com.xforceplus.business.resource.service.ResourcePortService;
import com.xforceplus.business.resource.service.ResourceService;
import com.xforceplus.domain.resource.ResourceDto;
import com.xforceplus.domain.resource.ResourceExtendDto;
import com.xforceplus.domain.resource.ServiceApiExtendDto;
import com.xforceplus.dto.resource.ResourceDTO;
import com.xforceplus.entity.ExcelFileStore;
import com.xforceplus.entity.Resource;
import com.xforceplus.tenant.security.autoscan.annotation.AuthorizedDefinition;
import com.xforceplus.tenant.security.core.context.UserInfoHolder;
import com.xforceplus.utils.BasePathUtils;
import com.xforceplus.utils.DownloadUtils;
import com.xforceplus.utils.FileUtils;
import com.xforceplus.utils.excel.ResourceExcelUtils;
import com.xforceplus.utils.excel.ResourceWrapper;
import com.xforceplus.utils.filetransfer.FileTransferUtilsService;
import com.xforceplus.utils.yaml.ResourceYamlUtils;
import io.geewit.core.utils.reflection.BeanUtils;
import io.geewit.data.jpa.essential.domain.PageableFactory;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Controller;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import springfox.documentation.annotations.ApiIgnore;

@Api(value="\u8d44\u6e90\u7801\u76f8\u5173\u63a5\u53e3", tags={"resources", "resource"})
@Validated
@Controller
public class ResourceController
implements com.xforceplus.api.global.resource.ResourceApi,
ResourceApi {
    private static final Logger logger = LoggerFactory.getLogger(ResourceController.class);
    private final FileTransferUtilsService fileTransferUtilsService;
    private final ResourceService resourceService;
    private final ResourcePortService resourcePortService;
    private final ExportFileService exportFileService;
    private final ImportFileService importFileService;

    public ResourceController(ResourceService resourceService, ResourcePortService resourcePortService, FileTransferUtilsService fileTransferUtilsService, ExportFileService exportFileService, ImportFileService importFileService) {
        this.resourceService = resourceService;
        this.resourcePortService = resourcePortService;
        this.fileTransferUtilsService = fileTransferUtilsService;
        this.exportFileService = exportFileService;
        this.importFileService = importFileService;
    }

    @AuthorizedDefinition(resources={"xforce:operation:resource:read"})
    @ApiOperation(value="\u5f02\u6b65\u5bfc\u51fa\u8d44\u6e90\u7801\u5217\u8868", notes="\u5f02\u6b65\u5bfc\u51fa\u8d44\u6e90\u7801\u5217\u8868")
    @RequestMapping(name="\u5f02\u6b65\u5bfc\u51fa\u8d44\u6e90\u7801\u5217\u8868", value={"${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/resources/async/export"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<ImportFileRespVo> asyncExport(@ApiParam(value="request") @RequestBody ResourceModel.Request.Query query, @ApiParam(value="sort") Sort sort) {
        if (ArrayUtils.isEmpty((Object[])query.getSheets())) {
            throw new IllegalArgumentException("\u8bf7\u9009\u62e9SheetName");
        }
        if (UserInfoHolder.get() == null) {
            throw new IllegalArgumentException("\u8bf7\u767b\u5f55");
        }
        QueryParam queryParam = QueryParam.builder().param("P_QUERY", query).param("P_SORT", sort).build();
        ResourceQueryBo queryBo = new ResourceQueryBo();
        BeanUtils.copyProperties((Object)query, (Object)queryBo);
        ExcelFileStore excelFileStore = this.exportFileService.asyncExcelExport(queryParam.params(), ExcelConfigBusinessType.RESOURCE_EXCEL_FILE);
        ImportFileRespVo respVo = new ImportFileRespVo();
        respVo.setId(excelFileStore.getId());
        respVo.setBusinessType(ExcelConfigBusinessType.RESOURCE_EXCEL_FILE.getBusinessName());
        return ResponseEntity.ok((Object)respVo);
    }

    @AuthorizedDefinition(resources={"xforce:operation:resource:read"})
    @ApiOperation(value="\u5bfc\u51fa\u8d44\u6e90\u7801\u5217\u8868", notes="\u5bfc\u51fa\u8d44\u6e90\u7801\u5217\u8868")
    @RequestMapping(name="\u5bfc\u51fa\u8d44\u6e90\u7801\u5217\u8868", value={"/api/global/resources/export"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Long> export(@RequestBody List<String> resourceIds, HttpServletRequest request, HttpServletResponse response) {
        if (CollectionUtils.isEmpty(resourceIds)) {
            throw new IllegalArgumentException("id\u8bb0\u5f55\u4e0d\u80fd\u4e3a\u7a7a\u3002");
        }
        List<Long> list = resourceIds.stream().map(Long::valueOf).collect(Collectors.toList());
        List<ResourceExtendDto> extendList = this.resourcePortService.getExportData(list);
        List<ServiceApiExtendDto> serviceApiList = this.resourcePortService.getServiceApiData(extendList);
        ResourceWrapper wrapper = new ResourceWrapper();
        wrapper.setResources(extendList);
        wrapper.setServiceApis(serviceApiList);
        String filePath = BasePathUtils.ensureFilePath(request);
        ResourceExcelUtils.writeV2007(filePath, wrapper);
        try {
            Long fileId = this.fileTransferUtilsService.upload(filePath);
            ResponseEntity responseEntity = ResponseEntity.ok((Object)fileId);
            this.deleteFile(filePath);
            return responseEntity;
        }
        catch (Exception e) {
            this.deleteFile(filePath);
            logger.error("\u4e0a\u4f20\u6587\u4ef6\u5931\u8d25", (Throwable)e);
            throw new IllegalArgumentException("\u4e0a\u4f20\u6587\u4ef6\u5931\u8d25\u3002");
        }
    }

    @AuthorizedDefinition(resources={"xforce:operation:resource:read"})
    @ResponseBody
    @ApiOperation(value="\u5bfc\u51fa\u8d44\u6e90\u7801yaml\u6587\u4ef6", notes="\u5bfc\u51fa\u8d44\u6e90\u7801yaml\u6587\u4ef6")
    @RequestMapping(name="\u5bfc\u51fa\u8d44\u6e90\u7801yaml\u6587\u4ef6", value={"${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/resources/yaml-export"}, method={RequestMethod.GET})
    public void exportYaml(@RequestParam Long appId, HttpServletRequest request, HttpServletResponse response) {
        if (appId == null || appId <= 0L) {
            throw new IllegalArgumentException("appId\u4e0d\u80fd\u4e3a\u7a7a\u6216\u8005\u8d1f\u503c\u3002");
        }
        List<ResourceExtendDto> extendList = this.resourcePortService.getExportDataByAppId(appId);
        if (CollectionUtils.isEmpty(extendList)) {
            throw new IllegalArgumentException("\u6ca1\u6709\u67e5\u8be2\u5230\u8d44\u6e90\u7801\u8bb0\u5f55\u3002");
        }
        Map<String, Object> yamlMap = this.resourcePortService.getYamlMapByResources(extendList);
        String filePath = BasePathUtils.ensureFilePath(request);
        filePath = filePath.replace(".xlsx", ".yml");
        ResourceYamlUtils.writeYmlResource(filePath, yamlMap);
        try {
            DownloadUtils.fileToDownload(response, filePath, "resourcecode.yml");
            this.deleteFile(filePath);
        }
        catch (Exception e) {
            this.deleteFile(filePath);
            logger.error("\u4e0b\u8f7d\u6587\u4ef6\u5931\u8d25", (Throwable)e);
            throw new IllegalArgumentException("\u4e0b\u8f7d\u6587\u4ef6\u5931\u8d25\u3002");
        }
    }

    @Deprecated
    @AuthorizedDefinition(resources={"xforce:operation:resource:read"})
    @ApiOperation(value="\u4e0b\u8f7d\u6587\u4ef6", notes="\u4e0b\u8f7d\u6587\u4ef6")
    @RequestMapping(name="\u4e0b\u8f7d\u6587\u4ef6", value={"/api/global/resources/file/{fileId}"}, method={RequestMethod.GET})
    public void download(@PathVariable String fileId, HttpServletRequest request, HttpServletResponse response) {
        String filePath;
        if (StringUtils.equals((CharSequence)"template", (CharSequence)fileId)) {
            filePath = BasePathUtils.getTemplatePath(request, "resourceImport.xlsx");
        } else {
            filePath = BasePathUtils.ensureFilePath(request);
            try {
                this.fileTransferUtilsService.download(filePath, Long.valueOf(fileId));
            }
            catch (Exception e) {
                this.deleteFile(filePath);
                logger.error("\u4e0b\u8f7d\u6587\u4ef6\u5931\u8d25", (Throwable)e);
                throw new IllegalArgumentException("\u4e0b\u8f7d\u6587\u4ef6\u5931\u8d25\u3002");
            }
        }
        DownloadUtils.fileToDownload(response, filePath, "resourceImport.xlsx");
        if (!StringUtils.equals((CharSequence)"template", (CharSequence)fileId) && StringUtils.isNotBlank((CharSequence)filePath)) {
            this.deleteFile(filePath);
        }
    }

    @AuthorizedDefinition(resources={"xforce:operation:resource:save"})
    @ApiOperation(value="\u5f02\u6b65\u5bfc\u5165\u8d44\u6e90\u7801\u5217\u8868", notes="\u5f02\u6b65\u5bfc\u5165\u8d44\u6e90\u7801\u5217\u8868")
    @RequestMapping(name="\u5f02\u6b65\u5bfc\u5165\u8d44\u6e90\u7801\u5217\u8868", value={"${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/resources/async/import"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<ImportFileRespVo> asyncImport(@RequestParam(name="file", required=false) MultipartFile file) {
        Long tenantId = 0L;
        Long userId = 0L;
        if (null != UserInfoHolder.get()) {
            tenantId = UserInfoHolder.get().getTenantId();
            userId = UserInfoHolder.get().getId();
        }
        ExcelFileStore excelFileStore = this.importFileService.create(file, ExcelConfigBusinessType.RESOURCE_EXCEL_FILE, userId, tenantId);
        ImportFileRespVo respVo = new ImportFileRespVo();
        respVo.setBusinessType(ExcelConfigBusinessType.RESOURCE_EXCEL_FILE.name());
        respVo.setFileId(excelFileStore.getSourceFileId());
        respVo.setId(excelFileStore.getId());
        return ResponseEntity.ok((Object)respVo);
    }

    @Deprecated
    @AuthorizedDefinition(resources={"xforce:operation:resource:save"})
    @ApiOperation(value="\u5bfc\u5165\u8d44\u6e90\u7801\u5217\u8868", notes="\u5bfc\u5165\u8d44\u6e90\u7801\u5217\u8868")
    @RequestMapping(name="\u5bfc\u5165\u8d44\u6e90\u7801\u5217\u8868", value={"${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/resources/import"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Long> importData(HttpServletRequest request, HttpServletResponse response, @RequestParam(name="file", required=false) MultipartFile file) {
        if (file == null) {
            throw new IllegalArgumentException("\u8bf7\u9009\u62e9\u5bfc\u5165\u6587\u4ef6\u3002");
        }
        FileUtils.checkFileSize(file, 15L);
        String filePath = BasePathUtils.ensureFilePath(request);
        this.saveFileToLocal(file, filePath);
        ResourceWrapper resourceWrapper = ResourceExcelUtils.extract(filePath);
        ResourceWrapper result = this.resourcePortService.saveResourceData(resourceWrapper);
        Long fileId = null;
        if (CollectionUtils.isNotEmpty(result.getResources())) {
            String filePath2 = BasePathUtils.ensureFilePath(request);
            result.setSkipReason(false);
            ResourceExcelUtils.writeV2007(filePath2, result);
            try {
                fileId = this.fileTransferUtilsService.upload(filePath2);
                this.deleteFile(filePath2);
            }
            catch (Exception e) {
                this.deleteFile(filePath);
                this.deleteFile(filePath2);
                logger.error("\u4e0a\u4f20\u6587\u4ef6\u5931\u8d25", (Throwable)e);
                throw new IllegalArgumentException("\u4e0a\u4f20\u6587\u4ef6\u5931\u8d25\u3002");
            }
        }
        ResponseEntity responseEntity = ResponseEntity.ok(fileId);
        this.deleteFile(filePath);
        return responseEntity;
    }

    private String saveFileToLocal(MultipartFile file, String basePath) {
        File newFile = new File(basePath);
        try {
            file.transferTo(newFile);
        }
        catch (IOException e) {
            logger.error("\u5bfc\u5165\u6587\u4ef6\u5931\u8d25", (Throwable)e);
            throw new IllegalArgumentException("\u5bfc\u5165\u6587\u4ef6\u5931\u8d25");
        }
        return basePath;
    }

    @AuthorizedDefinition(resources={"xforce:operation:resource:read", "xforce:operation:user-resource:read"})
    @ApiOperation(value="\u83b7\u53d6\u8d44\u6e90\u7801\u5206\u9875", notes="\u901a\u8fc7\u5206\u9875\u53c2\u6570\uff0c\u83b7\u53d6\u8d44\u6e90\u7801\u5206\u9875")
    public ResponseEntity<Page<Resource>> page(@ApiParam(value="request") ResourceModel.Request.Query query, @ApiParam(value="pageable") Pageable pageable) {
        Pageable currentPageable = PageableFactory.ofDefaultSort((Pageable)pageable, (Sort)Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"createTime"}));
        Set withExtendParams = Stream.of("appName").collect(Collectors.toSet());
        if (StringUtils.isNotBlank((CharSequence)query.getWithExtendParams())) {
            withExtendParams.addAll(Arrays.stream(StringUtils.split((String)query.getWithExtendParams(), (String)",")).collect(Collectors.toSet()));
        }
        query.setWithExtendParams(withExtendParams.stream().collect(Collectors.joining(",")));
        Page<Resource> page = this.resourceService.page(query, currentPageable);
        return ResponseEntity.ok(page);
    }

    @AuthorizedDefinition(resources={"xforce:operation:resource:read"})
    @ApiIgnore
    @ApiOperation(value="\u83b7\u53d6\u8d44\u6e90\u7801\u5217\u8868", notes="\u901a\u8fc7\u53c2\u6570\uff0c\u83b7\u53d6\u8d44\u6e90\u7801\u5217\u8868")
    @ResponseBody
    @RequestMapping(name="\u8d44\u6e90\u7801\u5217\u8868", value={"${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/resources/list"}, method={RequestMethod.GET})
    public ResponseEntity<List<Resource>> list(ResourceModel.Request.Query query, Sort sort) {
        if (null == query.getResourceId()) {
            throw new IllegalArgumentException("\u529f\u80fd\u96c6id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Set withExtendParams = Stream.of("appName").collect(Collectors.toSet());
        if (StringUtils.isNotBlank((CharSequence)query.getWithExtendParams())) {
            withExtendParams.addAll(Arrays.stream(StringUtils.split((String)query.getWithExtendParams(), (String)",")).collect(Collectors.toSet()));
        }
        query.setWithExtendParams(withExtendParams.stream().collect(Collectors.joining(",")));
        if (sort.stream().noneMatch(order -> "createTime".equals(order.getProperty()))) {
            sort = sort.and(Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"createTime"}));
        }
        List<Resource> result = this.resourceService.list(query, sort);
        return ResponseEntity.ok(result);
    }

    @AuthorizedDefinition(resources={"xforce:operation:resource:save"})
    @ApiOperation(value="\u65b0\u589e\u8d44\u6e90\u7801")
    public ResponseEntity<Resource> create(@ApiParam(value="model", required=true) ResourceModel.Request.Save model) {
        Resource result = this.resourceService.save(model);
        return ResponseEntity.ok((Object)result);
    }

    @AuthorizedDefinition(resources={"xforce:operation:resource:save"})
    @ApiOperation(value="\u4fee\u6539\u8d44\u6e90\u7801\u8be6\u60c5")
    public ResponseEntity<Resource> update(@ApiParam(value="id", required=true) long id, @ApiParam(value="model", required=true) ResourceModel.Request.Save model) {
        Resource result = this.resourceService.update(id, model);
        return ResponseEntity.ok((Object)result);
    }

    @AuthorizedDefinition(resources={"xforce:operation:resource:read"})
    @ApiOperation(value="\u83b7\u53d6\u8d44\u6e90\u7801\u8be6\u60c5")
    public ResponseEntity<Resource> info(@ApiParam(value="id", required=true) long id) {
        Resource result = this.resourceService.findById(id);
        return ResponseEntity.ok((Object)result);
    }

    @AuthorizedDefinition(resources={"xforce:operation:resource:save"})
    @ApiOperation(value="\u5220\u9664\u8d44\u6e90\u7801")
    public ResponseEntity<String> delete(@ApiParam(value="id", required=true) long id) {
        this.resourceService.deleteById(id);
        return ResponseEntity.ok((Object)"\u5220\u9664\u6210\u529f");
    }

    @AuthorizedDefinition(resources={"xforce:operation:resource:save"})
    @ApiOperation(value="\u66f4\u65b0\u8d44\u6e90\u7801\u72b6\u6001")
    public ResponseEntity<String> updateStatus(long id, int status) {
        this.resourceService.updateStatus(id, status);
        return ResponseEntity.ok((Object)"\u66f4\u65b0\u6210\u529f");
    }

    @AuthorizedDefinition(resources={"xforce:operation:resource:save"})
    @ApiOperation(value="\u5728\u7236\u8d44\u6e90\u7801\u4e0b\u6dfb\u52a0\u8d44\u6e90\u7801")
    public ResponseEntity<Resource> append(@ApiParam(value="id", required=true) long id, @ApiParam(value="model", required=true) ResourceModel.Request.Save model) {
        Resource result = this.resourceService.append(id, model);
        return ResponseEntity.ok((Object)result);
    }

    @AuthorizedDefinition(resources={"xforce:operation:resource:save"})
    @ApiOperation(value="\u8d44\u6e90\u7801\u6279\u91cf\u7ed1\u5b9a\u63a5\u53e3")
    public ResponseEntity<String> bindApis(long id, ResourceModel.Request.BindApis bindApis) {
        this.resourceService.bindApis(id, bindApis);
        return ResponseEntity.ok((Object)"\u7ed1\u5b9a\u6210\u529f");
    }

    private void deleteFile(String filePath) {
        File file = new File(filePath);
        if (file.exists()) {
            boolean deleteResult = file.delete();
            logger.info("\u5220\u9664\u6587\u4ef6\u7ed3\u679c:{}", (Object)deleteResult);
        }
    }

    @AuthorizedDefinition(resources={"xforce:operation:resource:read"})
    @ApiOperation(value="\u83b7\u53d6\u79df\u6237\u5173\u8054\u7684\u8d44\u6e90\u7801\u5206\u9875", notes="\u901a\u8fc7\u5206\u9875\u53c2\u6570\uff0c\u83b7\u53d6\u79df\u6237\u5173\u8054\u7684\u8d44\u6e90\u7801\u5206\u9875")
    public ResponseEntity<Page<Resource>> page(long tenantId, ResourceModel.Request.Query query, Pageable pageable) {
        Pageable currentPageable = PageableFactory.ofDefaultSort((Pageable)pageable, (Sort)Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"createTime"}));
        if (tenantId > 0L) {
            query.setTenantId(Long.valueOf(tenantId));
        }
        Set withExtendParams = Stream.of("appName").collect(Collectors.toSet());
        if (StringUtils.isNotBlank((CharSequence)query.getWithExtendParams())) {
            withExtendParams.addAll(Arrays.stream(StringUtils.split((String)query.getWithExtendParams(), (String)",")).collect(Collectors.toSet()));
        }
        query.setWithExtendParams(withExtendParams.stream().collect(Collectors.joining(",")));
        Page<Resource> page = this.resourceService.page(query, currentPageable);
        return ResponseEntity.ok(page);
    }

    @AuthorizedDefinition(resources={"xforce:operation:resource:read"})
    @ApiOperation(value="\u6839\u636e\u7528\u6237ID \u83b7\u53d6\u7528\u6237role \u5173\u8054\u7684\u8d44\u6e90\u7801", notes="\u6839\u636e\u7528\u6237ID \u83b7\u53d6\u7528\u6237role \u5173\u8054\u7684\u8d44\u6e90\u7801")
    public ResponseEntity<List<ResourceDto>> getUserRoleResource(Long userId) {
        List<ResourceDTO> resourceDTOList = this.resourceService.getUserRoleResourceCode(userId);
        List resultList = resourceDTOList.stream().map(l -> {
            ResourceDto resourceDto = new ResourceDto();
            BeanUtils.copyProperties((Object)l, (Object)resourceDto);
            return resourceDto;
        }).collect(Collectors.toList());
        return ResponseEntity.ok(resultList);
    }
}

