/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.business.resource.controller;

import com.fasterxml.jackson.annotation.JsonView;
import com.xforceplus.api.common.response.ResponseEntity;
import com.xforceplus.api.global.resource.ResourcesetApi;
import com.xforceplus.api.model.ResourcesetModel;
import com.xforceplus.api.tenant.resource.ResourceSetApi;
import com.xforceplus.bo.ResourceQueryBo;
import com.xforceplus.business.excel.QueryParam;
import com.xforceplus.business.excel.writer.ExcelConfigBusinessType;
import com.xforceplus.business.file.controller.vo.ImportFileRespVo;
import com.xforceplus.business.file.service.ExportFileService;
import com.xforceplus.business.file.service.ImportFileService;
import com.xforceplus.business.resource.controller.ResourceController;
import com.xforceplus.business.resource.service.ResourcesetPortService;
import com.xforceplus.business.resource.service.ResourcesetService;
import com.xforceplus.entity.ExcelFileStore;
import com.xforceplus.entity.Resourceset;
import com.xforceplus.tenant.core.exception.UnknownException;
import com.xforceplus.tenant.security.autoscan.annotation.AuthorizedDefinition;
import com.xforceplus.tenant.security.core.context.UserInfoHolder;
import com.xforceplus.utils.BasePathUtils;
import com.xforceplus.utils.DownloadUtils;
import com.xforceplus.utils.FileUtils;
import com.xforceplus.utils.excel.ResourcesetExcelUtils;
import com.xforceplus.utils.excel.ResourcesetWrapper;
import com.xforceplus.utils.filetransfer.FileTransferUtilsService;
import io.geewit.core.jackson.view.View;
import io.geewit.core.utils.reflection.BeanUtils;
import io.geewit.data.jpa.essential.domain.PageableFactory;
import io.geewit.data.jpa.essential.search.DynamicSpecifications;
import io.geewit.data.jpa.essential.search.SearchFilter;
import io.geewit.data.jpa.essential.web.servlet.Servlets;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Controller;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.context.request.WebRequest;
import org.springframework.web.multipart.MultipartFile;
import springfox.documentation.annotations.ApiIgnore;

@Api(value="\u529f\u80fd\u96c6\u76f8\u5173\u63a5\u53e3", tags={"resources", "resourceSet"})
@Validated
@Controller
public class ResourceSetController
implements ResourcesetApi,
ResourceSetApi {
    public static final String TEMPLATE = "template";
    private static final Logger logger = LoggerFactory.getLogger(ResourceController.class);
    private final ResourcesetService resourcesetService;
    private final ResourcesetPortService resourcesetPortService;
    private final FileTransferUtilsService fileTransferUtilsService;
    private final ExportFileService exportFileService;
    private final ImportFileService importFileService;

    public ResourceSetController(ResourcesetService resourcesetService, ResourcesetPortService resourcesetPortService, ExportFileService exportFileService, FileTransferUtilsService fileTransferUtilsService, ImportFileService importFileService) {
        this.resourcesetService = resourcesetService;
        this.resourcesetPortService = resourcesetPortService;
        this.exportFileService = exportFileService;
        this.fileTransferUtilsService = fileTransferUtilsService;
        this.importFileService = importFileService;
    }

    @AuthorizedDefinition(resources={"xforce:operation:resourceset:read"})
    @ApiIgnore
    @ApiOperation(value="\u83b7\u53d6\u529f\u80fd\u96c6\u5206\u9875", notes="\u901a\u8fc7\u5206\u9875\u53c2\u6570\uff0c\u83b7\u53d6\u529f\u80fd\u96c6\u5206\u9875")
    @ResponseBody
    @RequestMapping(name="\u529f\u80fd\u96c6\u5206\u9875\u5217\u8868\u67e5\u8be2", value={"/api/global/resourcesset/query"}, method={RequestMethod.GET})
    public Page<Resourceset> page(WebRequest request, @ApiParam(value="pageable") Pageable pageable) {
        Map searchParams = Servlets.getParametersStartingWith((WebRequest)request, (String)"search_");
        Collection filters = SearchFilter.parse((Map)searchParams);
        Specification specification = DynamicSpecifications.bySearchFilter((Collection)filters);
        Page<Resourceset> page = this.resourcesetService.page((Specification<Resourceset>)specification, pageable);
        return page;
    }

    @AuthorizedDefinition(resources={"xforce:operation:resourceset:read"})
    @JsonView(value={View.Page.class})
    @ApiOperation(value="\u83b7\u53d6\u529f\u80fd\u96c6\u5206\u9875", notes="\u901a\u8fc7\u5206\u9875\u53c2\u6570\uff0c\u83b7\u53d6\u529f\u80fd\u96c6\u5206\u9875")
    public ResponseEntity<Page<Resourceset>> page(@ApiParam(value="request") ResourcesetModel.Request.Query query, @ApiParam(value="pageable") Pageable pageable) {
        Pageable currentPageable = PageableFactory.ofDefaultSort((Pageable)pageable, (Sort)Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"createTime"}));
        query.setContainCustomFlag(Boolean.valueOf(false));
        Page<Resourceset> result = this.resourcesetService.page(query, currentPageable);
        return ResponseEntity.ok(result);
    }

    @AuthorizedDefinition(resources={"xforce:operation:resourceset:read"})
    @JsonView(value={View.Info.class})
    @ApiOperation(value="\u83b7\u53d6\u529f\u80fd\u96c6\u5217\u8868", notes="\u901a\u8fc7\u53c2\u6570\uff0c\u83b7\u53d6\u529f\u80fd\u96c6\u5217\u8868")
    @ResponseBody
    @RequestMapping(name="\u529f\u80fd\u96c6\u5217\u8868", value={"${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/resourcesets/list"}, method={RequestMethod.GET})
    public ResponseEntity<List<Resourceset>> list(@ApiParam(value="request") ResourcesetModel.Request.Query query, @ApiParam(value="sort") Sort sort) {
        if (sort.stream().noneMatch(order -> "createTime".equals(order.getProperty()))) {
            sort = sort.and(Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"createTime"}));
        }
        List<Resourceset> result = this.resourcesetService.list(query, sort);
        return ResponseEntity.ok(result);
    }

    @AuthorizedDefinition(resources={"xforce:operation:resourceset:save"})
    @JsonView(value={View.Page.class})
    @ApiOperation(value="\u65b0\u589e\u529f\u80fd\u96c6")
    public ResponseEntity<Resourceset> create(@ApiParam(value="model", required=true) ResourcesetModel.Request.Create model) {
        Resourceset result = this.resourcesetService.create(model);
        return ResponseEntity.ok((Object)result);
    }

    @AuthorizedDefinition(resources={"xforce:operation:resourceset:save"})
    @JsonView(value={View.Page.class})
    @ApiOperation(value="\u66f4\u65b0\u529f\u80fd\u96c6")
    public ResponseEntity<Resourceset> update(@ApiParam(value="id", required=true) long id, @ApiParam(value="model", required=true) ResourcesetModel.Request.Save model) {
        Resourceset result = this.resourcesetService.update(id, model);
        return ResponseEntity.ok((Object)result);
    }

    @AuthorizedDefinition(resources={"xforce:operation:resourceset:save"})
    @ApiOperation(value="\u4fee\u6539\u529f\u80fd\u96c6\u72b6\u6001")
    public ResponseEntity<String> updateStatus(long id, int status) {
        this.resourcesetService.updateStatus(id, status);
        return ResponseEntity.ok((Object)"\u4fee\u6539\u6210\u529f");
    }

    @AuthorizedDefinition(resources={"xforce:operation:resourceset:read"})
    @ApiOperation(value="\u83b7\u53d6\u529f\u80fd\u96c6\u8be6\u60c5")
    public ResponseEntity<Resourceset> info(@ApiParam(value="id", required=true) long id) {
        Resourceset result = this.resourcesetService.findById(id);
        return ResponseEntity.ok((Object)result);
    }

    @AuthorizedDefinition(resources={"xforce:operation:resourceset:save"})
    @ApiOperation(value="\u5220\u9664\u529f\u80fd\u96c6")
    public ResponseEntity<String> delete(@ApiParam(value="id", required=true) long id) {
        this.resourcesetService.deleteById(id);
        return ResponseEntity.ok((Object)"\u5220\u9664\u6210\u529f");
    }

    @AuthorizedDefinition(resources={"xforce:operation:resourceset:read"})
    @ApiOperation(value="\u5bfc\u51fa\u529f\u80fd\u96c6\u5217\u8868", notes="\u5bfc\u51fa\u529f\u80fd\u96c6\u5217\u8868")
    @RequestMapping(name="\u5bfc\u51fa\u529f\u80fd\u96c6\u5217\u8868", value={"${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/resourcesets/export"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Long> export(@RequestBody List<String> resourceSetIds, HttpServletRequest request, HttpServletResponse response) {
        if (CollectionUtils.isEmpty(resourceSetIds)) {
            throw new UnknownException("id\u8bb0\u5f55\u4e0d\u80fd\u4e3a\u7a7a\u3002");
        }
        List<Long> list = resourceSetIds.stream().map(Long::valueOf).collect(Collectors.toList());
        ResourcesetWrapper resourcesetWrapper = this.resourcesetPortService.getExportData(list);
        String filePath = BasePathUtils.ensureFilePath(request);
        ResourcesetExcelUtils.writeV2007(filePath, resourcesetWrapper);
        try {
            Long fileId = this.fileTransferUtilsService.upload(filePath);
            ResponseEntity responseEntity = ResponseEntity.ok((Object)fileId);
            this.deleteFile(filePath);
            return responseEntity;
        }
        catch (Exception e) {
            this.deleteFile(filePath);
            logger.error("\u4e0a\u4f20\u6587\u4ef6\u5931\u8d25", (Throwable)e);
            throw new UnknownException("\u4e0a\u4f20\u6587\u4ef6\u5931\u8d25\u3002");
        }
    }

    @AuthorizedDefinition(resources={"xforce:operation:resourceset:read"})
    @ApiOperation(value="\u5f02\u6b65\u5bfc\u51fa\u529f\u80fd\u96c6\u5217\u8868", notes="\u5f02\u6b65\u5bfc\u51fa\u529f\u80fd\u96c6\u5217\u8868")
    @RequestMapping(name="\u5f02\u6b65\u5bfc\u51fa\u529f\u80fd\u96c6\u5217\u8868", value={"${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/resourcesets/async/export"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<ImportFileRespVo> asyncExport(@ApiParam(value="request") @RequestBody ResourcesetModel.Request.Query query, @ApiParam(value="sort") Sort sort) {
        if (ArrayUtils.isEmpty((Object[])query.getSheets())) {
            throw new UnknownException("\u8bf7\u9009\u62e9SheetName");
        }
        QueryParam queryParam = QueryParam.builder().param("P_QUERY", query).param("P_SORT", sort).build();
        ResourceQueryBo queryBo = new ResourceQueryBo();
        BeanUtils.copyProperties((Object)query, (Object)queryBo);
        ExcelFileStore excelFileStore = this.exportFileService.asyncExcelExport(queryParam.params(), ExcelConfigBusinessType.RESOURCE_SET_EXCEL_FILE);
        ImportFileRespVo respVo = new ImportFileRespVo();
        respVo.setId(excelFileStore.getId());
        respVo.setBusinessType(ExcelConfigBusinessType.RESOURCE_SET_EXCEL_FILE.getBusinessName());
        return ResponseEntity.ok((Object)respVo);
    }

    @AuthorizedDefinition(resources={"xforce:operation:resourceset:save"})
    @ApiOperation(value="\u5f02\u6b65\u5bfc\u5165\u529f\u80fd\u96c6\u5217\u8868", notes="\u5f02\u6b65\u5bfc\u5165\u529f\u80fd\u96c6\u5217\u8868")
    @RequestMapping(name="\u5f02\u6b65\u5bfc\u5165\u529f\u80fd\u96c6\u5217\u8868", value={"${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/resourcesets/async/import"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<ImportFileRespVo> asyncImport(@RequestParam(name="file", required=false) MultipartFile file) {
        Long tenantId = 0L;
        Long userId = 0L;
        if (null != UserInfoHolder.get()) {
            tenantId = UserInfoHolder.get().getTenantId();
            userId = UserInfoHolder.get().getId();
        }
        ExcelFileStore excelFileStore = this.importFileService.create(file, ExcelConfigBusinessType.RESOURCE_SET_EXCEL_FILE, userId, tenantId);
        ImportFileRespVo respVo = new ImportFileRespVo();
        respVo.setBusinessType(ExcelConfigBusinessType.RESOURCE_SET_EXCEL_FILE.name());
        respVo.setFileId(excelFileStore.getSourceFileId());
        respVo.setId(excelFileStore.getId());
        return ResponseEntity.ok((Object)respVo);
    }

    @AuthorizedDefinition(resources={"xforce:operation:resourceset:read"})
    @ApiOperation(value="\u4e0b\u8f7d\u6587\u4ef6", notes="\u4e0b\u8f7d\u6587\u4ef6")
    @RequestMapping(name="\u4e0b\u8f7d\u6587\u4ef6", value={"/api/global/resourcesets/file/{fileId}"}, method={RequestMethod.GET})
    public void download(@PathVariable String fileId, HttpServletRequest request, HttpServletResponse response) {
        String filePath;
        if (StringUtils.equals((CharSequence)TEMPLATE, (CharSequence)fileId)) {
            filePath = BasePathUtils.getTemplatePath(request, "resourceset.xlsx");
        } else {
            filePath = BasePathUtils.ensureFilePath(request);
            try {
                this.fileTransferUtilsService.download(filePath, Long.valueOf(fileId));
            }
            catch (Exception e) {
                this.deleteFile(filePath);
                logger.error("\u4e0b\u8f7d\u6587\u4ef6\u5931\u8d25", (Throwable)e);
                throw new UnknownException("\u4e0b\u8f7d\u6587\u4ef6\u5931\u8d25\u3002");
            }
        }
        DownloadUtils.fileToDownload(response, filePath, "resourceset.xlsx");
        this.deleteFile(filePath);
    }

    @AuthorizedDefinition(resources={"xforce:operation:resourceset:save"})
    @ApiOperation(value="\u5bfc\u5165\u529f\u80fd\u96c6\u5217\u8868", notes="\u5bfc\u5165\u529f\u80fd\u96c6\u5217\u8868")
    @RequestMapping(name="\u5bfc\u5165\u529f\u80fd\u96c6\u5217\u8868", value={"${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/resourcesets/import"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Long> importData(HttpServletRequest request, HttpServletResponse response, @RequestParam(name="file", required=false) MultipartFile file) {
        if (file == null) {
            throw new UnknownException("\u8bf7\u9009\u62e9\u5bfc\u5165\u6587\u4ef6\u3002");
        }
        FileUtils.checkFileSize(file, 15L);
        String filePath = BasePathUtils.ensureFilePath(request);
        this.saveFileToLocal(file, filePath);
        ResourcesetWrapper resourcesetWrapper = ResourcesetExcelUtils.extract(filePath);
        ResourcesetWrapper result = this.resourcesetPortService.saveResourcesetData(resourcesetWrapper);
        Long fileId = null;
        if (CollectionUtils.isNotEmpty(result.getResourcesets())) {
            String filePath2 = BasePathUtils.ensureFilePath(request);
            result.setSkipReason(false);
            ResourcesetExcelUtils.writeV2007(filePath2, result);
            try {
                fileId = this.fileTransferUtilsService.upload(filePath2);
                this.deleteFile(filePath2);
            }
            catch (Exception e) {
                this.deleteFile(filePath);
                this.deleteFile(filePath2);
                logger.error("\u4e0a\u4f20\u6587\u4ef6\u5931\u8d25", (Throwable)e);
                throw new UnknownException("\u4e0a\u4f20\u6587\u4ef6\u5931\u8d25\u3002");
            }
        }
        ResponseEntity responseEntity = ResponseEntity.ok(fileId);
        this.deleteFile(filePath);
        return responseEntity;
    }

    private String saveFileToLocal(MultipartFile file, String basePath) {
        File newFile = new File(basePath);
        try {
            file.transferTo(newFile);
        }
        catch (IOException e) {
            logger.error("\u5bfc\u5165\u6587\u4ef6\u5931\u8d25", (Throwable)e);
            throw new UnknownException("\u5bfc\u5165\u6587\u4ef6\u5931\u8d25");
        }
        return basePath;
    }

    private InputStream getInputStreamByFile(String newFilePath) {
        FileInputStream in;
        try {
            in = new FileInputStream(new File(newFilePath));
        }
        catch (FileNotFoundException e) {
            logger.error("\u8bfb\u53d6\u6587\u4ef6\u5931\u8d25,\u6587\u4ef6\u6ca1\u6709\u627e\u5230", (Throwable)e);
            throw new UnknownException("\u8bfb\u53d6\u6587\u4ef6\u5931\u8d25\uff0c\u6587\u4ef6\u6ca1\u6709\u627e\u5230\u3002");
        }
        return in;
    }

    private void deleteFile(String filePath) {
        File file = new File(filePath);
        if (file.exists()) {
            boolean deleteResult = file.delete();
            logger.info("\u5220\u9664\u6587\u4ef6\u7ed3\u679c:{}", (Object)deleteResult);
        }
    }

    @AuthorizedDefinition(authorization=false)
    @JsonView(value={View.Page.class})
    @ApiOperation(value="\u83b7\u53d6\u79df\u6237\u5173\u8054\u529f\u80fd\u96c6\u5206\u9875", notes="\u901a\u8fc7\u5206\u9875\u53c2\u6570\uff0c\u83b7\u53d6\u79df\u6237\u5173\u8054\u529f\u80fd\u96c6\u5206\u9875")
    public ResponseEntity<Page<Resourceset>> page(Long tenantId, ResourcesetModel.Request.Query query, Pageable pageable) {
        Pageable currentPageable = PageableFactory.ofDefaultSort((Pageable)pageable, (Sort)Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"createTime"}));
        if (tenantId > 0L) {
            query.setTenantId(tenantId);
        }
        Page<Resourceset> result = this.resourcesetService.page(query, currentPageable);
        return ResponseEntity.ok(result);
    }
}

