/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.business.resource.controller;

import com.xforceplus.api.common.response.ResponseEntity;
import com.xforceplus.api.model.ResourceModel;
import com.xforceplus.api.model.ServiceApiModel;
import com.xforceplus.api.tenant.resource.ServiceApiApi;
import com.xforceplus.business.resource.service.ResourceService;
import com.xforceplus.business.resource.service.ServiceApiService;
import com.xforceplus.entity.Resource;
import com.xforceplus.entity.ServiceApi;
import com.xforceplus.tenant.security.autoscan.annotation.AuthorizedDefinition;
import io.geewit.data.jpa.essential.domain.PageableFactory;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Controller;
import org.springframework.validation.annotation.Validated;

@Api(value="\u670d\u52a1\u63a5\u53e3\u76f8\u5173\u63a5\u53e3", tags={"resources", "serviceApi"})
@Validated
@Controller
public class ServiceApiController
implements ServiceApiApi {
    private static final Logger logger = LoggerFactory.getLogger(ServiceApiController.class);
    private final ServiceApiService serviceApiService;
    private final ResourceService resourceService;

    public ServiceApiController(ServiceApiService serviceApiService, ResourceService resourceService) {
        this.serviceApiService = serviceApiService;
        this.resourceService = resourceService;
    }

    @AuthorizedDefinition(resources={"xforce:operation:serviceApi:read"})
    @ApiOperation(value="\u79df\u6237\u5173\u8054\u670d\u52a1\u5305\u63a5\u53e3\u5206\u9875\u5217\u8868")
    public ResponseEntity<Page<ServiceApi>> page(long tenantId, ServiceApiModel.Request.Query query, Pageable pageable) {
        Pageable currentPageable = PageableFactory.ofDefaultSort((Pageable)pageable, (Sort)Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"createTime"}));
        if (tenantId > 0L) {
            query.setTenantId(Long.valueOf(tenantId));
        }
        Page<ServiceApi> result = this.serviceApiService.page(query, currentPageable);
        return ResponseEntity.ok(result);
    }

    @AuthorizedDefinition(resources={"xforce:operation:serviceApi:save"})
    @ApiOperation(value="\u79df\u6237\u5173\u8054\u670d\u52a1\u5305\u63a5\u53e3\u4fe1\u606f")
    public ResponseEntity<ServiceApi> info(long tenantId, long id) {
        ServiceApi result = this.serviceApiService.findById(id);
        return ResponseEntity.ok((Object)result);
    }

    @AuthorizedDefinition(resources={"xforce:operation:serviceApi:read"})
    @ApiOperation(value="\u79df\u6237\u5173\u8054\u670d\u52a1\u5305\u63a5\u53e3\u5bf9\u5e94\u7684\u8d44\u6e90\u7801\u5206\u9875\u5217\u8868")
    public ResponseEntity<Page<Resource>> resources(long tenantId, long serviceApiId, Pageable pageable) {
        Pageable currentPageable = PageableFactory.ofDefaultSort((Pageable)pageable, (Sort)Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"createTime"}));
        ResourceModel.Request.Query query = new ResourceModel.Request.Query();
        if (tenantId > 0L) {
            query.setTenantId(Long.valueOf(tenantId));
        }
        query.setServiceApiId(Long.valueOf(serviceApiId));
        Page<Resource> result = this.resourceService.page(query, currentPageable);
        return ResponseEntity.ok(result);
    }
}

