/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.business.resource.service;

import com.alibaba.excel.event.AnalysisEventListener;
import com.xforceplus.api.model.ResourceModel;
import com.xforceplus.api.model.ServiceApiModel;
import com.xforceplus.bo.ResourceQueryBo;
import com.xforceplus.business.app.service.AppService;
import com.xforceplus.business.excel.BusinessType;
import com.xforceplus.business.excel.ExcelSheet;
import com.xforceplus.business.excel.SimpleExcelWriter;
import com.xforceplus.business.excel.reader.Context;
import com.xforceplus.business.excel.reader.MessageRow;
import com.xforceplus.business.excel.reader.SimpleDataReadListener;
import com.xforceplus.business.excel.writer.ExcelConfigBusinessType;
import com.xforceplus.business.resource.dto.ResourceExcelDTO;
import com.xforceplus.business.resource.dto.ServiceApiExcelDTO;
import com.xforceplus.business.resource.service.ResourceService;
import com.xforceplus.business.service.ExcelReaderService;
import com.xforceplus.business.service.ExcelWriteService;
import com.xforceplus.dao.ResourceApiRelDao;
import com.xforceplus.dao.ResourceDao;
import com.xforceplus.dao.RouteDao;
import com.xforceplus.dao.ServiceApiDao;
import com.xforceplus.dto.resource.ResourceDTO;
import com.xforceplus.dto.resource.ResourceServiceApiDTO;
import com.xforceplus.dto.resource.ServiceApiRouterDTO;
import com.xforceplus.entity.App;
import com.xforceplus.entity.Resource;
import com.xforceplus.entity.ResourceApiRel;
import com.xforceplus.entity.Route;
import com.xforceplus.entity.ServiceApi;
import com.xforceplus.utils.ApiUtils;
import io.geewit.core.utils.reflection.BeanUtils;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.NumberUtils;
import org.springframework.web.bind.annotation.RequestMethod;

@Service
public class ResourceExcelServiceImpl
implements ExcelWriteService,
ExcelReaderService {
    private static final Logger log = LoggerFactory.getLogger(ResourceExcelServiceImpl.class);
    private final ResourceService resourceService;
    @Autowired
    private ResourceDao resourceDao;
    @Autowired
    private ServiceApiDao serviceApiDao;
    @Autowired
    private RouteDao routeDao;
    @Autowired
    private ResourceApiRelDao resourceApiRelDao;
    private final AppService appService;

    public ResourceExcelServiceImpl(ResourceService resourceService, AppService appService) {
        this.resourceService = resourceService;
        this.appService = appService;
    }

    @Override
    public BusinessType getBusinessType() {
        return ExcelConfigBusinessType.RESOURCE_EXCEL_FILE;
    }

    @Override
    public Context importExcel(Context context) {
        List<ExcelSheet> sheets = context.getExcelBook().getExcelSheets();
        List<Long> appIds = this.findAllByApp();
        for (ExcelSheet sheet : sheets) {
            AnalysisEventListener excelDataListener;
            MessageRow messageRows;
            String sheetName = sheet.getSheetName();
            if ("\u8d44\u6e90\u7801".equals(sheetName)) {
                messageRows = new MessageRow(sheetName);
                excelDataListener = SimpleDataReadListener.listener(context, rows -> this.saveResources(messageRows, context, (List<ResourceExcelDTO>)rows, appIds));
                context.getSimpleExcelReader().read(ResourceExcelDTO.class, excelDataListener, sheetName);
                continue;
            }
            if (!"\u670d\u52a1API".equals(sheetName)) continue;
            messageRows = new MessageRow(sheetName);
            excelDataListener = SimpleDataReadListener.listener(context, rows -> this.saveServiceApi(messageRows, context, (List<ServiceApiExcelDTO>)rows, appIds));
            context.getSimpleExcelReader().read(ServiceApiExcelDTO.class, excelDataListener, sheetName);
        }
        return context;
    }

    private void saveServiceApi(MessageRow messageRows, Context context, List<ServiceApiExcelDTO> rows, List<Long> appIds) {
        if (CollectionUtils.isEmpty(rows)) {
            return;
        }
        for (ServiceApiExcelDTO row : rows) {
            try {
                if (!row.getValidatedStatus().booleanValue()) {
                    messageRows.fail(row.getRowIndex(), row.getValidatedMessage());
                    continue;
                }
                if ("\u65b0\u589e\u5e76\u7ed1\u5b9a".equals(row.getAction())) {
                    this.saveServiceApi(messageRows, row, appIds);
                    continue;
                }
                if (!"\u89e3\u7ed1".equals(row.getAction())) continue;
                this.unBindServiceApi(messageRows, row, appIds);
            }
            catch (Exception ex) {
                log.error(ex.getMessage(), (Throwable)ex);
                messageRows.fail(row.getRowIndex(), row.getAction() + "\u6570\u636e\u5931\u8d25");
            }
        }
        context.messageRow(messageRows.getSheetName(), messageRows);
    }

    private void unBindServiceApi(MessageRow messageRows, ServiceApiExcelDTO row, List<Long> appIds) {
        Long appId = (Long)NumberUtils.parseNumber((String)row.getAppId(), Long.class);
        if (!appIds.contains(appId)) {
            messageRows.fail(row.getRowIndex(), "\u3010" + appId + "\u3011APP\u7684\u6570\u636e\u4e0d\u5b58\u5728");
            return;
        }
        RequestMethod requestMethod = RequestMethod.valueOf((String)row.getRequestMethod());
        String resourceCode = row.getResourceCode();
        Optional<Object> serviceApi = Optional.empty();
        Optional<Route> routeOptional = this.findByPath(row.getPath());
        if (!routeOptional.isPresent()) {
            messageRows.fail(row.getRowIndex(), "\u3010" + row.getPath() + "\u3011\u4e0d\u5b58\u5728");
            return;
        }
        Long routeId = routeOptional.get().getRouteId();
        try {
            serviceApi = this.findByRouteIdApiUrlMethod(routeId, row.getServiceApiUrl(), requestMethod);
        }
        catch (IllegalArgumentException e) {
            messageRows.fail(row.getRowIndex(), e.getMessage());
            return;
        }
        if (!serviceApi.isPresent()) {
            messageRows.fail(row.getRowIndex(), "\u8def\u5f84ID:\u3010" + routeId + "\u3011\u670d\u52a1URL:\u3010" + row.getServiceApiUrl() + "\u3011RequestMethod:\u3010" + requestMethod.name() + "\u3011\u7684\u6570\u636e\u4e0d\u5b58\u5728");
            return;
        }
        Optional<Resource> resourceOptional = this.findResourceByCodeAppId(appId, resourceCode);
        if (!resourceOptional.isPresent()) {
            messageRows.fail(row.getRowIndex(), "\u8be5\u3010" + resourceCode + "\u3011" + "\u8d44\u6e90\u7801\u6570\u636e\u672a\u627e\u5230");
            return;
        }
        try {
            this.unbindServiceApiResourceRel(((ServiceApi)serviceApi.get()).getServiceApiId(), resourceOptional.get().getResourceId());
            messageRows.success(row.getRowIndex());
        }
        catch (Exception e) {
            messageRows.fail(row.getRowIndex(), e.getMessage());
        }
    }

    private void bindServiceApi(MessageRow messageRows, ServiceApiExcelDTO row, Long resourceId, String resourceCode, ServiceApi serviceApi) {
        List<ResourceApiRel> resourceApiRelList = this.findResourceApiRelByServiceApiId(serviceApi.getServiceApiId());
        if (!CollectionUtils.isEmpty(resourceApiRelList)) {
            messageRows.fail(row.getRowIndex(), "\u8be5[" + serviceApi.getServiceApiName() + "]\u670d\u52a1API\u5df2\u7ed1\u5b9a\u8d44\u6e90\u7801");
            return;
        }
        ServiceApiModel.Request.BindResources bindResources = new ServiceApiModel.Request.BindResources();
        bindResources.setOverwrite(false);
        bindResources.setResourceIds(Stream.of(resourceId).collect(Collectors.toList()));
        try {
            this.bindResources(serviceApi, bindResources);
            messageRows.success(row.getRowIndex());
        }
        catch (Exception e) {
            messageRows.fail(row.getRowIndex(), "\u7ed1\u5b9a[" + resourceCode + "]\u8d44\u6e90\u7801\u5931\u8d25");
        }
    }

    private List<Long> findAllByApp() {
        List<App> appList = this.appService.list();
        if (CollectionUtils.isEmpty(appList)) {
            return Collections.emptyList();
        }
        return appList.stream().map(App::getAppId).collect(Collectors.toList());
    }

    public Optional<Route> findByPath(String path) {
        List routeList = this.routeDao.findByPath(path);
        if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)routeList)) {
            return Optional.empty();
        }
        if (routeList.size() > 1) {
            throw new IllegalArgumentException("\u3010" + path + "\u3011\u8def\u7531\u5b58\u5728\u4e0d\u552f\u4e00\u8bb0\u5f55");
        }
        return Optional.of(routeList.get(0));
    }

    private void saveServiceApi(MessageRow messageRows, ServiceApiExcelDTO row, List<Long> appIds) {
        Optional<ServiceApi> serviceApi;
        Optional<Route> routeOptional;
        Long appId = (Long)NumberUtils.parseNumber((String)row.getAppId(), Long.class);
        if (!appIds.contains(appId)) {
            messageRows.fail(row.getRowIndex(), "\u3010" + appId + "\u3011APP\u7684\u6570\u636e\u4e0d\u5b58\u5728");
            return;
        }
        RequestMethod requestMethod = RequestMethod.valueOf((String)StringUtils.upperCase((String)row.getRequestMethod()));
        String resourceCode = row.getResourceCode();
        String path = row.getPath();
        try {
            routeOptional = this.findByPath(path);
            if (!routeOptional.isPresent()) {
                messageRows.fail(row.getRowIndex(), "\u3010" + path + "\u3011\u8def\u7531\u4e0d\u5b58\u5728");
                return;
            }
        }
        catch (IllegalArgumentException e) {
            messageRows.fail(row.getRowIndex(), e.getMessage());
            return;
        }
        Long routeId = routeOptional.get().getRouteId();
        Optional<Resource> resourceOptional = this.findResourceByCodeAppId(appId, resourceCode);
        if (!resourceOptional.isPresent()) {
            messageRows.fail(row.getRowIndex(), "\u8be5\u3010" + resourceCode + "\u3011" + "\u8d44\u6e90\u7801\u6570\u636e\u672a\u627e\u5230");
            return;
        }
        if (resourceOptional.get().getParentId() == null) {
            messageRows.fail(row.getRowIndex(), "\u3010" + resourceCode + "\u3011\u4e3a\u4e00\u7ea7\u8d44\u6e90\u7801\u4e0d\u80fd\u7ed1\u5b9a\u670d\u52a1API");
            return;
        }
        List<ResourceApiRel> resourceApiRelList = this.findResourceApiRelByResourceId(resourceOptional.get().getResourceId());
        if (!CollectionUtils.isEmpty(resourceApiRelList)) {
            messageRows.fail(row.getRowIndex(), "\u8be5[]" + resourceCode + "]\u8d44\u6e90\u7801\u5df2\u7ed1\u5b9a\u670d\u52a1API");
            return;
        }
        String hash = ApiUtils.hash((String)row.getServiceApiUrl(), (String)requestMethod.name(), (Long)routeId);
        try {
            serviceApi = this.findByHash(hash);
        }
        catch (IllegalArgumentException e) {
            messageRows.fail(row.getRowIndex(), e.getMessage());
            return;
        }
        if (serviceApi.isPresent()) {
            log.info("rowIndex:{},\u8def\u5f84Path:{},\u670d\u52a1URL:{},RequestMethod:{},\u7684\u6570\u636e\u5df2\u5b58\u5728,\u8fdb\u7ed1\u5b9a\u6570\u636e", new Object[]{row.getRowIndex(), path, row.getServiceApiUrl(), requestMethod.name()});
            this.bindServiceApi(messageRows, row, resourceOptional.get().getResourceId(), resourceCode, serviceApi.get());
            return;
        }
        ServiceApiModel.Request.Save save = new ServiceApiModel.Request.Save();
        save.setAppId(appId);
        save.setRouteId(routeId);
        save.setRequestMethod(requestMethod);
        save.setServiceApiName(row.getServiceApiName());
        save.setServiceApiPath(row.getServiceApiPath());
        save.setServiceApiUrl(row.getServiceApiUrl());
        save.setSkipAuth(Boolean.valueOf(true));
        save.setSkipCheck(Boolean.valueOf(true));
        save.setStatus(Integer.valueOf(1));
        ServiceApiModel.Request.BindResources bindResources = new ServiceApiModel.Request.BindResources();
        bindResources.setResourceIds(Stream.of(resourceOptional.get().getResourceId()).collect(Collectors.toList()));
        bindResources.setOverwrite(false);
        save.setBindResources(bindResources);
        try {
            this.saveServiceApi(save);
            messageRows.success(row.getRowIndex());
        }
        catch (Exception e) {
            messageRows.fail(row.getRowIndex(), "\u4fdd\u5b58\u6570\u636e\u5931\u8d25");
        }
    }

    public Optional<ServiceApi> findByHash(String hash) {
        List serviceApis = this.serviceApiDao.findByHash(hash);
        if (CollectionUtils.isEmpty((Collection)serviceApis)) {
            return Optional.empty();
        }
        if (serviceApis.size() > 1) {
            throw new IllegalArgumentException("\u5b58\u5728\u76f8\u540c\u7684hash\u503c[" + hash + "]\uff0c\u8bf7\u5148\u4fee\u6b63\u6570\u636e");
        }
        return Optional.of(serviceApis.get(0));
    }

    public List<ResourceApiRel> findResourceApiRelByResourceId(Long resoruceId) {
        return this.resourceApiRelDao.findByResourceId(resoruceId);
    }

    @Transactional(rollbackFor={RuntimeException.class})
    public ServiceApi saveServiceApi(ServiceApiModel.Request.Save model) {
        ServiceApi entity = new ServiceApi();
        BeanUtils.copyProperties((Object)model, (Object)entity);
        entity = (ServiceApi)this.serviceApiDao.saveAndFlush((Object)entity);
        this.bindResources(entity, model.getBindResources());
        return entity;
    }

    private void saveResources(MessageRow messageRows, Context context, List<ResourceExcelDTO> rows, List<Long> appIds) {
        if (CollectionUtils.isEmpty(rows)) {
            return;
        }
        Collections.sort(rows);
        for (ResourceExcelDTO row : rows) {
            try {
                if (!row.getValidatedStatus().booleanValue()) {
                    messageRows.fail(row.getRowIndex(), row.getValidatedMessage());
                    continue;
                }
                if ("\u65b0\u589e".equals(row.getAction())) {
                    this.saveResource(messageRows, row, appIds);
                    continue;
                }
                if (!"\u4fee\u6539".equals(row.getAction())) continue;
                this.updateResource(messageRows, row, appIds);
            }
            catch (Exception ex) {
                log.error(ex.getMessage(), (Throwable)ex);
                messageRows.fail(row.getRowIndex(), row.getAction() + "\u6570\u636e\u5931\u8d25");
            }
        }
        context.messageRow(messageRows.getSheetName(), messageRows);
    }

    private void updateResource(MessageRow messageRows, ResourceExcelDTO row, List<Long> appIds) {
        Long appId = (Long)NumberUtils.parseNumber((String)row.getAppId(), Long.class);
        String parentResourceCode = StringUtils.trimToEmpty((String)row.getParentResourceCode());
        String resourceCode = StringUtils.trimToEmpty((String)row.getResourceCode());
        Optional<Resource> resourceOptional = this.findResourceByCodeAppId(appId, resourceCode);
        if (!resourceOptional.isPresent()) {
            messageRows.fail(row.getRowIndex(), "\u8be5\u3010" + resourceCode + "\u3011" + "\u8d44\u6e90\u7801\u6570\u636e\u672a\u627e\u5230");
            return;
        }
        Optional<Resource> parentResourceOptional = this.findResourceByCodeAppId(appId, parentResourceCode);
        if (StringUtils.isNotBlank((CharSequence)parentResourceCode) && !parentResourceOptional.isPresent()) {
            messageRows.fail(row.getRowIndex(), "\u8be5\u3010" + parentResourceCode + "\u3011\u4e0a\u7ea7\u8d44\u6e90\u7801\u672a\u627e\u5230");
            return;
        }
        Resource resource = resourceOptional.get();
        if (this.isParentResource(resourceCode, parentResourceOptional, resource.getParentId())) {
            messageRows.fail(row.getRowIndex(), "\u8be5\u3010" + parentResourceCode + "\u3011\u7236\u7ea7\u8d44\u6e90\u7801\u5c42\u7ea7\u8fc7\u591a");
            return;
        }
        resource.setResourceName(row.getResourceName());
        if (parentResourceOptional.isPresent()) {
            resource.setParentId(resource.getParentId());
        }
        try {
            this.resourceService.update(resource);
            messageRows.success(row.getRowIndex());
        }
        catch (RuntimeException e) {
            messageRows.fail(row.getRowIndex(), "\u66f4\u65b0\u6570\u636e\u5931\u8d25");
        }
    }

    private boolean isParentResource(String resourceCode, Optional<Resource> optionalResource, Long parentId) {
        Resource resource;
        return StringUtils.isNotBlank((CharSequence)resourceCode) && optionalResource.isPresent() && (resource = optionalResource.get()).getResourceId().equals(parentId) && resource.getParentId() != null && resource.getParentId() != 0L;
    }

    private Optional<Resource> findResourceByCodeAppId(Long appId, String resourceCode) {
        return this.resourceService.findByAppIdResourceCode(appId, resourceCode);
    }

    private void saveResource(MessageRow messageRows, ResourceExcelDTO row, List<Long> appIds) {
        Long appId = (Long)NumberUtils.parseNumber((String)row.getAppId(), Long.class);
        if (!appIds.contains(appId)) {
            messageRows.fail(row.getRowIndex(), "\u3010" + appId + "\u3011APP\u7684\u6570\u636e\u4e0d\u5b58\u5728");
            return;
        }
        String resourceCode = StringUtils.trimToEmpty((String)row.getResourceCode());
        Optional<Resource> resourceOptional = this.findResourceByCodeAppId(appId, resourceCode);
        if (resourceOptional.isPresent()) {
            messageRows.fail(row.getRowIndex(), "\u8be5\u3010" + resourceCode + "\u3011\u8d44\u6e90\u7801\u5df2\u5b58\u5728");
            return;
        }
        String parentResourceCode = StringUtils.trimToEmpty((String)row.getParentResourceCode());
        Optional<Resource> parentResourceOptional = this.findResourceByCodeAppId(appId, parentResourceCode);
        if (StringUtils.isNotBlank((CharSequence)parentResourceCode) && !parentResourceOptional.isPresent()) {
            messageRows.fail(row.getRowIndex(), "\u8be5\u3010" + parentResourceCode + "\u3011\u4e0a\u7ea7\u8d44\u6e90\u7801\u672a\u627e\u5230");
            return;
        }
        if (StringUtils.isNotBlank((CharSequence)parentResourceCode) && parentResourceOptional.isPresent() && parentResourceOptional.get().getParentId() != null && parentResourceOptional.get().getParentId() != 0L) {
            messageRows.fail(row.getRowIndex(), "\u8be5\u3010" + parentResourceCode + "\u3011\u7236\u7ea7\u8d44\u6e90\u7801\u5c42\u7ea7\u8fc7\u591a");
            return;
        }
        ResourceModel.Request.Save save = new ResourceModel.Request.Save();
        save.setAppId(appId);
        save.setResourceCode(resourceCode);
        save.setResourceName(row.getResourceName());
        if (parentResourceOptional.isPresent()) {
            save.setParentId(parentResourceOptional.get().getResourceId());
        }
        save.setStatus(Integer.valueOf(1));
        try {
            this.resourceService.save(save);
            messageRows.success(row.getRowIndex());
        }
        catch (IllegalArgumentException e) {
            messageRows.fail(row.getRowIndex(), e.getMessage());
        }
    }

    public Optional<ServiceApi> findByRouteIdApiUrlMethod(Long routeId, String serviceApiUrl, RequestMethod requestMethod) {
        List serviceApis = this.serviceApiDao.findByRouteIdAndServiceApiUrlAndRequestMethod(routeId, serviceApiUrl, requestMethod);
        if (CollectionUtils.isEmpty((Collection)serviceApis)) {
            return Optional.empty();
        }
        if (serviceApis.size() > 1) {
            throw new IllegalArgumentException("\u8def\u5f84ID:[" + routeId + "], Path:[" + serviceApiUrl + "], RequestMethod:[" + requestMethod.name() + "]\u4e0d\u552f\u4e00\u6570\u636e\uff0c\u8bf7\u5148\u4fee\u6b63\u6570\u636e");
        }
        return Optional.of(serviceApis.get(0));
    }

    @Override
    public void write(Context context) {
        ResourceModel.Request.Query query = context.getParam("P_QUERY", ResourceModel.Request.Query.class);
        Sort sort = context.getParam("P_SORT", Sort.class);
        List<String> sheetNames = Arrays.asList(query.getSheets());
        SimpleExcelWriter simpleExcelWriter = context.getSimpleExcelWriter();
        Integer maxPageSize = context.getMaxPageSize();
        ResourceQueryBo resourceQueryBo = new ResourceQueryBo();
        BeanUtils.copyProperties((Object)query, (Object)resourceQueryBo);
        for (String sheetName : sheetNames) {
            Page<ResourceServiceApiDTO> page;
            if ("\u8d44\u6e90\u7801".equals(sheetName)) {
                Page<ResourceDTO> page2;
                PageRequest pageable = PageRequest.of((int)0, (int)1000, (Sort)sort.and(Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"createTime"})));
                do {
                    page2 = this.resourceService.pagingBy((Pageable)pageable, resourceQueryBo);
                    Page excelPage = page2.map(e -> {
                        ResourceExcelDTO dto = new ResourceExcelDTO();
                        dto.setAppId(e.getAppId() == null ? "" : String.valueOf(e.getAppId()));
                        dto.setResourceName(StringUtils.trimToEmpty((String)e.getResourceName()));
                        dto.setResourceCode(StringUtils.trimToEmpty((String)e.getResourceCode()));
                        dto.setParentResourceCode(StringUtils.trimToEmpty((String)e.getParentCode()));
                        return dto;
                    });
                    simpleExcelWriter.fill(sheetName, excelPage.getContent());
                } while (page2.hasNext() && (pageable = pageable.next()) != null && page2.getNumber() < maxPageSize);
                simpleExcelWriter.param("SUCCESS_SIZE", this.calcSuccessSize(page2));
                continue;
            }
            if (!"\u670d\u52a1API".equals(sheetName)) continue;
            Map<Long, String> routeMap = this.findRouteList();
            PageRequest pageable = PageRequest.of((int)0, (int)1000, (Sort)sort.and(Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"createTime"})));
            do {
                page = this.resourceService.pagingByServiceApi((Pageable)pageable, resourceQueryBo);
                Page configPageDTO = page.map(e -> {
                    ServiceApiExcelDTO dto = new ServiceApiExcelDTO();
                    dto.setServiceApiName(StringUtils.trimToEmpty((String)e.getServiceApiName()));
                    dto.setPath(this.getRoutePath(routeMap, e.getRouteId()));
                    dto.setServiceApiUrl(StringUtils.trimToEmpty((String)e.getServiceApiUrl()));
                    dto.setAppId(e.getAppId() == null ? "" : String.valueOf(e.getAppId()));
                    dto.setServiceApiPath((String)StringUtils.defaultIfEmpty((CharSequence)e.getServiceApiPath(), (CharSequence)""));
                    dto.setRequestMethod(StringUtils.trimToEmpty((String)e.getRequestMethod()));
                    dto.setResourceCode(StringUtils.trimToEmpty((String)e.getResourceCode()));
                    return dto;
                });
                simpleExcelWriter.fill(sheetName, configPageDTO.getContent());
            } while (page.hasNext() && (pageable = pageable.next()) != null && page.getNumber() < maxPageSize);
            simpleExcelWriter.param("SUCCESS_SIZE", this.calcSuccessSize(page));
        }
    }

    private String getRoutePath(Map<Long, String> routeMap, Long routeId) {
        if (routeMap.containsKey(routeId)) {
            return StringUtils.trimToEmpty((String)routeMap.get(routeId));
        }
        return "";
    }

    private Map<Long, String> findRouteList() {
        List<ServiceApiRouterDTO> routerDTOList = this.resourceService.findRouteList();
        if (CollectionUtils.isEmpty(routerDTOList)) {
            return Collections.emptyMap();
        }
        return routerDTOList.stream().collect(Collectors.toMap(ServiceApiRouterDTO::getRouteId, ServiceApiRouterDTO::getPath));
    }

    @Transactional(rollbackFor={RuntimeException.class})
    public void unbindServiceApiResourceRel(long serviceApiId, long resourceId) {
        this.resourceApiRelDao.deleteByServiceApiIdAndResourceId(serviceApiId, resourceId);
    }

    public List<ResourceApiRel> findResourceApiRelByServiceApiId(Long serviceApiId) {
        return this.resourceApiRelDao.findByServiceApiId(serviceApiId);
    }

    public ServiceApi findServiceApiById(Long id) {
        return (ServiceApi)this.serviceApiDao.findById((Object)id).orElseThrow(() -> new IllegalArgumentException("\u672a\u627e\u5230\u5b9e\u4f53"));
    }

    @Transactional(rollbackFor={RuntimeException.class})
    public void bindResources(long id, ServiceApiModel.Request.BindResources bindResources) {
        ServiceApi serviceApi = this.findServiceApiById(id);
        this.bindResources(serviceApi, bindResources);
    }

    @Transactional(rollbackFor={RuntimeException.class})
    public void bindResources(ServiceApi serviceApi, ServiceApiModel.Request.BindResources bindResources) {
        if (bindResources == null) {
            return;
        }
        List resourceIds = bindResources.getResourceIds();
        if (resourceIds == null) {
            return;
        }
        log.info("resourceIds = " + resourceIds.stream().filter(Objects::nonNull).map(Object::toString).collect(Collectors.joining(",")));
        List existRels = this.resourceApiRelDao.findByServiceApiId(serviceApi.getServiceApiId());
        log.info("exist api-resource-rels.size = " + existRels.size());
        Set<ResourceApiRel> insertingRels = resourceIds.stream().filter(resourceId -> existRels.stream().map(ResourceApiRel::getResourceId).noneMatch(existId -> existId.equals(resourceId))).map(resourceId -> {
            Optional resourceOptional = this.resourceDao.findById(resourceId);
            if (resourceOptional.isPresent()) {
                ResourceApiRel rel = new ResourceApiRel();
                rel.setResourceId(resourceId);
                rel.setServiceApiId(serviceApi.getServiceApiId());
                return rel;
            }
            return null;
        }).filter(Objects::nonNull).collect(Collectors.toSet());
        this.bindResources(insertingRels);
        if (bindResources.isOverwrite()) {
            existRels.stream().filter(rel -> resourceIds.stream().noneMatch(resourceId -> resourceId.equals(rel.getResourceId()))).forEach(rel -> {
                log.info("deleting Resource-Api-Rel record, {}", rel);
                this.resourceApiRelDao.deleteById(rel.getId());
            });
        }
    }

    @Transactional(rollbackFor={RuntimeException.class})
    public void bindResources(Collection<ResourceApiRel> rels) {
        if (!rels.isEmpty()) {
            rels.forEach(arg_0 -> ((ResourceApiRelDao)this.resourceApiRelDao).saveAndFlush(arg_0));
        }
    }

    protected static final class Message {
        public static final String RESOURCE_NOT_FIND = "\u8d44\u6e90\u7801\u6570\u636e\u672a\u627e\u5230";

        protected Message() {
        }
    }
}

