/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.business.resource.service;

import com.xforceplus.business.resource.service.ResourceService;
import com.xforceplus.business.resource.service.ServiceApiService;
import com.xforceplus.dao.AppDao;
import com.xforceplus.dao.ResourceApiRelDao;
import com.xforceplus.dao.ResourceDao;
import com.xforceplus.dao.ServiceApiDao;
import com.xforceplus.domain.resource.ResourceDto;
import com.xforceplus.domain.resource.ResourceExtendDto;
import com.xforceplus.domain.resource.ServiceApiExtendDto;
import com.xforceplus.entity.Resource;
import com.xforceplus.entity.ResourceApiRel;
import com.xforceplus.entity.ServiceApi;
import com.xforceplus.utils.ApiUtils;
import com.xforceplus.utils.excel.QueryUtils;
import com.xforceplus.utils.excel.ResourceWrapper;
import io.geewit.core.utils.reflection.BeanUtils;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;

@Service
public class ResourcePortService {
    private static final Logger log = LoggerFactory.getLogger(ResourcePortService.class);
    @Autowired
    private ResourceService resourceService;
    @Autowired
    private ResourceApiRelDao resourceApiRelDao;
    @Autowired
    private ServiceApiDao serviceApiDao;
    @Autowired
    private ServiceApiService serviceApiService;
    @Autowired
    private ResourceDao resourceDao;
    @Autowired
    private AppDao appDao;
    private String operateUserName = "\u624b\u52a8\u5bfc\u5165";

    public List<ResourceExtendDto> getExportData(List<Long> resourceIds) {
        ResourceExtendDto resourceExtendDto;
        Specification specification = QueryUtils.getSpecification("resourceId", resourceIds);
        List<Resource> list = this.resourceService.list((Specification<Resource>)specification, Sort.unsorted());
        if (list.isEmpty()) {
            throw new IllegalArgumentException("\u6240\u9009id\u8bb0\u5f55\u4e0d\u5b58\u5728\u3002");
        }
        List parentIds = list.stream().filter(p -> this.isSubResource(p.getParentId())).map(p -> p.getParentId()).collect(Collectors.toList());
        List<Object> parentList = new ArrayList();
        if (CollectionUtils.isNotEmpty(parentIds)) {
            Specification specification2 = QueryUtils.getSpecification("resourceId", parentIds);
            parentList = this.resourceService.list((Specification<Resource>)specification2, Sort.unsorted());
        }
        ArrayList<ResourceExtendDto> extendList = new ArrayList<ResourceExtendDto>(list.size() + parentList.size());
        Map<Long, Integer> map = this.getParentMap(parentList);
        for (ResourceDto resourceDto : list) {
            Integer resourceId;
            if (this.isSubResource(resourceDto.getParentId()) || (resourceId = map.get(resourceDto.getResourceId())) != null) continue;
            ResourceExtendDto resourceExtendDto2 = new ResourceExtendDto();
            BeanUtils.copyProperties((Object)resourceDto, (Object)resourceExtendDto2);
            extendList.add(resourceExtendDto2);
        }
        for (ResourceDto resourceDto : parentList) {
            resourceExtendDto = new ResourceExtendDto();
            BeanUtils.copyProperties((Object)resourceDto, (Object)resourceExtendDto);
            extendList.add(resourceExtendDto);
        }
        map = this.getParentMap(extendList);
        for (Resource resource : list) {
            if (!this.isSubResource(resource.getParentId())) continue;
            resourceExtendDto = new ResourceExtendDto();
            BeanUtils.copyProperties((Object)resource, (Object)resourceExtendDto);
            Integer parentResourceIndex = map.get(resource.getParentId());
            if (parentResourceIndex != null) {
                resourceExtendDto.setParentResourceIndex(Integer.valueOf(parentResourceIndex + 1));
            }
            extendList.add(resourceExtendDto);
        }
        return extendList;
    }

    public List<ResourceExtendDto> getExportDataByAppId(final Long appId) {
        List list = this.resourceDao.findAll((Specification)new Specification<Resource>(){

            public Predicate toPredicate(Root<Resource> root, CriteriaQuery<?> query, CriteriaBuilder builder) {
                ArrayList<Predicate> predicates = new ArrayList<Predicate>();
                predicates.add(builder.equal((Expression)root.get("appId"), (Object)appId));
                if (!predicates.isEmpty()) {
                    query.where((Predicate[])predicates.stream().toArray(Predicate[]::new));
                }
                return query.getRestriction();
            }
        }, Sort.unsorted());
        if (list.isEmpty()) {
            throw new IllegalArgumentException("\u8be5appId\u4e0b\u6ca1\u6709\u8d44\u6e90\u7801\u3002");
        }
        ArrayList<ResourceExtendDto> extendList = new ArrayList<ResourceExtendDto>(list.size());
        for (Resource resource : list) {
            ResourceExtendDto resourceExtendDto = new ResourceExtendDto();
            BeanUtils.copyProperties((Object)resource, (Object)resourceExtendDto);
            extendList.add(resourceExtendDto);
        }
        return extendList;
    }

    private boolean isSubResource(Long parentId) {
        return parentId != null && parentId > 0L;
    }

    private <T extends ResourceDto> Map<Long, Integer> getParentMap(List<T> list) {
        HashMap<Long, Integer> map = new HashMap<Long, Integer>(list.size());
        if (list.isEmpty()) {
            return map;
        }
        for (int i = 0; i < list.size(); ++i) {
            ResourceDto resource = (ResourceDto)list.get(i);
            map.put(resource.getResourceId(), i);
        }
        return map;
    }

    public ResourceWrapper saveResourceData(ResourceWrapper wrapper) {
        ResourceWrapper result = new ResourceWrapper();
        List<ResourceExtendDto> resource = this.saveResource(wrapper.getResources());
        List<ServiceApiExtendDto> serviceApi = this.saveServiceApi(wrapper.getResources(), wrapper.getServiceApis());
        result.setResources(resource);
        result.setServiceApis(serviceApi);
        return result;
    }

    private List<ServiceApiExtendDto> saveServiceApi(List<ResourceExtendDto> resources, List<ServiceApiExtendDto> serviceApis) {
        ArrayList<ServiceApiExtendDto> exists = new ArrayList<ServiceApiExtendDto>();
        for (ServiceApiExtendDto item : serviceApis) {
            String hash = ApiUtils.hash((String)item.getServiceApiUrl(), (String)item.getRequestMethod().name(), (Long)item.getRouteId());
            List list = this.serviceApiDao.findByHash(hash);
            ServiceApi serviceApi = list.isEmpty() ? this.saveServiceApi(item) : (ServiceApi)list.get(0);
            boolean result = this.serviceApiService.saveResourceApiRel(resources.get(item.getRelResourceIndex() - 1).getResourceId(), serviceApi.getServiceApiId(), this.operateUserName);
            if (result) continue;
            item.setReason("\u8be5api\u5df2\u7ecf\u5b58\u5728\u5e76\u4e14\u8ddf\u8d44\u6e90\u7801\u5173\u8054\u3002");
            exists.add(item);
        }
        return exists;
    }

    public List<ResourceExtendDto> saveResource(List<ResourceExtendDto> resources) {
        ArrayList<ResourceExtendDto> outResources = new ArrayList<ResourceExtendDto>();
        List<String> resourceCodes = resources.stream().map(ResourceDto::getResourceCode).collect(Collectors.toList());
        List<Resource> existsResources = this.getResourceByCodes(resourceCodes);
        HashMap<String, Resource> existsMap = new HashMap<String, Resource>(existsResources.size());
        for (Resource resource : existsResources) {
            existsMap.put(this.getResourceCodeKey(resource.getResourceCode(), resource.getAppId()), resource);
        }
        for (ResourceExtendDto item : resources) {
            if (null == item.getAppId() || !this.appDao.existsById((Object)item.getAppId())) {
                item.setReason("\u65e0\u6548\u7684appId\u3002");
                outResources.add(item);
                continue;
            }
            Resource resource = (Resource)existsMap.get(this.getResourceCodeKey(item.getResourceCode(), item.getAppId()));
            if (item.getParentResourceIndex() != null) {
                item.setParentId(resources.get(item.getParentResourceIndex() - 1).getResourceId());
            } else {
                item.setParentId(Long.valueOf(0L));
            }
            if (resource == null) {
                resource = this.saveResource(item);
            } else {
                if (this.isSubResource(item.getParentId())) {
                    resource.setParentId(item.getParentId());
                    this.saveResource(resource);
                }
                item.setReason("\u8be5\u8d44\u6e90\u7801\u5df2\u7ecf\u5b58\u5728\u3002");
                outResources.add(item);
            }
            item.setResourceId(resource.getResourceId());
        }
        return outResources;
    }

    private String getResourceCodeKey(String resourceCode, Long appId) {
        String appIdStr = appId == null ? "" : String.valueOf(appId);
        return resourceCode + "_" + appIdStr;
    }

    public List<Resource> getResourceByCodes(List<String> resourceCodes) {
        Specification specification = QueryUtils.getSpecification("resourceCode", resourceCodes);
        return this.resourceService.list((Specification<Resource>)specification, Sort.unsorted());
    }

    public List<ServiceApiExtendDto> getServiceApiData(List<ResourceExtendDto> extendList) {
        if (CollectionUtils.isEmpty(extendList)) {
            return new ArrayList<ServiceApiExtendDto>();
        }
        List resourceIds = extendList.stream().map(ResourceDto::getResourceId).collect(Collectors.toList());
        Specification specification = QueryUtils.getSpecification("resourceId", resourceIds);
        List resourceApiRels = this.resourceApiRelDao.findAll(specification, Sort.unsorted());
        if (CollectionUtils.isEmpty((Collection)resourceApiRels)) {
            log.info("CollectionUtils.isEmpty(resourceApiRels)");
            return new ArrayList<ServiceApiExtendDto>();
        }
        Map<Long, Integer> idAndIndexMap = this.getResourceIdAndIndexMap(extendList);
        Map<Long, Integer> serviceApiIdAndIndexId = this.getServiceApiIdAndIndexId(resourceApiRels, idAndIndexMap);
        List serviceApiId = resourceApiRels.stream().map(ResourceApiRel::getServiceApiId).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(serviceApiId)) {
            log.info("CollectionUtils.isEmpty(serviceApiId)");
            return new ArrayList<ServiceApiExtendDto>();
        }
        Specification specification2 = QueryUtils.getSpecification("serviceApiId", serviceApiId);
        List serviceApiList = this.serviceApiDao.findAll(specification2, Sort.unsorted());
        ArrayList<ServiceApiExtendDto> result = new ArrayList<ServiceApiExtendDto>(serviceApiList.size());
        HashSet<String> keySets = new HashSet<String>(serviceApiList.size());
        for (ServiceApi serviceApi : serviceApiList) {
            String uniqueKey = serviceApi.getServiceApiUrl() + serviceApi.getRequestMethod();
            if (serviceApi.getRouteId() != null && serviceApi.getRouteId() > 0L) {
                uniqueKey = uniqueKey + String.valueOf(serviceApi.getRouteId());
            }
            if (keySets.contains(uniqueKey)) {
                log.info("continue uniqueKey=={}", (Object)uniqueKey);
                continue;
            }
            keySets.add(uniqueKey);
            ServiceApiExtendDto serviceApiExtendDto = new ServiceApiExtendDto();
            BeanUtils.copyProperties((Object)serviceApi, (Object)serviceApiExtendDto);
            Integer resourceIndex = serviceApiIdAndIndexId.get(serviceApi.getServiceApiId());
            serviceApiExtendDto.setRelResourceIndex(resourceIndex);
            result.add(serviceApiExtendDto);
        }
        return result;
    }

    private Map<Long, Integer> getResourceIdAndIndexMap(List<ResourceExtendDto> list) {
        HashMap<Long, Integer> map = new HashMap<Long, Integer>(list.size());
        if (list.isEmpty()) {
            return map;
        }
        for (int i = 0; i < list.size(); ++i) {
            ResourceExtendDto resourceDto = list.get(i);
            map.put(resourceDto.getResourceId(), i + 1);
        }
        return map;
    }

    private Map<Long, Integer> getServiceApiIdAndIndexId(List<ResourceApiRel> list, Map<Long, Integer> resourceAndIndexMap) {
        HashMap<Long, Integer> map = new HashMap<Long, Integer>(list.size());
        if (list.isEmpty()) {
            return map;
        }
        for (ResourceApiRel item : list) {
            Integer index = resourceAndIndexMap.get(item.getResourceId());
            map.put(item.getServiceApiId(), index);
        }
        return map;
    }

    public <T extends ResourceDto> Resource saveResource(T model) {
        Resource entity = new Resource();
        BeanUtils.copyProperties(model, (Object)entity, (String[])((String[])Stream.of("children").toArray(String[]::new)));
        Date now = Calendar.getInstance().getTime();
        if (entity.getResourceId() == null) {
            entity.setCreaterName(this.operateUserName);
            entity.setCreateTime(now);
        }
        entity.setUpdaterName(this.operateUserName);
        entity.setUpdateTime(now);
        return (Resource)this.resourceDao.saveAndFlush((Object)entity);
    }

    private ServiceApi saveServiceApi(ServiceApiExtendDto item) {
        ServiceApi entity = new ServiceApi();
        BeanUtils.copyProperties((Object)item, (Object)entity);
        Date now = Calendar.getInstance().getTime();
        if (entity.getServiceApiId() == null) {
            entity.setCreaterName(this.operateUserName);
            entity.setCreateTime(now);
        }
        entity.setUpdaterName(this.operateUserName);
        entity.setUpdateTime(now);
        return (ServiceApi)this.serviceApiDao.saveAndFlush((Object)entity);
    }

    public Map<String, Object> getYamlMapByResources(List<ResourceExtendDto> resourceList) {
        HashMap<Long, ResourceExtendDto> resourceIdAndItem = new HashMap<Long, ResourceExtendDto>();
        HashMap<Long, List> parentIdAndItem = new HashMap<Long, List>();
        if (CollectionUtils.isEmpty(resourceList)) {
            return null;
        }
        for (ResourceExtendDto item : resourceList) {
            resourceIdAndItem.put(item.getResourceId(), item);
            if (item.getParentId() == null || item.getParentId() <= 0L) continue;
            List children = parentIdAndItem.computeIfAbsent(item.getParentId(), k -> new ArrayList());
            children.add(item);
        }
        HashMap<String, Object> rootMap = new HashMap<String, Object>(parentIdAndItem.size());
        for (ResourceExtendDto resourceExtendDto : resourceList) {
            HashMap<String, Object> resourceMap = new HashMap<String, Object>(parentIdAndItem.size());
            resourceMap.put("name", resourceExtendDto.getResourceName());
            List children = (List)parentIdAndItem.get(resourceExtendDto.getResourceId());
            if (CollectionUtils.isNotEmpty((Collection)children)) {
                for (Object item : children) {
                    ResourceExtendDto child = (ResourceExtendDto)item;
                    HashMap<String, String> childNameMap = new HashMap<String, String>();
                    childNameMap.put("name", child.getResourceName());
                    resourceMap.put(child.getResourceCode(), childNameMap);
                }
            }
            if (resourceExtendDto.getParentId() != null && resourceExtendDto.getParentId() > 0L) continue;
            rootMap.put(resourceExtendDto.getResourceCode(), resourceMap);
        }
        return rootMap;
    }
}

