/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.business.resource.service;

import com.alibaba.excel.event.AnalysisEventListener;
import com.xforceplus.api.model.ResourceModel;
import com.xforceplus.api.model.ResourcesetModel;
import com.xforceplus.bo.ResourceSetQueryBo;
import com.xforceplus.business.app.service.AppService;
import com.xforceplus.business.excel.BusinessType;
import com.xforceplus.business.excel.ExcelSheet;
import com.xforceplus.business.excel.SimpleExcelWriter;
import com.xforceplus.business.excel.reader.Context;
import com.xforceplus.business.excel.reader.MessageRow;
import com.xforceplus.business.excel.reader.SimpleDataReadListener;
import com.xforceplus.business.excel.writer.ExcelConfigBusinessType;
import com.xforceplus.business.resource.dto.ResourceSetExcelDTO;
import com.xforceplus.business.resource.dto.ResourceSetResourceExcelDTO;
import com.xforceplus.business.resource.service.ResourceExcelServiceImpl;
import com.xforceplus.business.resource.service.ResourceService;
import com.xforceplus.business.resource.service.ResourcesetService;
import com.xforceplus.business.service.ExcelReaderService;
import com.xforceplus.business.service.ExcelWriteService;
import com.xforceplus.dto.resource.ResourceSetDTO;
import com.xforceplus.entity.App;
import com.xforceplus.entity.Resource;
import com.xforceplus.entity.Resourceset;
import io.geewit.core.utils.reflection.BeanUtils;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.NumberUtils;

@Service
public class ResourceSetExcelExportServiceImpl
implements ExcelWriteService,
ExcelReaderService {
    private static final Logger log = LoggerFactory.getLogger(ResourceExcelServiceImpl.class);
    private final ResourcesetService resourcesetService;
    private final ResourceService resourceService;
    private final AppService appService;

    public ResourceSetExcelExportServiceImpl(ResourcesetService resourcesetService, ResourceService resourceService, AppService appService) {
        this.resourcesetService = resourcesetService;
        this.resourceService = resourceService;
        this.appService = appService;
    }

    @Override
    public BusinessType getBusinessType() {
        return ExcelConfigBusinessType.RESOURCE_SET_EXCEL_FILE;
    }

    @Override
    public Context importExcel(Context context) {
        List<ExcelSheet> sheets = context.getExcelBook().getExcelSheets();
        for (ExcelSheet sheet : sheets) {
            MessageRow messageRows;
            String sheetName = sheet.getSheetName();
            if ("\u529f\u80fd\u96c6".equals(sheetName)) {
                messageRows = new MessageRow(sheetName);
                List<Long> appIds = this.findAllByApp();
                AnalysisEventListener excelDataListener = SimpleDataReadListener.listener(context, rows -> this.saveResourceSets(messageRows, context, (List<ResourceSetExcelDTO>)rows, appIds));
                context.getSimpleExcelReader().read(ResourceSetExcelDTO.class, excelDataListener, sheetName);
                continue;
            }
            if (!"\u8d44\u6e90\u7801".equals(sheetName)) continue;
            messageRows = new MessageRow(sheetName);
            AnalysisEventListener excelDataListener = SimpleDataReadListener.listener(context, rows -> this.saveResourceSetResource(messageRows, context, (List<ResourceSetResourceExcelDTO>)rows));
            context.getSimpleExcelReader().read(ResourceSetResourceExcelDTO.class, excelDataListener, sheetName);
        }
        return context;
    }

    private void saveResourceSetResource(MessageRow messageRows, Context context, List<ResourceSetResourceExcelDTO> rows) {
        if (CollectionUtils.isEmpty(rows)) {
            return;
        }
        for (ResourceSetResourceExcelDTO row : rows) {
            try {
                if (!row.getValidatedStatus().booleanValue()) {
                    messageRows.fail(row.getRowIndex(), row.getValidatedMessage());
                    continue;
                }
                if ("\u7ed1\u5b9a".equals(row.getAction())) {
                    this.bindResources(messageRows, row);
                    continue;
                }
                if (!"\u89e3\u7ed1".equals(row.getAction())) continue;
                this.unBindResources(messageRows, row);
            }
            catch (Exception ex) {
                log.error(ex.getMessage(), (Throwable)ex);
                messageRows.fail(row.getRowIndex(), row.getAction() + "\u6570\u636e\u5931\u8d25");
            }
        }
        context.messageRow(messageRows.getSheetName(), messageRows);
    }

    private void unBindResources(MessageRow messageRows, ResourceSetResourceExcelDTO row) {
        Optional<Resourceset> resourceSetOptional;
        String resourceSetCode = StringUtils.trimToEmpty((String)row.getResourceSetCode());
        String resourceCode = StringUtils.trimToEmpty((String)row.getResourceCode());
        try {
            resourceSetOptional = this.findByResourceSetCode(resourceSetCode);
            if (!resourceSetOptional.isPresent()) {
                messageRows.fail(row.getRowIndex(), "\u3010" + resourceSetCode + "\u3011" + "\u529f\u80fd\u96c6\u6570\u636e\u4e0d\u5b58\u5728");
                return;
            }
        }
        catch (IllegalArgumentException e) {
            messageRows.fail(row.getRowIndex(), "\u89e3\u7ed1" + e.getMessage());
            return;
        }
        Resourceset resourceSet = resourceSetOptional.get();
        Long appId = resourceSet.getAppId();
        Optional<Resource> resource = this.findResourceByCodeAppId(appId, resourceCode);
        if (!resource.isPresent()) {
            messageRows.fail(row.getRowIndex(), "\u3010" + resourceCode + "\u3011" + "\u8d44\u6e90\u7801\u6570\u636e\u4e0d\u5b58\u5728");
            return;
        }
        try {
            this.resourcesetService.unbindResources(resourceSet.getResourcesetId(), resource.get().getResourceId());
            messageRows.success(row.getRowIndex());
        }
        catch (IllegalArgumentException e) {
            messageRows.fail(row.getRowIndex(), "\u89e3\u7ed1" + e.getMessage());
        }
    }

    private void bindResources(MessageRow messageRows, ResourceSetResourceExcelDTO row) {
        Optional<Resourceset> resourceSetOptional;
        String resourceSetCode = StringUtils.trimToEmpty((String)row.getResourceSetCode());
        String resourceCode = StringUtils.trimToEmpty((String)row.getResourceCode());
        try {
            resourceSetOptional = this.findByResourceSetCode(resourceSetCode);
            if (!resourceSetOptional.isPresent()) {
                messageRows.fail(row.getRowIndex(), "\u3010" + resourceSetCode + "\u3011" + "\u529f\u80fd\u96c6\u6570\u636e\u4e0d\u5b58\u5728");
                return;
            }
        }
        catch (IllegalArgumentException e) {
            messageRows.fail(row.getRowIndex(), "\u7ed1\u5b9a" + e.getMessage());
            return;
        }
        Resourceset resourceSet = resourceSetOptional.get();
        Long appId = resourceSet.getAppId();
        Optional<Resource> resource = this.findResourceByCodeAppId(appId, resourceCode);
        if (!resource.isPresent()) {
            messageRows.fail(row.getRowIndex(), "\u3010" + resourceCode + "\u3011" + "\u8d44\u6e90\u7801\u6570\u636e\u4e0d\u5b58\u5728");
            return;
        }
        ResourcesetModel.Request.BindResources bindResources = new ResourcesetModel.Request.BindResources();
        bindResources.setOverwrite(false);
        bindResources.setResourceIds(Arrays.asList(resource.get().getResourceId()));
        try {
            this.resourcesetService.bindResources(resourceSet, bindResources);
            messageRows.success(row.getRowIndex());
        }
        catch (Exception e) {
            messageRows.fail(row.getRowIndex(), "\u7ed1\u5b9a" + e.getMessage());
        }
    }

    private Optional<Resourceset> findByResourceSetCode(String resourceSetCode) {
        return this.resourcesetService.findByResourceSetCode(resourceSetCode);
    }

    private Optional<Resource> findResourceByCodeAppId(Long appId, String resourceCode) {
        ResourceModel.Request.Query query = new ResourceModel.Request.Query();
        query.setAppId(appId);
        query.setResourceCode(resourceCode);
        return this.resourceService.findOne(query);
    }

    private void saveResourceSets(MessageRow messageRows, Context context, List<ResourceSetExcelDTO> rows, List<Long> appIds) {
        if (CollectionUtils.isEmpty(rows)) {
            return;
        }
        for (ResourceSetExcelDTO row : rows) {
            try {
                if (!row.getValidatedStatus().booleanValue()) {
                    messageRows.fail(row.getRowIndex(), row.getValidatedMessage());
                    continue;
                }
                if ("\u65b0\u589e".equals(row.getAction())) {
                    this.saveResourceSet(messageRows, row, appIds);
                    continue;
                }
                if (!"\u4fee\u6539".equals(row.getAction())) continue;
                this.updateResourceSet(messageRows, row, appIds);
            }
            catch (Exception ex) {
                log.error(ex.getMessage(), (Throwable)ex);
                messageRows.fail(row.getRowIndex(), row.getAction() + "\u6570\u636e\u5931\u8d25");
            }
        }
        context.messageRow(messageRows.getSheetName(), messageRows);
    }

    private void updateResourceSet(MessageRow messageRows, ResourceSetExcelDTO row, List<Long> appIds) {
        Optional<Resourceset> resourceSetOptional;
        String resourceSetCode = StringUtils.trimToEmpty((String)row.getResourceSetCode());
        Integer status = (Integer)NumberUtils.parseNumber((String)row.getStatus(), Integer.class);
        try {
            resourceSetOptional = this.findByResourceSetCode(resourceSetCode);
            if (!resourceSetOptional.isPresent()) {
                messageRows.fail(row.getRowIndex(), "\u3010" + resourceSetCode + "\u3011" + "\u529f\u80fd\u96c6\u6570\u636e\u4e0d\u5b58\u5728");
                return;
            }
        }
        catch (IllegalArgumentException e) {
            messageRows.fail(row.getRowIndex(), "\u66f4\u65b0" + e.getMessage());
            return;
        }
        Long appId = (Long)NumberUtils.parseNumber((String)row.getAppId(), Long.class);
        if (!appIds.contains(appId)) {
            messageRows.fail(row.getRowIndex(), "\u3010" + appId + "\u3011APP\u7684\u6570\u636e\u4e0d\u5b58\u5728");
            return;
        }
        ResourcesetModel.Request.Save resourceSet = new ResourcesetModel.Request.Save();
        resourceSet.setAppId(appId);
        resourceSet.setResourcesetCode(resourceSetCode);
        resourceSet.setResourcesetName(row.getResourceSetName());
        resourceSet.setResourcesetDesc(resourceSetOptional.get().getResourcesetDesc());
        resourceSet.setStatus(status);
        try {
            this.resourcesetService.update(resourceSetOptional.get().getResourcesetId(), resourceSet);
            messageRows.success(row.getRowIndex());
        }
        catch (Exception e) {
            messageRows.fail(row.getRowIndex(), e.getMessage());
        }
    }

    private void saveResourceSet(MessageRow messageRows, ResourceSetExcelDTO row, List<Long> appIds) {
        String resourceSetCode = StringUtils.trimToEmpty((String)row.getResourceSetCode());
        Integer status = (Integer)NumberUtils.parseNumber((String)row.getStatus(), Integer.class);
        try {
            Optional<Resourceset> resourceSetOptional = this.findByResourceSetCode(resourceSetCode);
            if (resourceSetOptional.isPresent()) {
                messageRows.fail(row.getRowIndex(), "\u3010" + resourceSetCode + "\u3011" + "\u529f\u80fd\u96c6\u6570\u636e\u5df2\u5b58\u5728");
                return;
            }
        }
        catch (IllegalArgumentException e) {
            messageRows.fail(row.getRowIndex(), "\u4fdd\u5b58" + e.getMessage());
            return;
        }
        Long appId = (Long)NumberUtils.parseNumber((String)row.getAppId(), Long.class);
        if (!appIds.contains(appId)) {
            messageRows.fail(row.getRowIndex(), "\u3010" + appId + "\u3011APP\u7684\u6570\u636e\u4e0d\u5b58\u5728");
            return;
        }
        ResourcesetModel.Request.Create resourceSet = new ResourcesetModel.Request.Create();
        resourceSet.setAppId(appId);
        resourceSet.setResourcesetCode(resourceSetCode);
        resourceSet.setResourcesetName(row.getResourceSetName());
        resourceSet.setResourcesetDesc(row.getResourceSetName());
        resourceSet.setStatus(status);
        try {
            this.resourcesetService.create(resourceSet);
            messageRows.success(row.getRowIndex());
        }
        catch (Exception e) {
            messageRows.fail(row.getRowIndex(), e.getMessage());
        }
    }

    private List<Long> findAllByApp() {
        List<App> appList = this.appService.list();
        if (CollectionUtils.isEmpty(appList)) {
            return Collections.emptyList();
        }
        return appList.stream().map(App::getAppId).collect(Collectors.toList());
    }

    @Override
    public void write(Context context) {
        ResourcesetModel.Request.Query query = context.getParam("P_QUERY", ResourcesetModel.Request.Query.class);
        Sort sort = context.getParam("P_SORT", Sort.class);
        List<String> sheetNames = Arrays.asList(query.getSheets());
        SimpleExcelWriter simpleExcelWriter = context.getSimpleExcelWriter();
        Integer maxPageSize = context.getMaxPageSize();
        ResourceSetQueryBo queryBo = new ResourceSetQueryBo();
        BeanUtils.copyProperties((Object)query, (Object)queryBo);
        queryBo.setResourceSetIds(query.getResourcesetIds());
        for (String sheetName : sheetNames) {
            Page excelDTOPage;
            Page<ResourceSetDTO> page;
            PageRequest pageable;
            if ("\u529f\u80fd\u96c6".equals(sheetName)) {
                pageable = PageRequest.of((int)0, (int)1000, (Sort)sort.and(Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"createTime"})));
                do {
                    page = this.resourcesetService.pagingBy((Pageable)pageable, queryBo);
                    excelDTOPage = page.map(e -> {
                        ResourceSetExcelDTO dto = new ResourceSetExcelDTO();
                        dto.setAppId(e.getAppId() == null ? "" : String.valueOf(e.getAppId()));
                        dto.setResourceSetName(StringUtils.trimToEmpty((String)e.getResourceSetName()));
                        dto.setResourceSetCode(StringUtils.trimToEmpty((String)e.getResourceSetCode()));
                        dto.setStatus(e.getStatus() == null ? "" : String.valueOf(e.getStatus()));
                        return dto;
                    });
                    simpleExcelWriter.fill(sheetName, excelDTOPage.getContent());
                } while (page.hasNext() && (pageable = pageable.next()) != null && page.getNumber() < maxPageSize);
                simpleExcelWriter.param("SUCCESS_SIZE", this.calcSuccessSize(page));
            }
            if (!"\u8d44\u6e90\u7801".equals(sheetName)) continue;
            pageable = PageRequest.of((int)0, (int)1000, (Sort)sort.and(Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"createTime"})));
            do {
                page = this.resourcesetService.pagingByResource((Pageable)pageable, queryBo);
                excelDTOPage = page.map(e -> {
                    ResourceSetResourceExcelDTO dto = new ResourceSetResourceExcelDTO();
                    dto.setResourceSetCode(StringUtils.trimToEmpty((String)e.getResourceSetCode()));
                    dto.setResourceCode(StringUtils.trimToEmpty((String)e.getResourceCode()));
                    return dto;
                });
                simpleExcelWriter.fill(sheetName, excelDTOPage.getContent());
            } while (page.hasNext() && (pageable = pageable.next()) != null && page.getNumber() < maxPageSize);
            simpleExcelWriter.param("SUCCESS_SIZE", this.calcSuccessSize(page));
        }
    }

    protected static final class Message {
        public static final String RESOURCE_SET_NOT_NULL = "\u529f\u80fd\u96c6\u6570\u636e\u4e0d\u5b58\u5728";
        public static final String RESOURCE_NOT_NULL = "\u8d44\u6e90\u7801\u6570\u636e\u4e0d\u5b58\u5728";
        public static final String RESOURCE_SET_NULL = "\u529f\u80fd\u96c6\u6570\u636e\u5df2\u5b58\u5728";

        protected Message() {
        }
    }
}

