/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.business.resource.service;

import com.google.common.collect.Lists;
import com.xforceplus.business.resource.service.ResourcePortService;
import com.xforceplus.business.resource.service.ResourceService;
import com.xforceplus.business.resource.service.ResourcesetService;
import com.xforceplus.dao.AppDao;
import com.xforceplus.dao.ResourcesetResourceRelDao;
import com.xforceplus.domain.resource.ResourceDto;
import com.xforceplus.domain.resource.ResourceExtendDto;
import com.xforceplus.domain.resource.ResourcesetDto;
import com.xforceplus.domain.resource.ResourcesetExtendDto;
import com.xforceplus.entity.Resource;
import com.xforceplus.entity.Resourceset;
import com.xforceplus.entity.ResourcesetResourceRel;
import com.xforceplus.utils.excel.QueryUtils;
import com.xforceplus.utils.excel.ResourcesetWrapper;
import io.geewit.core.utils.reflection.BeanUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;

@Service
public class ResourcesetPortService {
    private static final Logger log = LoggerFactory.getLogger(ResourcesetPortService.class);
    @Autowired
    private ResourceService resourceService;
    @Autowired
    private ResourcesetResourceRelDao resourcesetResourceRelDao;
    @Autowired
    private ResourcesetService resourcesetService;
    @Autowired
    private ResourcePortService resourcePortService;
    @Autowired
    private AppDao appDao;
    private String operateUserName = "\u624b\u52a8\u5bfc\u5165";

    public ResourcesetWrapper getExportData(List<Long> resourcesetIds) {
        List<ResourceExtendDto> childResources;
        Specification specification = QueryUtils.getSpecification("resourcesetId", resourcesetIds);
        List<Resourceset> list = this.resourcesetService.list((Specification<Resourceset>)specification, Sort.unsorted());
        if (CollectionUtils.isEmpty(list)) {
            throw new IllegalArgumentException("\u6240\u9009id\u8bb0\u5f55\u4e0d\u5b58\u5728\u3002");
        }
        Set<Long> resourceIds = list.stream().filter(p -> p.getResourceId() != null && p.getResourceId() > 0L).map(ResourcesetDto::getResourceId).collect(Collectors.toSet());
        ArrayList<ResourceExtendDto> resourceDtos = new ArrayList<ResourceExtendDto>(list.size());
        List<ResourceExtendDto> moduleResources = this.getModuleResource(resourceIds);
        if (CollectionUtils.isNotEmpty(moduleResources)) {
            resourceDtos.addAll(moduleResources);
        }
        if (CollectionUtils.isNotEmpty(childResources = this.getChildrenResource(list))) {
            resourceDtos.addAll(childResources);
        }
        ArrayList<ResourcesetExtendDto> extendList = new ArrayList<ResourcesetExtendDto>(list.size());
        Map<Long, Integer> moduleResourceIdAndIndex = this.getModuleResourceIdAndIndex(moduleResources);
        for (ResourcesetDto resourcesetDto : list) {
            ResourcesetExtendDto resourcesetExtendDto = new ResourcesetExtendDto();
            BeanUtils.copyProperties((Object)resourcesetDto, (Object)resourcesetExtendDto);
            Integer relResourceIndex = moduleResourceIdAndIndex.get(resourcesetDto.getResourceId());
            if (relResourceIndex != null) {
                resourcesetExtendDto.setRelResourceIndex(Integer.valueOf(relResourceIndex + 1));
            }
            extendList.add(resourcesetExtendDto);
        }
        ResourcesetWrapper result = new ResourcesetWrapper();
        result.setResourcesets(extendList);
        result.setResources(resourceDtos);
        return result;
    }

    private Map<Long, Integer> getModuleResourceIdAndIndex(List<ResourceExtendDto> list) {
        HashMap<Long, Integer> map = new HashMap<Long, Integer>(list.size());
        if (list.isEmpty()) {
            return map;
        }
        for (int i = 0; i < list.size(); ++i) {
            ResourceDto resourceDto = (ResourceDto)list.get(i);
            if (resourceDto.getResourceId() == null || resourceDto.getResourceId() <= 0L) continue;
            map.put(resourceDto.getResourceId(), i);
        }
        return map;
    }

    private List<ResourceExtendDto> getResource(Set<Long> resourceIds, List<Resourceset> list) {
        List<ResourceExtendDto> childResources;
        ArrayList<ResourceExtendDto> resourceList = new ArrayList<ResourceExtendDto>(list.size());
        List<ResourceExtendDto> moduleResources = this.getModuleResource(resourceIds);
        if (CollectionUtils.isNotEmpty(moduleResources)) {
            resourceList.addAll(moduleResources);
        }
        if (CollectionUtils.isNotEmpty(childResources = this.getChildrenResource(list))) {
            resourceList.addAll(childResources);
        }
        return resourceList;
    }

    private List<ResourceExtendDto> getChildrenResource(List<Resourceset> list) {
        ArrayList<ResourceExtendDto> resourceList = new ArrayList<ResourceExtendDto>();
        List resourcesetIds = list.stream().map(ResourcesetDto::getResourcesetId).collect(Collectors.toList());
        Specification specification = QueryUtils.getSpecification("resourcesetId", resourcesetIds);
        List rels = this.resourcesetResourceRelDao.findAll(specification, Sort.unsorted());
        if (CollectionUtils.isEmpty((Collection)rels)) {
            return new ArrayList<ResourceExtendDto>();
        }
        List relIds = rels.stream().map(ResourcesetResourceRel::getResourceId).collect(Collectors.toList());
        Specification finalSpecification = QueryUtils.getSpecification("resourceId", relIds);
        List<Resource> resources = this.resourceService.list((Specification<Resource>)finalSpecification, Sort.unsorted());
        if (CollectionUtils.isEmpty(resources)) {
            return new ArrayList<ResourceExtendDto>();
        }
        Map<Long, Integer> resourcesetIdAndSetIndex = this.getResourcesetIdAndSetIndex(list);
        Map<Long, Integer> resourceIdAndResourceIndex = this.getResourceIdAndResourceIndex(resources);
        for (ResourcesetResourceRel resourcesetResourceRel : rels) {
            int resourceIndex = resourceIdAndResourceIndex.get(resourcesetResourceRel.getResourceId());
            Resource resource = resources.get(resourceIndex - 1);
            ResourceExtendDto resourceExtendDto = new ResourceExtendDto();
            BeanUtils.copyProperties((Object)resource, (Object)resourceExtendDto);
            Integer relSetIndex = resourcesetIdAndSetIndex.get(resourcesetResourceRel.getResourcesetId());
            if (relSetIndex != null) {
                resourceExtendDto.setRelSetIndex(relSetIndex);
            }
            resourceList.add(resourceExtendDto);
        }
        return resourceList;
    }

    private List<ResourceExtendDto> getModuleResource(Set<Long> resourceIds) {
        if (CollectionUtils.isEmpty(resourceIds)) {
            return new ArrayList<ResourceExtendDto>();
        }
        ArrayList<ResourceExtendDto> resourceList = new ArrayList<ResourceExtendDto>(resourceIds.size());
        Specification specification = QueryUtils.getSpecification("resourceId", Lists.newArrayList(resourceIds));
        List<Resource> resources = this.resourceService.list((Specification<Resource>)specification, Sort.unsorted());
        for (Resource resource : resources) {
            ResourceExtendDto resourceExtendDto = new ResourceExtendDto();
            BeanUtils.copyProperties((Object)resource, (Object)resourceExtendDto);
            resourceList.add(resourceExtendDto);
        }
        return resourceList;
    }

    private Map<Long, Integer> getResourceIdAndSetIndex(List<ResourcesetResourceRel> rels, Map<Long, Integer> resourcesetIdAndIndex) {
        HashMap<Long, Integer> map = new HashMap<Long, Integer>(rels.size());
        if (rels.isEmpty()) {
            return map;
        }
        for (ResourcesetResourceRel resourcesetResourceRel : rels) {
            Integer index = resourcesetIdAndIndex.get(resourcesetResourceRel.getResourcesetId());
            map.put(resourcesetResourceRel.getResourceId(), index);
        }
        return map;
    }

    private Map<Long, Integer> getResourcesetIdAndSetIndex(List<Resourceset> list) {
        HashMap<Long, Integer> map = new HashMap<Long, Integer>(list.size());
        if (list.isEmpty()) {
            return map;
        }
        for (int i = 0; i < list.size(); ++i) {
            ResourcesetDto resourcesetDto = (ResourcesetDto)list.get(i);
            map.put(resourcesetDto.getResourcesetId(), i + 1);
        }
        return map;
    }

    private Map<Long, Integer> getResourceIdAndResourceIndex(List<Resource> list) {
        HashMap<Long, Integer> map = new HashMap<Long, Integer>(list.size());
        if (list.isEmpty()) {
            return map;
        }
        for (int i = 0; i < list.size(); ++i) {
            Resource resource = list.get(i);
            map.put(resource.getResourceId(), i + 1);
        }
        return map;
    }

    public ResourcesetWrapper saveResourcesetData(ResourcesetWrapper wrapper) {
        ResourcesetWrapper result = new ResourcesetWrapper();
        List<ResourceExtendDto> resourceExtendDtoList = wrapper.getResources();
        List<String> resourceCodes = resourceExtendDtoList.stream().map(ResourceDto::getResourceCode).collect(Collectors.toList());
        List<Resource> resources = this.resourcePortService.getResourceByCodes(resourceCodes);
        Map<String, Resource> codeAndResourceMap = this.getCodeAndResourceMap(resources);
        List<ResourcesetExtendDto> resourcesets = this.saveResourceset(wrapper.getResourcesets(), wrapper.getResources(), codeAndResourceMap);
        List<ResourceExtendDto> resourceExtends = this.saveResourceRel(wrapper.getResourcesets(), wrapper.getResources(), codeAndResourceMap);
        result.setResourcesets(resourcesets);
        result.setResources(resourceExtends);
        return result;
    }

    private List<ResourceExtendDto> saveResourceRel(List<ResourcesetExtendDto> resourcesets, List<ResourceExtendDto> resources, Map<String, Resource> codeAndResourceMap) {
        ArrayList<ResourceExtendDto> existList = new ArrayList<ResourceExtendDto>();
        for (ResourceExtendDto item : resources) {
            if (null == item.getAppId() || !this.appDao.existsById((Object)item.getAppId())) {
                item.setReason("\u65e0\u6548\u7684appId\u3002");
                existList.add(item);
                continue;
            }
            if (item.getRelSetIndex() == null || item.getRelSetIndex() <= 0) continue;
            ResourcesetExtendDto resourcesetExtendDto = resourcesets.get(item.getRelSetIndex() - 1);
            ResourceDto resourceDto = (ResourceDto)codeAndResourceMap.get(this.getResourceCodeKey(item.getResourceCode(), item.getAppId()));
            if (resourceDto == null) {
                item.setReason("\u6570\u636e\u5e93\u6ca1\u6709\u5bf9\u5e94\u8d44\u6e90\u7801\uff0c\u8bf7\u5148\u5bfc\u5165\u6539\u8d44\u6e90\u7801\u3002");
                existList.add(item);
                log.info("\u6ca1\u6709\u627e\u5230\u8d44\u6e90\u7801id=={}", (Object)item.getResourceCode());
                continue;
            }
            boolean exists = this.resourcesetService.saveResourceRel(resourcesetExtendDto.getResourcesetId(), resourceDto.getResourceId(), this.operateUserName);
            if (!exists) continue;
            item.setReason("\u8be5\u529f\u80fd\u96c6\u5df2\u7ecf\u548c\u8be5\u8d44\u6e90\u7801\u5173\u8054,\u3002");
            existList.add(item);
        }
        return existList;
    }

    private Map<String, Resource> getCodeAndResourceMap(List<Resource> resources) {
        HashMap<String, Resource> map = new HashMap<String, Resource>(resources.size());
        if (resources.isEmpty()) {
            return map;
        }
        for (Resource resource : resources) {
            map.put(this.getResourceCodeKey(resource.getResourceCode(), resource.getAppId()), resource);
        }
        return map;
    }

    private String getResourceCodeKey(String resourceCode, Long appId) {
        String appIdStr = appId == null ? "" : String.valueOf(appId);
        return resourceCode + "_" + appIdStr;
    }

    private List<ResourcesetExtendDto> saveResourceset(List<ResourcesetExtendDto> resourcesets, List<ResourceExtendDto> resources, Map<String, Resource> codeAndResourceMap) {
        ArrayList<ResourcesetExtendDto> existLists = new ArrayList<ResourcesetExtendDto>();
        for (ResourcesetExtendDto item : resourcesets) {
            ResourcesetDto resourcesetDto;
            if (null == item.getAppId() || !this.appDao.existsById((Object)item.getAppId())) {
                item.setReason("\u65e0\u6548\u7684appId\u3002");
                existLists.add(item);
                continue;
            }
            item.setResourceId(Long.valueOf(0L));
            if (item.getRelResourceIndex() != null && item.getRelResourceIndex() > 0) {
                ResourceExtendDto resourceExtendDto = resources.get(item.getRelResourceIndex() - 1);
                ResourceDto resourceDto = (ResourceDto)codeAndResourceMap.get(this.getResourceCodeKey(resourceExtendDto.getResourceCode(), resourceExtendDto.getAppId()));
                if (resourceDto != null) {
                    item.setResourceId(resourceDto.getResourceId());
                } else {
                    log.info("\u6ca1\u6709\u627e\u5230\u6a21\u5757\u8d44\u6e90\u7801id=={}", (Object)resourceExtendDto.getResourceCode());
                }
            }
            if ((resourcesetDto = this.isResourcesetExists(item)) != null) {
                BeanUtils.copyProperties((Object)resourcesetDto, (Object)item);
                item.setReason("\u8be5\u529f\u80fd\u96c6\u5df2\u7ecf\u5b58\u5728\u3002id==" + resourcesetDto.getResourcesetId());
                existLists.add(item);
                continue;
            }
            resourcesetDto = this.resourcesetService.save(item);
            item.setResourcesetId(resourcesetDto.getResourcesetId());
        }
        return existLists;
    }

    private ResourcesetDto isResourcesetExists(final ResourcesetExtendDto item) {
        if (StringUtils.isBlank((CharSequence)item.getResourcesetName()) || item.getResourceId() == null) {
            return null;
        }
        List<Resourceset> list = this.resourcesetService.list(new Specification<Resourceset>(){

            public Predicate toPredicate(Root<Resourceset> root, CriteriaQuery<?> query, CriteriaBuilder builder) {
                ArrayList<Predicate> predicates = new ArrayList<Predicate>();
                predicates.add(builder.equal((Expression)root.get("resourcesetName"), (Object)item.getResourcesetName()));
                if (item.getAppId() != null && item.getAppId() > 0L) {
                    predicates.add(builder.equal((Expression)root.get("appId"), (Object)item.getAppId()));
                }
                if (!predicates.isEmpty()) {
                    query.where((Predicate[])predicates.stream().toArray(Predicate[]::new));
                }
                return query.getRestriction();
            }
        }, Sort.unsorted());
        if (CollectionUtils.isEmpty(list)) {
            return null;
        }
        return (ResourcesetDto)list.get(0);
    }
}

