/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.business.resource.service;

import com.alibaba.excel.event.AnalysisEventListener;
import com.xforceplus.api.model.ServicePackageModel;
import com.xforceplus.bo.ServicePackageQueryBo;
import com.xforceplus.business.app.service.AppService;
import com.xforceplus.business.excel.BusinessType;
import com.xforceplus.business.excel.ExcelSheet;
import com.xforceplus.business.excel.SimpleExcelWriter;
import com.xforceplus.business.excel.reader.Context;
import com.xforceplus.business.excel.reader.MessageRow;
import com.xforceplus.business.excel.reader.SimpleDataReadListener;
import com.xforceplus.business.excel.writer.ExcelConfigBusinessType;
import com.xforceplus.business.resource.dto.ServicePackageExcelDTO;
import com.xforceplus.business.resource.dto.ServicePackageResourceSetExcelDTO;
import com.xforceplus.business.resource.service.ResourceExcelServiceImpl;
import com.xforceplus.business.resource.service.ResourcesetService;
import com.xforceplus.business.resource.service.ServicePackageService;
import com.xforceplus.business.service.ExcelReaderService;
import com.xforceplus.business.service.ExcelWriteService;
import com.xforceplus.dto.resource.ServicePackageDTO;
import com.xforceplus.entity.App;
import com.xforceplus.entity.Resourceset;
import com.xforceplus.entity.ServicePackage;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.NumberUtils;

@Service
public class ServicePackageExcelExportServiceImpl
implements ExcelWriteService,
ExcelReaderService {
    private static final Logger log = LoggerFactory.getLogger(ResourceExcelServiceImpl.class);
    private final ServicePackageService servicePackageService;
    private final ResourcesetService resourcesetService;
    private final AppService appService;

    public ServicePackageExcelExportServiceImpl(ServicePackageService servicePackageService, ResourcesetService resourcesetService, AppService appService) {
        this.servicePackageService = servicePackageService;
        this.resourcesetService = resourcesetService;
        this.appService = appService;
    }

    @Override
    public BusinessType getBusinessType() {
        return ExcelConfigBusinessType.SERVICE_PACKAGE_EXCEL_FILE;
    }

    @Override
    public Context importExcel(Context context) {
        List<ExcelSheet> sheets = context.getExcelBook().getExcelSheets();
        for (ExcelSheet sheet : sheets) {
            MessageRow messageRows;
            String sheetName = sheet.getSheetName();
            if ("\u4ea7\u54c1\u670d\u52a1\u5305".equals(sheetName)) {
                messageRows = new MessageRow(sheetName);
                List<Long> appIds = this.findAllByApp();
                AnalysisEventListener excelDataListener = SimpleDataReadListener.listener(context, rows -> this.saveServicePackage(messageRows, context, (List<ServicePackageExcelDTO>)rows, appIds));
                context.getSimpleExcelReader().read(ServicePackageExcelDTO.class, excelDataListener, sheetName);
                continue;
            }
            if (!"\u5173\u8054\u529f\u80fd\u96c6".equals(sheetName)) continue;
            messageRows = new MessageRow(sheetName);
            AnalysisEventListener excelDataListener = SimpleDataReadListener.listener(context, rows -> this.saveServicePackageResourceSet(messageRows, context, (List<ServicePackageResourceSetExcelDTO>)rows));
            context.getSimpleExcelReader().read(ServicePackageResourceSetExcelDTO.class, excelDataListener, sheetName);
        }
        return context;
    }

    private void saveServicePackageResourceSet(MessageRow messageRows, Context context, List<ServicePackageResourceSetExcelDTO> rows) {
        if (CollectionUtils.isEmpty(rows)) {
            return;
        }
        for (ServicePackageResourceSetExcelDTO row : rows) {
            try {
                if (!row.getValidatedStatus().booleanValue()) {
                    messageRows.fail(row.getRowIndex(), row.getValidatedMessage());
                    continue;
                }
                if ("\u7ed1\u5b9a".equals(row.getAction())) {
                    this.bindResourceSets(messageRows, row);
                    continue;
                }
                if (!"\u89e3\u7ed1".equals(row.getAction())) continue;
                this.unBindResourceSets(messageRows, row);
            }
            catch (Exception ex) {
                log.error(ex.getMessage(), (Throwable)ex);
                messageRows.fail(row.getRowIndex(), row.getAction() + "\u6570\u636e\u5931\u8d25");
            }
        }
        context.messageRow(messageRows.getSheetName(), messageRows);
    }

    private void unBindResourceSets(MessageRow messageRows, ServicePackageResourceSetExcelDTO row) {
        Optional<Resourceset> resourceSetOptional;
        Optional<ServicePackage> servicePackageOptional;
        String servicePackageCode = row.getServicePackageCode();
        try {
            servicePackageOptional = this.findByServicePackageCode(servicePackageCode);
            if (!servicePackageOptional.isPresent()) {
                messageRows.fail(row.getRowIndex(), "\u3010" + servicePackageCode + "\u3011" + "\u4ea7\u54c1\u670d\u5305\u6570\u636e\u4e0d\u5b58\u5728");
                return;
            }
        }
        catch (IllegalArgumentException e) {
            messageRows.fail(row.getRowIndex(), e.getMessage());
            return;
        }
        String resourceSetCode = row.getResourceSetCode();
        try {
            resourceSetOptional = this.findByResourceSetCode(resourceSetCode);
            if (!resourceSetOptional.isPresent()) {
                messageRows.fail(row.getRowIndex(), "\u3010" + resourceSetCode + "\u3011" + "\u529f\u80fd\u96c6\u6570\u636e\u4e0d\u5b58\u5728");
                return;
            }
        }
        catch (IllegalArgumentException e) {
            messageRows.fail(row.getRowIndex(), e.getMessage());
            return;
        }
        if (!resourceSetOptional.isPresent()) {
            messageRows.fail(row.getRowIndex(), "\u3010" + resourceSetCode + "\u3011" + "\u529f\u80fd\u96c6\u6570\u636e\u4e0d\u5b58\u5728");
            return;
        }
        try {
            Long servicePackageId = servicePackageOptional.get().getServicePackageId();
            Long resourceSetId = resourceSetOptional.get().getResourcesetId();
            this.servicePackageService.unBindResourceSets(servicePackageId, resourceSetId);
            messageRows.success(row.getRowIndex());
        }
        catch (Exception e) {
            messageRows.fail(row.getRowIndex(), "\u89e3\u7ed1:" + e.getMessage());
        }
    }

    private void bindResourceSets(MessageRow messageRows, ServicePackageResourceSetExcelDTO row) {
        Optional<Resourceset> resourceSetOptional;
        Optional<ServicePackage> servicePackageOptional;
        String servicePackageCode = row.getServicePackageCode();
        try {
            servicePackageOptional = this.findByServicePackageCode(servicePackageCode);
            if (!servicePackageOptional.isPresent()) {
                messageRows.fail(row.getRowIndex(), "\u3010" + servicePackageCode + "\u3011" + "\u4ea7\u54c1\u670d\u5305\u6570\u636e\u4e0d\u5b58\u5728");
                return;
            }
        }
        catch (IllegalArgumentException e) {
            messageRows.fail(row.getRowIndex(), e.getMessage());
            return;
        }
        String resourceSetCode = row.getResourceSetCode();
        try {
            resourceSetOptional = this.findByResourceSetCode(resourceSetCode);
            if (!resourceSetOptional.isPresent()) {
                messageRows.fail(row.getRowIndex(), "\u3010" + resourceSetCode + "\u3011" + "\u529f\u80fd\u96c6\u6570\u636e\u4e0d\u5b58\u5728");
                return;
            }
        }
        catch (IllegalArgumentException e) {
            messageRows.fail(row.getRowIndex(), e.getMessage());
            return;
        }
        ServicePackageModel.Request.BindResourceSets bindResourceSets = new ServicePackageModel.Request.BindResourceSets();
        bindResourceSets.setOverwrite(false);
        bindResourceSets.setResourcesetIds(Arrays.asList(resourceSetOptional.get().getResourcesetId()));
        try {
            this.servicePackageService.bindResourceSets(servicePackageOptional.get(), bindResourceSets);
            messageRows.success(row.getRowIndex());
        }
        catch (Exception e) {
            messageRows.fail(row.getRowIndex(), "\u7ed1\u5b9a:" + e.getMessage());
        }
    }

    private Optional<Resourceset> findByResourceSetCode(String resourceSetCode) {
        return this.resourcesetService.findByResourceSetCode(resourceSetCode);
    }

    private Optional<ServicePackage> findByServicePackageCode(String servicePackageCode) {
        return this.servicePackageService.findByServicePackageCode(servicePackageCode);
    }

    private void saveServicePackage(MessageRow messageRows, Context context, List<ServicePackageExcelDTO> rows, List<Long> appIds) {
        if (CollectionUtils.isEmpty(rows)) {
            return;
        }
        for (ServicePackageExcelDTO row : rows) {
            try {
                if (!row.getValidatedStatus().booleanValue()) {
                    messageRows.fail(row.getRowIndex(), row.getValidatedMessage());
                    continue;
                }
                if ("\u65b0\u589e".equals(row.getAction())) {
                    this.saveServicePackage(messageRows, row, appIds);
                    continue;
                }
                if (!"\u4fee\u6539".equals(row.getAction())) continue;
                this.updateServicePackage(messageRows, row, appIds);
            }
            catch (Exception ex) {
                log.error(ex.getMessage(), (Throwable)ex);
                messageRows.fail(row.getRowIndex(), row.getAction() + "\u6570\u636e\u5931\u8d25");
            }
        }
        context.messageRow(messageRows.getSheetName(), messageRows);
    }

    private void saveServicePackage(MessageRow messageRows, ServicePackageExcelDTO row, List<Long> appIds) {
        Long appId = (Long)NumberUtils.parseNumber((String)row.getAppId(), Long.class);
        if (!appIds.contains(appId)) {
            messageRows.fail(row.getRowIndex(), "\u3010" + appId + "\u3011" + "APP\u7684\u6570\u636e\u4e0d\u5b58\u5728");
            return;
        }
        String servicePackageCode = row.getServicePackageCode();
        try {
            Optional<ServicePackage> servicePackageOptional = this.findByServicePackageCode(servicePackageCode);
            if (servicePackageOptional.isPresent()) {
                messageRows.fail(row.getRowIndex(), "\u3010" + servicePackageCode + "\u3011\u4ea7\u54c1\u670d\u5305\u6570\u636e\u5df2\u5b58\u5728");
                return;
            }
        }
        catch (IllegalArgumentException e) {
            messageRows.fail(row.getRowIndex(), e.getMessage());
            return;
        }
        Integer status = (Integer)NumberUtils.parseNumber((String)row.getStatus(), Integer.class);
        ServicePackageModel.Request.Save save = new ServicePackageModel.Request.Save();
        save.setAppId(appId);
        save.setServicePackageName(row.getServicePackageName());
        save.setServicePackageCode(row.getServicePackageCode());
        save.setServicePackageDesc(row.getServicePackageName());
        save.setStatus(status);
        try {
            this.servicePackageService.create(save);
            messageRows.success(row.getRowIndex());
        }
        catch (Exception e) {
            messageRows.fail(row.getRowIndex(), e.getMessage());
        }
    }

    private List<Long> findAllByApp() {
        List<App> appList = this.appService.list();
        if (CollectionUtils.isEmpty(appList)) {
            return Collections.emptyList();
        }
        return appList.stream().map(App::getAppId).collect(Collectors.toList());
    }

    private void updateServicePackage(MessageRow messageRows, ServicePackageExcelDTO row, List<Long> appIds) {
        Optional<ServicePackage> servicePackageOptional;
        Long appId = (Long)NumberUtils.parseNumber((String)row.getAppId(), Long.class);
        if (!appIds.contains(appId)) {
            messageRows.fail(row.getRowIndex(), "\u3010" + appId + "\u3011" + "APP\u7684\u6570\u636e\u4e0d\u5b58\u5728");
            return;
        }
        String servicePackageCode = row.getServicePackageCode();
        try {
            servicePackageOptional = this.findByServicePackageCode(servicePackageCode);
            if (!servicePackageOptional.isPresent()) {
                messageRows.fail(row.getRowIndex(), "\u3010" + servicePackageCode + "\u3011" + "\u4ea7\u54c1\u670d\u5305\u6570\u636e\u4e0d\u5b58\u5728");
                return;
            }
        }
        catch (IllegalArgumentException e) {
            messageRows.fail(row.getRowIndex(), e.getMessage());
            return;
        }
        Integer status = (Integer)NumberUtils.parseNumber((String)row.getStatus(), Integer.class);
        ServicePackageModel.Request.Save save = new ServicePackageModel.Request.Save();
        save.setAppId(appId);
        save.setServicePackageName(row.getServicePackageName());
        save.setServicePackageCode(row.getServicePackageCode());
        save.setServicePackageDesc(row.getServicePackageName());
        save.setStatus(status);
        try {
            this.servicePackageService.update(servicePackageOptional.get().getServicePackageId(), save);
            messageRows.success(row.getRowIndex());
        }
        catch (Exception e) {
            messageRows.fail(row.getRowIndex(), e.getMessage());
        }
    }

    @Override
    public void write(Context context) {
        ServicePackageModel.Request.Query query = context.getParam("P_QUERY", ServicePackageModel.Request.Query.class);
        Sort sort = context.getParam("P_SORT", Sort.class);
        List<String> sheetNames = Arrays.asList(query.getSheets());
        SimpleExcelWriter simpleExcelWriter = context.getSimpleExcelWriter();
        Integer maxPageSize = context.getMaxPageSize();
        ServicePackageQueryBo queryBo = new ServicePackageQueryBo();
        BeanUtils.copyProperties((Object)query, (Object)queryBo);
        for (String sheetName : sheetNames) {
            Page<ServicePackageDTO> page;
            PageRequest pageable;
            if ("\u4ea7\u54c1\u670d\u52a1\u5305".equals(sheetName)) {
                pageable = PageRequest.of((int)0, (int)1000, (Sort)sort.and(Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"createTime"})));
                do {
                    page = this.servicePackageService.pagingBy((Pageable)pageable, queryBo);
                    Page packageExcelPage = page.map(e -> {
                        ServicePackageExcelDTO dto = new ServicePackageExcelDTO();
                        dto.setAppId(e.getAppId() == null ? "" : String.valueOf(e.getAppId()));
                        dto.setServicePackageCode(StringUtils.trimToEmpty((String)e.getServicePackageCode()));
                        dto.setServicePackageName(StringUtils.trimToEmpty((String)e.getServicePackageName()));
                        dto.setStatus(e.getStatus() == null ? "" : String.valueOf(e.getStatus()));
                        return dto;
                    });
                    simpleExcelWriter.fill(sheetName, packageExcelPage.getContent());
                } while (page.hasNext() && (pageable = pageable.next()) != null && page.getNumber() < maxPageSize);
                simpleExcelWriter.param("SUCCESS_SIZE", this.calcSuccessSize(page));
            }
            if (!"\u5173\u8054\u529f\u80fd\u96c6".equals(sheetName)) continue;
            pageable = PageRequest.of((int)0, (int)1000, (Sort)sort.and(Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"createTime"})));
            do {
                page = this.servicePackageService.pagingByResourceSet((Pageable)pageable, queryBo);
                Page excelPage = page.map(e -> {
                    ServicePackageResourceSetExcelDTO dto = new ServicePackageResourceSetExcelDTO();
                    dto.setResourceSetCode(StringUtils.trimToEmpty((String)e.getResourceSetCode()));
                    dto.setServicePackageCode(StringUtils.trimToEmpty((String)e.getServicePackageCode()));
                    return dto;
                });
                simpleExcelWriter.fill(sheetName, excelPage.getContent());
            } while (page.hasNext() && (pageable = pageable.next()) != null && page.getNumber() < maxPageSize);
            simpleExcelWriter.param("SUCCESS_SIZE", this.calcSuccessSize(page));
        }
    }

    protected static final class Message {
        public static final String SERVICE_PACKAGE_NOT_FIND = "\u4ea7\u54c1\u670d\u5305\u6570\u636e\u4e0d\u5b58\u5728";
        public static final String RESOURCE_SET_NOT_FIND = "\u529f\u80fd\u96c6\u6570\u636e\u4e0d\u5b58\u5728";
        public static final String APP_NOT_FIND = "APP\u7684\u6570\u636e\u4e0d\u5b58\u5728";

        protected Message() {
        }
    }
}

