/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.business.settle.service;

import com.xforceplus.dao.SettleFlowDao;
import com.xforceplus.dao.SettleFlowTemplateRelDao;
import com.xforceplus.dao.SettleTemplateDao;
import com.xforceplus.entity.SettleFlowTemplateRel;
import com.xforceplus.entity.SettleTemplate;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class SettleTemplateService {
    private static final Logger logger = LoggerFactory.getLogger(SettleTemplateService.class);
    private final SettleTemplateDao templateDao;
    private final SettleFlowDao flowDao;
    private final SettleFlowTemplateRelDao flowTemplateRelDao;

    public SettleTemplateService(SettleTemplateDao templateDao, SettleFlowDao flowDao, SettleFlowTemplateRelDao flowTemplateRelDao) {
        this.templateDao = templateDao;
        this.flowDao = flowDao;
        this.flowTemplateRelDao = flowTemplateRelDao;
    }

    public SettleTemplate findById(long templateId) {
        return (SettleTemplate)this.templateDao.findById(Long.valueOf(templateId)).orElseThrow(() -> new IllegalArgumentException("\u672a\u627e\u5230\u5165\u9a7b\u9875\u9762\u6a21\u7248"));
    }

    public List<SettleTemplate> findByFlowId(long flowId) {
        List templates = this.flowDao.findTemplateByFlowId(flowId);
        for (SettleTemplate template : templates) {
            List serviceCodes = this.templateDao.findServiceCodesByTemplateId(template.getTemplateId().longValue());
            SettleFlowTemplateRel settleFlowTemplateRel = this.flowTemplateRelDao.findAndByFlowIdAndTemplateId(flowId, template.getTemplateId());
            template.setServiceCodes(serviceCodes);
            template.setPageIndex(settleFlowTemplateRel.getPageIndex());
        }
        return templates;
    }
}

