/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.business.tenant.controller;

import com.fasterxml.jackson.annotation.JsonView;
import com.xforceplus.api.common.response.ResponseEntity;
import com.xforceplus.api.current.user.OrgRoleApi;
import com.xforceplus.api.model.RoleModel;
import com.xforceplus.api.model.UserModel;
import com.xforceplus.business.common.controller.AbstractController;
import com.xforceplus.business.tenant.service.OrgRoleService;
import com.xforceplus.domain.tenant.OrgRoleDTO;
import com.xforceplus.entity.Resourceset;
import com.xforceplus.entity.Role;
import com.xforceplus.entity.User;
import com.xforceplus.tenant.security.autoscan.annotation.AuthorizedDefinition;
import com.xforceplus.tenant.security.core.context.UserInfoHolder;
import com.xforceplus.tenant.security.core.domain.IAuthorizedUser;
import com.xforceplus.tenant.security.core.domain.view.UserView;
import io.geewit.data.jpa.essential.domain.PageableFactory;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.List;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Controller;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PathVariable;

@Api(value="\u7ec4\u7ec7\u89d2\u8272\u7ba1\u7406", tags={"\u7ec4\u7ec7\u89d2\u8272\u7ba1\u7406"})
@Controller
@Valid
public class OrgRoleController
extends AbstractController
implements OrgRoleApi {
    @Autowired
    private OrgRoleService orgRoleService;

    @AuthorizedDefinition(resources={"xforce:ucenter:roleclass:read"})
    @ApiOperation(value="\u6307\u5b9a\u5206\u7ea7\u89d2\u8272\u7684\u7ec4\u7ec7\u89d2\u8272\u5206\u9875")
    public ResponseEntity<Page<OrgRoleDTO>> currentPage(RoleModel.Request.Query query, Pageable pageable) {
        if (null == query.getFromRoleId()) {
            throw new IllegalArgumentException("\u53c2\u6570\u9519\u8bef\uff0c \u5fc5\u987b\u6307\u5b9a\u6765\u6e90\u5206\u7ea7\u89d2\u8272id");
        }
        IAuthorizedUser authorizedUser = UserInfoHolder.currentUser();
        long tenantId = authorizedUser.getTenantId();
        query.setTenantId(Long.valueOf(tenantId));
        Page<OrgRoleDTO> page = this.orgRoleService.page(query, pageable);
        return ResponseEntity.ok(page);
    }

    @AuthorizedDefinition(resources={"xforce:ucenter:roleclass:save"})
    @ApiOperation(value="\u65b0\u589e\u7ec4\u7ec7\u89d2\u8272")
    public ResponseEntity<Role> currentCreate(@ApiParam(value="model", required=true) @Validated RoleModel.Request.OrgRoleCreate model) {
        IAuthorizedUser authorizedUser = UserInfoHolder.currentUser();
        long tenantId = authorizedUser.getTenantId();
        model.setTenantId(Long.valueOf(tenantId));
        model.setType(Integer.valueOf(2));
        Role role = this.orgRoleService.create(model);
        return ResponseEntity.ok((Object)role);
    }

    @AuthorizedDefinition(resources={"xforce:ucenter:roleclass:read"})
    @ApiOperation(value="\u7ec4\u7ec7\u89d2\u8272\u8be6\u60c5")
    public ResponseEntity<OrgRoleDTO> currentInfo(Long roleId) {
        return ResponseEntity.ok((Object)this.orgRoleService.findByRoleId(roleId));
    }

    @AuthorizedDefinition(resources={"xforce:ucenter:roleclass:save"})
    @ApiOperation(value="\u7ec4\u7ec7\u89d2\u8272\u7f16\u8f91")
    public ResponseEntity<OrgRoleDTO> currentUpdate(Long roleId, @Validated RoleModel.Request.OrgRoleUpdate model) {
        IAuthorizedUser authorizedUser = UserInfoHolder.currentUser();
        long tenantId = authorizedUser.getTenantId();
        OrgRoleDTO result = this.orgRoleService.updateByTenantId(tenantId, roleId, model);
        return ResponseEntity.ok((Object)result);
    }

    @AuthorizedDefinition(resources={"xforce:ucenter:roleclass:save"})
    @ApiOperation(value="\u7ec4\u7ec7\u89d2\u8272\u5220\u9664")
    public ResponseEntity<String> currentDelete(Long roleId) {
        IAuthorizedUser authorizedUser = UserInfoHolder.currentUser();
        long tenantId = authorizedUser.getTenantId();
        this.orgRoleService.deleteByTenantIdAndId(tenantId, roleId);
        return ResponseEntity.ok((Object)"\u5220\u9664\u6210\u529f");
    }

    @AuthorizedDefinition(resources={"xforce:ucenter:roleclass:read"})
    @ApiOperation(value="\u7ec4\u7ec7\u89d2\u8272\u5df2\u7ed1\u5b9a\u7684\u7528\u6237\u5206\u9875\u5217\u8868")
    @JsonView(value={UserView.UserInfo.class})
    public ResponseEntity<Page<User>> currentBindedUsers(Long roleId, UserModel.Request.Query query, Pageable pageable) {
        IAuthorizedUser authorizedUser = UserInfoHolder.currentUser();
        long tenantId = authorizedUser.getTenantId();
        query.setTenantId(Long.valueOf(tenantId));
        query.setRoleId(roleId);
        Pageable currentPageable = PageableFactory.ofDefaultSort((Pageable)pageable, (Sort)Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"createTime"}));
        Page<User> result = this.userService.page(query, currentPageable);
        return ResponseEntity.ok(result);
    }

    @AuthorizedDefinition(resources={"xforce:ucenter:roleclass:save"})
    @ApiOperation(value="\u7ec4\u7ec7\u89d2\u8272\u7ed1\u5b9a\u7528\u6237")
    public ResponseEntity<String> currentBindRoles(Long roleId, RoleModel.Request.BindUsers bindUsers) {
        IAuthorizedUser authorizedUser = UserInfoHolder.currentUser();
        long tenantId = authorizedUser.getTenantId();
        this.roleService.bindUsers(tenantId, roleId, bindUsers, 2);
        return ResponseEntity.ok((Object)"\u7ed1\u5b9a\u6210\u529f");
    }

    @AuthorizedDefinition(resources={"xforce:ucenter:roleclass:save"})
    @ApiOperation(value="\u7ec4\u7ec7\u89d2\u8272\u89e3\u7ed1\u7528\u6237")
    public ResponseEntity<String> currentUnbindRoles(Long roleId, RoleModel.Request.UnbindUsers unbindUsers) {
        IAuthorizedUser authorizedUser = UserInfoHolder.currentUser();
        long tenantId = authorizedUser.getTenantId();
        this.roleService.unbindUsers(tenantId, roleId, unbindUsers);
        return ResponseEntity.ok((Object)"\u53cd\u7ed1\u5b9a\u6210\u529f");
    }

    @ApiOperation(value="\u83b7\u53d6\u7ec4\u7ec7\u89d2\u8272\u7684\u529f\u80fd\u96c6\u5217\u8868")
    @AuthorizedDefinition(resources={"xforce:ucenter:roleclass:read"})
    public ResponseEntity<List<Resourceset>> currentBindedResourcesets(Long roleId) {
        IAuthorizedUser authorizedUser = UserInfoHolder.currentUser();
        return ResponseEntity.ok(this.orgRoleService.findBindedResourcesetsByRoleId(roleId));
    }

    @AuthorizedDefinition(resources={"xforce:ucenter:roleclass:save"})
    public ResponseEntity<String> currentEnable(@PathVariable(value="roleId") Long roleId) {
        this.orgRoleService.enable(roleId);
        return ResponseEntity.ok((Object)"\u64cd\u4f5c\u6210\u529f");
    }

    @AuthorizedDefinition(resources={"xforce:ucenter:roleclass:save"})
    public ResponseEntity<String> currentDisable(@PathVariable(value="roleId") Long roleId) {
        this.orgRoleService.disable(roleId);
        return ResponseEntity.ok((Object)"\u64cd\u4f5c\u6210\u529f");
    }
}

